/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.sharing.ShareUtils;

public class StartServer {
    private static final LogIDs LOGID = LogIDs.GUI;
    private ServerSocket socket;
    private int state;
    private boolean bContinue;
    public static final int STATE_FAULTY = 0;
    public static final int STATE_LISTENING = 1;
    protected List queued_torrents = new ArrayList();
    protected boolean core_started = false;
    protected AEMonitor this_mon = new AEMonitor("StartServer");

    public StartServer() {
        try {
            this.socket = new ServerSocket(6880, 50, InetAddress.getByName("127.0.0.1"));
            this.state = 1;
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "StartServer: listening on 127.0.0.1:6880 for passed torrent info"));
            }
        }
        catch (Throwable t) {
            this.state = 0;
            String reason = t.getMessage() == null ? "<>" : t.getMessage();
            System.out.println("StartServer ERROR: unable to bind to 127.0.0.1:6880 listening for passed torrent info: " + reason);
        }
    }

    public void pollForConnections(final AzureusCore azureus_core) {
        azureus_core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            public void componentCreated(AzureusCore core, AzureusCoreComponent component) {
                if (component instanceof UIFunctionsSWT) {
                    StartServer.this.openQueuedTorrents(azureus_core);
                }
            }
        });
        if (this.socket != null) {
            AEThread t = new AEThread("Start Server"){

                public void runSupport() {
                    StartServer.this.pollForConnectionsSupport(azureus_core);
                }
            };
            t.setDaemon(true);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollForConnectionsSupport(AzureusCore azureus_core) {
        this.bContinue = true;
        while (this.bContinue) {
            BufferedReader br = null;
            try {
                Socket sck = this.socket.accept();
                String address = sck.getInetAddress().getHostAddress();
                if (address.equals("localhost") || address.equals("127.0.0.1")) {
                    String[] args;
                    br = new BufferedReader(new InputStreamReader(sck.getInputStream(), "UTF8"));
                    String line = br.readLine();
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Main::startServer: received '" + line + "'"));
                    }
                    if (line != null && (args = StartServer.parseArgs(line)) != null && args.length > 0) {
                        String debug_str = args[0];
                        for (int i = 1; i < args.length; ++i) {
                            debug_str = debug_str + " ; " + args[i];
                        }
                        Logger.log(new LogEvent(LOGID, "Main::startServer: decoded to '" + debug_str + "'"));
                        this.processArgs(azureus_core, args);
                    }
                }
                sck.close();
            }
            catch (Exception e) {
                if (e instanceof SocketException) continue;
                Debug.printStackTrace(e);
            }
            finally {
                try {
                    if (br == null) continue;
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static String[] parseArgs(String line) {
        if (!line.startsWith("Azureus Start Server Access;")) {
            return null;
        }
        ArrayList<String> parts = new ArrayList<String>();
        StringBuffer buf = new StringBuffer();
        boolean escape_mode = false;
        for (int i = "Azureus Start Server Access".length() + 1; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (escape_mode) {
                buf.append(c);
                escape_mode = false;
                continue;
            }
            if (c == '&') {
                escape_mode = true;
                continue;
            }
            if (c == ';') {
                parts.add(buf.toString());
                buf.setLength(0);
                continue;
            }
            buf.append(c);
        }
        if (buf.length() > 0) {
            parts.add(buf.toString());
        }
        return parts.toArray(new String[parts.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processArgs(AzureusCore azureus_core, String[] args) {
        if (args.length < 1 || !args[0].equals("args")) {
            return;
        }
        if (args.length == 1 || !COConfigurationManager.getBooleanParameter("add_torrents_silently")) {
            this.showMainWindow();
        }
        boolean open = true;
        for (int i = 1; i < args.length; ++i) {
            String file_name;
            File file;
            String arg = args[i];
            if (i == 1) {
                if (arg.equalsIgnoreCase("--closedown")) {
                    UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                    if (uiFunctions != null) {
                        uiFunctions.dispose(false, false);
                    }
                    return;
                }
                if (arg.equalsIgnoreCase("--open")) continue;
                if (arg.equalsIgnoreCase("--share")) {
                    open = false;
                    continue;
                }
            }
            if (!(file = new File(file_name = arg)).exists() && !this.isURI(file_name)) {
                byte[] hash;
                if (file_name.length() == 40) {
                    hash = null;
                    try {
                        hash = ByteFormatter.decodeString(file_name);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    if (hash != null && hash.length == 20) {
                        file_name = "magnet:?xt=urn:btih:" + Base32.encode(hash);
                    }
                }
                if (file_name.length() == 32) {
                    hash = null;
                    try {
                        hash = Base32.decode(file_name);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    if (hash != null && hash.length == 20) {
                        file_name = "magnet:?xt=urn:btih:" + file_name;
                    }
                }
            }
            if (this.isURI(file_name)) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "StartServer: args[" + i + "] handling as a URI: " + file_name));
                }
            } else {
                try {
                    if (!file.exists()) {
                        throw new Exception("File not found");
                    }
                    file_name = file.getCanonicalPath();
                    Logger.log(new LogEvent(LOGID, "StartServer: file = " + file_name));
                }
                catch (Throwable e) {
                    Logger.log(new LogAlert(true, 3, "Failed to access torrent file '" + file_name + "'. Ensure sufficient temporary file space " + "available (check browser cache usage)."));
                }
            }
            boolean queued = false;
            try {
                this.this_mon.enter();
                if (!this.core_started) {
                    this.queued_torrents.add(new Object[]{file_name, new Boolean(open)});
                    queued = true;
                }
            }
            finally {
                this.this_mon.exit();
            }
            if (queued) continue;
            this.handleFile(azureus_core, file_name, open);
        }
    }

    protected boolean isURI(String file_name) {
        String file_name_lower = file_name.toLowerCase();
        return file_name_lower.startsWith("http:") || file_name_lower.startsWith("https:") || file_name_lower.startsWith("magnet:") || file_name_lower.startsWith("dht:");
    }

    protected void handleFile(AzureusCore azureus_core, String file_name, boolean open) {
        try {
            if (open) {
                TorrentOpener.openTorrent(file_name);
            } else {
                File f = new File(file_name);
                if (f.isDirectory()) {
                    ShareUtils.shareDir(azureus_core, file_name);
                } else {
                    ShareUtils.shareFile(azureus_core, file_name);
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openQueuedTorrents(AzureusCore azureus_core) {
        try {
            this.this_mon.enter();
            this.core_started = true;
        }
        finally {
            this.this_mon.exit();
        }
        for (int i = 0; i < this.queued_torrents.size(); ++i) {
            Object[] entry = (Object[])this.queued_torrents.get(i);
            String file_name = (String)entry[0];
            boolean open = (Boolean)entry[1];
            this.handleFile(azureus_core, file_name, open);
        }
    }

    protected void showMainWindow() {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.bringToFront();
        }
    }

    public void stopIt() {
        this.bContinue = false;
        try {
            this.socket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getState() {
        return this.state;
    }

    public static void main(String[] args) {
        String[] input_tests = new String[]{"a;b;c", "test", "Azureus Start Server Access;b;c;d", "Azureus Start Server Access;b;c&;d;e", "Azureus Start Server Access;b;c&&;d;e", "Azureus Start Server Access;b;c&&&;d;e"};
        String[][] output_results = new String[][]{null, null, {"b", "c", "d"}, {"b", "c;d", "e"}, {"b", "c&", "d", "e"}, {"b", "c&;d", "e"}};
        for (int i = 0; i < input_tests.length; ++i) {
            System.out.println("Testing: " + input_tests[i]);
            Object[] result = StartServer.parseArgs(input_tests[i]);
            if (result == output_results[i] || Arrays.equals(result, output_results[i])) continue;
            System.out.println("TEST FAILED");
            System.out.println("  Expected: " + Arrays.asList(output_results[i]));
            System.out.println("  Decoded : " + Arrays.asList(result));
            System.exit(1);
        }
        System.out.println("Done.");
    }
}

