/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import java.util.HashMap;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderAdapter;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabFolderListener;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.plugins.PluginView;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.mainwindow.Refreshable;
import org.gudy.azureus2.ui.swt.plugins.UISWTPluginView;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.IViewExtension;
import org.gudy.azureus2.ui.swt.views.ManagerView;
import org.gudy.azureus2.ui.swt.views.MySharesView;
import org.gudy.azureus2.ui.swt.views.MyTorrentsSuperView;
import org.gudy.azureus2.ui.swt.views.MyTrackerView;

public class Tab
implements ParameterListener,
UIUpdatable {
    private static final LogIDs LOGID = LogIDs.GUI;
    private static final String ID = "TabSet";
    private HashMap tabs;
    private AEMonitor class_mon = new AEMonitor("TabSet");
    private boolean useCustomTab;
    private Composite folder;
    private boolean eventCloseAllowed = true;
    private Item selectedItem = null;
    private MainWindow mainwindow;
    private Listener activateListener;

    public Tab(MainWindow _mainWindow) {
        this.mainwindow = _mainWindow;
        this.tabs = new HashMap();
        COConfigurationManager.addParameterListener("GUI_SWT_bFancyTab", (ParameterListener)this);
        this.activateListener = new Listener(){

            public void handleEvent(Event event2) {
                Refreshable view = null;
                Composite parent = (Composite)event2.widget;
                IView oldView = Tab.this.getView(Tab.this.selectedItem);
                if (oldView instanceof IViewExtension) {
                    ((IViewExtension)((Object)oldView)).viewDeactivated();
                }
                while (parent != null && !parent.isDisposed() && view == null) {
                    TabItem[] selection;
                    CTabFolder folder;
                    if (parent instanceof CTabFolder) {
                        folder = (CTabFolder)parent;
                        Tab.this.selectedItem = (Item)folder.getSelection();
                        view = Tab.this.getView(Tab.this.selectedItem);
                    } else if (parent instanceof TabFolder && (selection = (folder = (TabFolder)parent).getSelection()).length > 0) {
                        Tab.this.selectedItem = (Item)selection[0];
                        view = Tab.this.getView(Tab.this.selectedItem);
                    }
                    if (view != null) continue;
                    parent = parent.getParent();
                }
                if (view != null) {
                    if (view instanceof IViewExtension) {
                        ((IViewExtension)((Object)view)).viewActivated();
                    }
                    view.refresh();
                }
            }
        };
        this.mainwindow.getUIFunctions().getUIUpdater().addUpdater(this);
    }

    public Composite createFolderWidget(Composite parent) {
        Display display = parent.getDisplay();
        if (this.tabs == null) {
            this.tabs = new HashMap();
        }
        if (this.folder != null && !this.folder.isDisposed()) {
            return this.folder;
        }
        this.useCustomTab = COConfigurationManager.getBooleanParameter("useCustomTab");
        if (!this.useCustomTab) {
            this.folder = new TabFolder(parent, 512);
        } else {
            this.folder = new CTabFolder(parent, 2112);
            float[] hsb = this.folder.getBackground().getRGB().getHSB();
            hsb[2] = (float)((double)hsb[2] * (Constants.isOSX ? 0.9 : 0.97));
            this.folder.setBackground(ColorCache.getColor((Device)parent.getDisplay(), hsb));
            hsb = this.folder.getForeground().getRGB().getHSB();
            hsb[2] = (float)((double)hsb[2] * (Constants.isOSX ? 1.1 : 0.03));
            this.folder.setForeground(ColorCache.getColor((Device)parent.getDisplay(), hsb));
            ((CTabFolder)this.folder).addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

                public void close(CTabFolderEvent event2) {
                    if (!Tab.this.closed((Item)event2.item)) {
                        event2.doit = false;
                    }
                }
            });
            this.folder.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent arg0) {
                    CTabItem tabItem = ((CTabFolder)Tab.this.folder).getItem(new Point(arg0.x, arg0.y));
                    if (arg0.button == 2) {
                        Rectangle rectangle;
                        if (Tab.this.eventCloseAllowed && (rectangle = tabItem.getBounds()).contains(arg0.x, arg0.y)) {
                            Tab.this.eventCloseAllowed = false;
                            Tab.this.selectedItem = null;
                            Tab.this.closed((Item)tabItem);
                        }
                    } else {
                        Tab.this.selectedItem = (Item)((CTabFolder)Tab.this.folder).getSelection();
                    }
                }

                public void mouseUp(MouseEvent arg0) {
                    Tab.this.eventCloseAllowed = true;
                    if (Tab.this.selectedItem != null) {
                        ((CTabFolder)Tab.this.folder).setSelection((CTabItem)Tab.this.selectedItem);
                    }
                }
            });
        }
        this.folder.getDisplay().addFilter(1, new Listener(){

            public void handleEvent(Event event2) {
                Control focus_control = Tab.this.folder.getDisplay().getFocusControl();
                if (focus_control != null && focus_control.getShell() != Tab.this.folder.getShell()) {
                    return;
                }
                int key = event2.character;
                if ((event2.stateMask & SWT.MOD1) != 0 && event2.character <= '\u001a' && event2.character > '\u0000') {
                    key += 96;
                }
                if (key == 27 || event2.keyCode == 0x100000D && event2.stateMask == 262144) {
                    Tab.this.closeCurrent();
                    event2.doit = false;
                } else if (event2.keyCode == 0x100000F || event2.character == '\t' && (event2.stateMask & 0x40000) != 0) {
                    if ((event2.stateMask & 0x20000) == 0) {
                        event2.doit = false;
                        Tab.this.selectNextTab(true);
                    } else if (event2.stateMask == 131072) {
                        Tab.this.selectNextTab(false);
                        event2.doit = false;
                    }
                }
            }
        });
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event2) {
                CTabItem item;
                if (Tab.this.folder == null || Tab.this.folder.isDisposed()) {
                    return;
                }
                if (Tab.this.useCustomTab && (item = (CTabItem)event2.item) != null && !item.isDisposed() && !Tab.this.folder.isDisposed()) {
                    try {
                        ((CTabFolder)Tab.this.folder).setSelection(item);
                        Control control = item.getControl();
                        if (control != null) {
                            control.setVisible(true);
                            control.setFocus();
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                Tab.this.mainwindow.getUIFunctions().refreshIconBar();
                Tab.this.mainwindow.getUIFunctions().refreshTorrentMenu();
            }
        };
        if (!this.useCustomTab) {
            ((TabFolder)this.folder).addSelectionListener((SelectionListener)selectionAdapter);
        } else {
            try {
                ((CTabFolder)this.folder).setMinimumCharacters(75);
            }
            catch (Exception e) {
                Logger.log(new LogEvent(LOGID, "Can't set MIN_TAB_WIDTH", e));
            }
            ((CTabFolder)this.folder).addCTabFolderListener((CTabFolderListener)new CTabFolderAdapter(){

                public void itemClosed(CTabFolderEvent event2) {
                    if (!event2.doit) {
                        return;
                    }
                    Tab.this.closed((Item)((CTabItem)event2.item));
                    event2.doit = true;
                    ((CTabItem)event2.item).dispose();
                }
            });
            ((CTabFolder)this.folder).addSelectionListener((SelectionListener)selectionAdapter);
            try {
                ((CTabFolder)this.folder).setSelectionBackground(new Color[]{display.getSystemColor(25), display.getSystemColor(25), display.getSystemColor(22)}, new int[]{10, 90}, true);
            }
            catch (NoSuchMethodError e) {
                ((CTabFolder)this.folder).setSelectionBackground(new Color[]{display.getSystemColor(25)}, new int[0]);
            }
            ((CTabFolder)this.folder).setSelectionForeground(display.getSystemColor(24));
            try {
                ((CTabFolder)this.folder).setSimple(!COConfigurationManager.getBooleanParameter("GUI_SWT_bFancyTab"));
            }
            catch (NoSuchMethodError e) {
                // empty catch block
            }
        }
        return this.folder;
    }

    public Item createTabItem(IView _view, boolean bFocus) {
        CTabItem tabItem;
        CTabFolder tabFolder;
        if (this.folder.isDisposed()) {
            return null;
        }
        if (this.folder instanceof CTabFolder) {
            tabFolder = (CTabFolder)this.folder;
            tabItem = new CTabItem(tabFolder, 0, _view instanceof MyTorrentsSuperView ? 0 : tabFolder.getItemCount());
        } else {
            tabFolder = (TabFolder)this.folder;
            tabItem = new TabItem((TabFolder)tabFolder, 0, _view instanceof MyTorrentsSuperView ? 0 : tabFolder.getItemCount());
        }
        this.tabs.put(tabItem, _view);
        try {
            final Composite tabArea = new Composite(this.folder, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            tabArea.setLayout((Layout)layout);
            _view.initialize(tabArea);
            tabItem.setText(this.escapeAccelerators(_view.getShortTitle()));
            Composite viewComposite = _view.getComposite();
            if (viewComposite != null && !viewComposite.isDisposed()) {
                viewComposite.addListener(26, this.activateListener);
                if (tabArea.getLayout() instanceof GridLayout && !(viewComposite.getLayoutData() instanceof GridData)) {
                    viewComposite.setLayoutData((Object)new GridData(1808));
                }
                if (viewComposite != tabArea) {
                    viewComposite.addDisposeListener(new DisposeListener(){
                        boolean alreadyHere = false;

                        public void widgetDisposed(DisposeEvent e) {
                            if (this.alreadyHere) {
                                return;
                            }
                            this.alreadyHere = true;
                            Utils.disposeComposite(tabArea);
                        }
                    });
                }
            }
            if (this.folder instanceof CTabFolder) {
                tabItem.setControl((Control)tabArea);
                if (bFocus) {
                    ((CTabFolder)this.folder).setSelection(tabItem);
                }
            } else {
                ((TabItem)tabItem).setControl((Control)tabArea);
                ((TabItem)tabItem).setToolTipText(_view.getFullTitle());
                TabItem[] items = new TabItem[]{(TabItem)tabItem};
                if (bFocus) {
                    ((TabFolder)this.folder).setSelection(items);
                }
            }
        }
        catch (Exception e) {
            this.tabs.remove(tabItem);
            Debug.printStackTrace(e);
        }
        if (bFocus) {
            UIFunctionsSWT uif = UIFunctionsManagerSWT.getUIFunctionsSWT();
            if (uif != null) {
                uif.refreshIconBar();
                uif.refreshTorrentMenu();
            }
            this.selectedItem = tabItem;
        }
        return tabItem;
    }

    public IView getView(Item item) {
        return (IView)this.tabs.get(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item getTab(IView view) {
        try {
            this.class_mon.enter();
            for (Item item : this.tabs.keySet()) {
                IView this_view = (IView)this.tabs.get(item);
                if (this_view != view) continue;
                Item item2 = item;
                return item2;
            }
            Item item = null;
            return item;
        }
        finally {
            this.class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item[] getAllTabs() {
        try {
            this.class_mon.enter();
            Item[] tabItems = new Item[this.tabs.size()];
            if (tabItems.length > 0) {
                tabItems = this.tabs.keySet().toArray(tabItems);
            }
            Item[] itemArray = tabItems;
            return itemArray;
        }
        finally {
            this.class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IView[] getAllViews() {
        try {
            this.class_mon.enter();
            IView[] views = new IView[this.tabs.size()];
            if (views.length > 0) {
                views = this.tabs.values().toArray(views);
            }
            IView[] iViewArray = views;
            return iViewArray;
        }
        finally {
            this.class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        try {
            this.class_mon.enter();
            for (Item item : this.tabs.keySet()) {
                IView view = (IView)this.tabs.get(item);
                try {
                    if (item.isDisposed()) continue;
                    String lastTitle = item.getText();
                    String newTitle = view.getShortTitle();
                    if (lastTitle == null || !lastTitle.equals(newTitle)) {
                        item.setText(this.escapeAccelerators(newTitle));
                    }
                    if (item instanceof CTabItem || !(item instanceof TabItem)) continue;
                    String lastToolTip = ((TabItem)item).getToolTipText();
                    String newToolTip = view.getFullTitle() + " " + MessageText.getString("Tab.closeHint");
                    if (lastToolTip != null && lastToolTip.equals(newToolTip)) continue;
                    ((TabItem)item).setToolTipText(newToolTip);
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        finally {
            this.class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLanguage() {
        IView[] views;
        try {
            this.class_mon.enter();
            views = this.tabs.values().toArray(new IView[this.tabs.size()]);
        }
        finally {
            this.class_mon.exit();
        }
        for (int i = 0; i < views.length; ++i) {
            IView view = views[i];
            try {
                view.updateLanguage();
                view.refresh();
                continue;
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllTabs() {
        Item[] tab_items;
        try {
            this.class_mon.enter();
            tab_items = this.tabs.keySet().toArray(new Item[this.tabs.size()]);
        }
        finally {
            this.class_mon.exit();
        }
        for (int i = 0; i < tab_items.length; ++i) {
            this.closed(tab_items[i], true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDetails() {
        boolean hasDetails = false;
        try {
            this.class_mon.enter();
            for (IView view : this.tabs.values()) {
                if (!(view instanceof ManagerView)) continue;
                hasDetails = true;
                break;
            }
        }
        finally {
            this.class_mon.exit();
        }
        return hasDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllDetails() {
        Item[] tab_items;
        try {
            this.class_mon.enter();
            tab_items = this.tabs.keySet().toArray(new Item[this.tabs.size()]);
        }
        finally {
            this.class_mon.exit();
        }
        for (int i = 0; i < tab_items.length; ++i) {
            IView view = (IView)this.tabs.get(tab_items[i]);
            if (!(view instanceof ManagerView)) continue;
            this.closed(tab_items[i]);
        }
    }

    public void closeCurrent() {
        if (this.folder == null || this.folder.isDisposed()) {
            return;
        }
        if (this.folder instanceof TabFolder) {
            TabItem[] items = ((TabFolder)this.folder).getSelection();
            if (items.length == 1) {
                this.closed((Item)items[0]);
            }
        } else {
            this.closed((Item)((CTabFolder)this.folder).getSelection());
        }
    }

    public void selectNextTab(boolean selectNext) {
        int nextOrPrevious;
        if (this.folder == null || this.folder.isDisposed()) {
            return;
        }
        int n = nextOrPrevious = selectNext ? 1 : -1;
        if (this.folder instanceof TabFolder) {
            TabFolder tabFolder = (TabFolder)this.folder;
            int index = tabFolder.getSelectionIndex() + nextOrPrevious;
            if (index == 0 && selectNext || index == -2 || tabFolder.getItemCount() < 2) {
                return;
            }
            if (index == tabFolder.getItemCount()) {
                index = 0;
            } else if (index < 0) {
                index = tabFolder.getItemCount() - 1;
            }
            tabFolder.setSelection(index);
        } else {
            CTabFolder tabFolder = (CTabFolder)this.folder;
            int index = tabFolder.getSelectionIndex() + nextOrPrevious;
            if (index == 0 && selectNext || index == -2 || tabFolder.getItemCount() < 2) {
                return;
            }
            if (index == tabFolder.getItemCount()) {
                index = 0;
            } else if (index < 0) {
                index = tabFolder.getItemCount() - 1;
            }
            tabFolder.setSelection(index);
        }
    }

    public boolean closed(Item item) {
        return this.closed(item, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closed(Item item, boolean bForceClose) {
        if (item == null) {
            return true;
        }
        IView view = (IView)this.tabs.get(item);
        if (!bForceClose && view instanceof UISWTViewImpl && !((UISWTViewImpl)view).requestClose()) {
            return false;
        }
        try {
            this.class_mon.enter();
            view = (IView)this.tabs.remove(item);
        }
        finally {
            this.class_mon.exit();
        }
        if (view != null) {
            try {
                if (view instanceof PluginView) {
                    this.mainwindow.removeActivePluginView(((PluginView)view).getPluginViewName());
                }
                if (view instanceof UISWTPluginView) {
                    this.mainwindow.removeActivePluginView(((UISWTPluginView)view).getPluginViewName());
                }
                if (view instanceof UISWTView) {
                    this.mainwindow.removeActivePluginView(((UISWTView)((Object)view)).getViewID());
                }
                view.delete();
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
            if (view instanceof MyTorrentsSuperView) {
                item.dispose();
                return true;
            }
            if (view instanceof MyTrackerView) {
                item.dispose();
                return true;
            }
            if (view instanceof MySharesView) {
                item.dispose();
                return true;
            }
        }
        try {
            item.dispose();
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        return true;
    }

    public void setFocus(Item item) {
        if (item == null || item.isDisposed()) {
            return;
        }
        if (this.folder != null && !this.folder.isDisposed()) {
            if (this.useCustomTab) {
                ((CTabFolder)this.folder).setSelection((CTabItem)item);
            } else {
                TabItem[] items = new TabItem[]{(TabItem)item};
                ((TabFolder)this.folder).setSelection(items);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(Item tabItem) {
        IView localView = null;
        try {
            this.class_mon.enter();
            localView = (IView)this.tabs.get(tabItem);
            if (localView instanceof UISWTViewImpl && !((UISWTViewImpl)localView).requestClose()) {
                return;
            }
            this.tabs.remove(tabItem);
        }
        finally {
            this.class_mon.exit();
        }
        try {
            if (localView != null) {
                if (localView instanceof PluginView) {
                    this.mainwindow.removeActivePluginView(((PluginView)localView).getPluginViewName());
                }
                if (localView instanceof UISWTPluginView) {
                    this.mainwindow.removeActivePluginView(((UISWTPluginView)localView).getPluginViewName());
                }
                localView.delete();
            }
            tabItem.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String escapeAccelerators(String str) {
        if (str == null) {
            return str;
        }
        return str.replaceAll("&", "&&");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateDiagnostics(IndentWriter writer) {
        Object[] views = this.tabs.values().toArray();
        for (int i = 0; i < views.length; ++i) {
            IView view = (IView)views[i];
            if (view == null) continue;
            writer.println(view.getFullTitle());
            try {
                writer.indent();
                view.generateDiagnostics(writer);
                continue;
            }
            catch (Exception e) {
                continue;
            }
            finally {
                writer.exdent();
            }
        }
    }

    public void update() {
        if (this.folder != null) {
            if (this.useCustomTab) {
                ((CTabFolder)this.folder).update();
            } else {
                ((TabFolder)this.folder).update();
            }
        }
    }

    public void closePluginViews(String viewID) {
        CTabItem[] items;
        if (this.folder instanceof CTabFolder) {
            items = ((CTabFolder)this.folder).getItems();
        } else if (this.folder instanceof TabFolder) {
            items = ((TabFolder)this.folder).getItems();
        } else {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            String sID;
            IView view = this.getView((Item)items[i]);
            if (!(view instanceof UISWTViewImpl) || (sID = ((UISWTViewImpl)view).getViewID()) == null || !sID.equals(viewID)) continue;
            try {
                Item tab = this.getTab(view);
                if (tab == null) continue;
                this.closed(tab);
                continue;
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void parameterChanged(String parameterName) {
        if (parameterName.equals("GUI_SWT_bFancyTab") && this.folder instanceof CTabFolder && this.folder != null && !this.folder.isDisposed()) {
            try {
                ((CTabFolder)this.folder).setSimple(!COConfigurationManager.getBooleanParameter("GUI_SWT_bFancyTab"));
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
    }

    public IView getCurrentView() {
        try {
            if (!this.useCustomTab) {
                TabItem[] selection = ((TabFolder)this.folder).getSelection();
                if (selection.length > 0) {
                    return this.getView((Item)selection[0]);
                }
                return null;
            }
            return this.getView((Item)((CTabFolder)this.folder).getSelection());
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getUpdateUIName() {
        IView currentView = this.getCurrentView();
        if (currentView != null) {
            return "TabSet-" + currentView.getFullTitle();
        }
        return ID;
    }

    public void updateUI() {
        if (this.folder == null || this.folder.isDisposed()) {
            return;
        }
        IView currentView = this.getCurrentView();
        if (currentView != null) {
            try {
                currentView.refresh();
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
        this.refresh();
    }
}

