/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.ui.swt.UISwitcherListener;
import org.gudy.azureus2.ui.swt.Utils;

public class UISwitcherUtil {
    private static final long UPTIME_NEWUSER = 3600L;
    private static boolean NOT_GOOD_ENOUGH_FOR_AZ2_USERS_YET = true;
    public static ArrayList listeners = new ArrayList();
    public static String lastUI = null;

    public static void addListener(UISwitcherListener l) {
        listeners.add(l);
        if (lastUI != null) {
            UISwitcherUtil.triggerListeners(lastUI);
        }
    }

    public static void removeListener(UISwitcherListener l) {
        listeners.remove(l);
    }

    public static String openSwitcherWindow(boolean bForceAsk) {
        lastUI = UISwitcherUtil._openSwitcherWindow(bForceAsk);
        UISwitcherUtil.triggerListeners(lastUI);
        return lastUI;
    }

    private static void triggerListeners(String ui) {
        Object[] array = listeners.toArray();
        for (int i = 0; i < array.length; ++i) {
            UISwitcherListener l = (UISwitcherListener)array[i];
            l.uiSwitched(ui);
        }
    }

    public static String _openSwitcherWindow(boolean bForceAsk) {
        Class<?> uiswClass = null;
        try {
            uiswClass = Class.forName("com.aelitis.azureus.ui.swt.shells.uiswitcher.UISwitcherWindow");
        }
        catch (ClassNotFoundException e1) {
            // empty catch block
        }
        if (uiswClass == null) {
            return "az2";
        }
        if (!bForceAsk) {
            if ("1".equals(System.getProperty("azureus.safemode"))) {
                return "az2";
            }
            String lastUI = COConfigurationManager.getStringParameter("ui", "az2");
            COConfigurationManager.setParameter("lastUI", lastUI);
            String forceUI = System.getProperty("force.ui");
            if (forceUI != null) {
                COConfigurationManager.setParameter("ui", forceUI);
                return forceUI;
            }
            boolean installLogExists = FileUtil.getApplicationFile("installer.log").exists();
            boolean alreadySwitched = COConfigurationManager.getBooleanParameter("installer.ui.alreadySwitched", false);
            if (!alreadySwitched && installLogExists) {
                String sFirstVersion;
                COConfigurationManager.setParameter("installer.ui.alreadySwitched", true);
                COConfigurationManager.setParameter("ui", "az3");
                COConfigurationManager.setParameter("az3.virgin.switch", true);
                if (!lastUI.equals("az3") && !Constants.getBaseVersion(sFirstVersion = COConfigurationManager.getStringParameter("First Recorded Version", "4.0.0.1_B06")).equals(Constants.getBaseVersion("4.0.0.1_B06"))) {
                    COConfigurationManager.setParameter("v3.Start Advanced", true);
                }
                return "az3";
            }
            boolean asked = COConfigurationManager.getBooleanParameter("ui.asked", false);
            if (asked || COConfigurationManager.hasParameter("ui", true)) {
                return COConfigurationManager.getStringParameter("ui", "az3");
            }
            String sFirstVersion = COConfigurationManager.getStringParameter("First Recorded Version");
            if (Constants.compareVersions(sFirstVersion, "3.0.0.0") >= 0) {
                COConfigurationManager.setParameter("ui", "az3");
                return "az3";
            }
            try {
                Map overallMap;
                Map map = FileUtil.readResilientConfigFile("azureus.statistics");
                if (map != null && (overallMap = (Map)map.get("all")) != null) {
                    long uptime = 0L;
                    Object uptimeObject = overallMap.get("uptime");
                    if (uptimeObject instanceof Number) {
                        uptime = ((Number)uptimeObject).longValue();
                    }
                    if (uptime < 3600L && uptime >= 0L) {
                        COConfigurationManager.setParameter("ui", "az3");
                        COConfigurationManager.setParameter("az3.virgin.switch", true);
                        COConfigurationManager.setParameter("az3.switch.immediate", true);
                        return "az3";
                    }
                }
            }
            catch (Exception e) {
                Debug.out(e);
            }
            if (NOT_GOOD_ENOUGH_FOR_AZ2_USERS_YET) {
                COConfigurationManager.setParameter("ui", "az2");
                return "az2";
            }
        }
        try {
            final int[] result = new int[]{-1};
            final Class<?> fuiswClass = uiswClass;
            Utils.execSWTThread((Runnable)new AERunnable(){

                public void runSupport() {
                    try {
                        Constructor constructor = fuiswClass.getConstructor(new Class[0]);
                        Object object = constructor.newInstance(new Object[0]);
                        Method method = fuiswClass.getMethod("open", new Class[0]);
                        Object resultObj = method.invoke(object, new Object[0]);
                        if (resultObj instanceof Number) {
                            result[0] = ((Number)resultObj).intValue();
                        }
                    }
                    catch (Exception e) {
                        Debug.printStackTrace(e);
                    }
                }
            }, false);
            if (result[0] == 0) {
                COConfigurationManager.setParameter("ui", "az3");
                if (!lastUI.equals("az3")) {
                    COConfigurationManager.setParameter("v3.Start Advanced", true);
                }
            } else if (result[0] == 1) {
                COConfigurationManager.setParameter("ui", "az2");
            }
            if (result[0] != -1) {
                COConfigurationManager.setParameter("ui.asked", true);
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        return COConfigurationManager.getStringParameter("ui");
    }

    public static boolean isAZ3Avail() {
        Class<?> uiswClass = null;
        try {
            uiswClass = Class.forName("com.aelitis.azureus.ui.swt.shells.uiswitcher.UISwitcherWindow");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

