/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class CustomTableTooltipHandler
implements Listener {
    Shell toolTipShell = null;
    Shell mainShell = null;
    Label toolTipLabel = null;
    private final Table table;

    public CustomTableTooltipHandler(Table _table) {
        this.table = _table;
        this.mainShell = this.table.getShell();
        this.table.addListener(12, (Listener)this);
        this.table.addListener(1, (Listener)this);
        this.table.addListener(5, (Listener)this);
        this.table.addListener(32, (Listener)this);
        this.mainShell.addListener(27, (Listener)this);
        this.table.addListener(27, (Listener)this);
        this.table.setToolTipText("");
    }

    public void handleEvent(Event event2) {
        switch (event2.type) {
            case 32: {
                Rectangle displayRect;
                TableItem item;
                if (this.toolTipShell != null && !this.toolTipShell.isDisposed()) {
                    this.toolTipShell.dispose();
                }
                if ((item = this.table.getItem(new Point(event2.x, event2.y))) == null) {
                    return;
                }
                Object oToolTip = item.getData("tooltip");
                if (oToolTip == null) {
                    oToolTip = item.getText(0);
                }
                if (oToolTip == null || !(oToolTip instanceof String)) {
                    return;
                }
                String sToolTip = (String)oToolTip;
                Display d = this.table.getDisplay();
                if (d == null) {
                    return;
                }
                this.toolTipShell = new Shell(this.table.getShell(), 16384);
                FillLayout f = new FillLayout();
                try {
                    f.marginWidth = 3;
                    f.marginHeight = 1;
                }
                catch (NoSuchFieldError e) {
                    // empty catch block
                }
                this.toolTipShell.setLayout((Layout)f);
                this.toolTipShell.setBackground(d.getSystemColor(29));
                this.toolTipLabel = new Label((Composite)this.toolTipShell, 64);
                this.toolTipLabel.setForeground(d.getSystemColor(28));
                this.toolTipLabel.setBackground(d.getSystemColor(29));
                this.toolTipLabel.setText(sToolTip.replaceAll("&", "&&"));
                Point size = this.toolTipLabel.computeSize(-1, -1);
                if (size.x > 600) {
                    size = this.toolTipLabel.computeSize(600, -1, true);
                }
                size.x += this.toolTipShell.getBorderWidth() * 2 + 2;
                size.y += this.toolTipShell.getBorderWidth() * 2;
                try {
                    size.x += this.toolTipShell.getBorderWidth() * 2 + f.marginWidth * 2;
                    size.y += this.toolTipShell.getBorderWidth() * 2 + f.marginHeight * 2;
                }
                catch (NoSuchFieldError e) {
                    // empty catch block
                }
                Point pt = this.table.toDisplay(event2.x, event2.y);
                try {
                    displayRect = this.table.getMonitor().getClientArea();
                }
                catch (NoSuchMethodError e) {
                    displayRect = this.table.getDisplay().getClientArea();
                }
                if (pt.x + size.x > displayRect.x + displayRect.width) {
                    pt.x = displayRect.x + displayRect.width - size.x;
                }
                pt.y = pt.y + size.y > displayRect.y + displayRect.height ? (pt.y -= size.y + 2) : (pt.y += 21);
                if (pt.y < displayRect.y) {
                    pt.y = displayRect.y;
                }
                this.toolTipShell.setBounds(pt.x, pt.y, size.x, size.y);
                this.toolTipShell.setVisible(true);
                break;
            }
            case 12: {
                if (this.mainShell != null && !this.mainShell.isDisposed()) {
                    this.mainShell.removeListener(27, (Listener)this);
                }
                if (this.table != null && !this.table.isDisposed()) {
                    this.mainShell.removeListener(27, (Listener)this);
                }
            }
            default: {
                if (this.toolTipShell == null) break;
                this.toolTipShell.dispose();
                this.toolTipShell = null;
                this.toolTipLabel = null;
            }
        }
    }
}

