/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config.wizard;

import com.aelitis.azureus.core.AzureusCore;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.config.wizard.LanguagePanel;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.wizard.Wizard;

public class ConfigureWizard
extends Wizard {
    int upSpeed = 4;
    int maxUpSpeed = 40;
    int maxActiveTorrents = 7;
    int maxDownloads = 5;
    int nbUploadsPerTorrent = 4;
    int serverTCPListenPort = COConfigurationManager.getIntParameter("TCP.Listen.Port");
    String torrentPath;
    boolean completed = false;

    public ConfigureWizard(AzureusCore azureus_core, boolean modal) {
        super(azureus_core, "configureWizard.title", modal);
        LanguagePanel panel = new LanguagePanel(this, null);
        try {
            this.torrentPath = COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory");
        }
        catch (Exception e) {
            this.torrentPath = "";
        }
        this.setFirstPanel(panel);
    }

    public void onClose() {
        try {
            int result;
            if (!this.completed && !COConfigurationManager.getBooleanParameter("Wizard Completed") && (result = MessageBoxShell.open(this.getWizardWindow(), MessageText.getString("wizard.close.confirmation"), MessageText.getString("wizard.close.message"), new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 0)) == 1) {
                COConfigurationManager.setParameter("Wizard Completed", true);
                COConfigurationManager.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.onClose();
    }
}

