/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.UIStatusTextClickListener;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import java.text.NumberFormat;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.stats.transfer.OverallStats;
import org.gudy.azureus2.core3.stats.transfer.StatsFactory;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.network.ConnectionManager;
import org.gudy.azureus2.ui.swt.AZProgressBar;
import org.gudy.azureus2.ui.swt.BlockedIpsWindow;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.Cursors;
import org.gudy.azureus2.ui.swt.mainwindow.SelectableSpeedMenu;
import org.gudy.azureus2.ui.swt.progress.IProgressReport;
import org.gudy.azureus2.ui.swt.progress.IProgressReportConstants;
import org.gudy.azureus2.ui.swt.progress.IProgressReporter;
import org.gudy.azureus2.ui.swt.progress.IProgressReportingListener;
import org.gudy.azureus2.ui.swt.progress.ProgressReporterWindow;
import org.gudy.azureus2.ui.swt.progress.ProgressReportingManager;
import org.gudy.azureus2.ui.swt.update.UpdateWindow;

public class MainStatusBar
implements UIUpdatable {
    private static final String STATUS_ICON_WARN = "sb_warning";
    private static final String ID = "MainStatusBar";
    private AEMonitor this_mon = new AEMonitor("MainStatusBar");
    private UpdateWindow updateWindow;
    private Composite statusBar;
    private CLabel statusText;
    private String statusTextKey = "";
    private String statusImageKey = null;
    private AZProgressBar progressBar;
    private CLabel ipBlocked;
    private CLabel srStatus;
    private CLabel natStatus;
    private CLabel dhtStatus;
    private CLabel statusDown;
    private CLabel statusUp;
    private Composite plugin_label_composite;
    private Display display;
    private long last_sr_ratio = -1L;
    private int last_sr_status = -1;
    private int lastNATstatus = -1;
    private int lastDHTstatus = -1;
    private long lastDHTcount = -1L;
    private NumberFormat numberFormat;
    private OverallStats overall_stats;
    private ConnectionManager connection_manager;
    private DHTPlugin dhtPlugin;
    private GlobalManager globalManager;
    private AzureusCore azureusCore;
    private UIFunctions uiFunctions;
    private UIStatusTextClickListener clickListener;
    private static final int borderFlag = 32;
    private boolean isAZ3 = false;
    private ProgressReportingManager PRManager = ProgressReportingManager.getInstance();
    private GridData progressGridData = new GridData(131072, 0x1000000, false, false);
    private CLabelPadding progressViewerImageLabel;
    private Image progress_error_img = null;
    private Image progress_info_img = null;
    private Image progress_viewer_img = null;
    private Image currentProgressImage = null;
    private boolean updateProgressBarDisplayQueued = false;
    protected IProgressReport latestReport = null;
    protected AEMonitor latestReport_mon = new AEMonitor("latestReport");

    public MainStatusBar() {
        this.numberFormat = NumberFormat.getInstance();
        this.overall_stats = StatsFactory.getStats();
        PluginManager pm = AzureusCoreFactory.getSingleton().getPluginManager();
        this.connection_manager = pm.getDefaultPluginInterface().getConnectionManager();
        PluginInterface dht_pi = pm.getPluginInterfaceByClass(DHTPlugin.class);
        if (dht_pi != null) {
            this.dhtPlugin = (DHTPlugin)dht_pi.getPlugin();
        }
    }

    public Composite initStatusBar(final AzureusCore core, final GlobalManager globalManager, Display display, final Composite parent) {
        this.display = display;
        this.globalManager = globalManager;
        this.azureusCore = core;
        this.uiFunctions = UIFunctionsManager.getUIFunctions();
        Color fgColor = parent.getForeground();
        this.statusBar = new Composite(parent, 0);
        this.statusBar.setForeground(fgColor);
        this.isAZ3 = "az3".equalsIgnoreCase(COConfigurationManager.getStringParameter("ui"));
        GridLayout layout_status = new GridLayout();
        layout_status.numColumns = 20;
        layout_status.horizontalSpacing = 0;
        layout_status.verticalSpacing = 0;
        layout_status.marginHeight = 0;
        if (Constants.isOSX) {
            try {
                layout_status.marginRight = 15;
            }
            catch (NoSuchFieldError e) {
                layout_status.marginWidth = 15;
            }
        } else {
            layout_status.marginWidth = 0;
        }
        this.statusBar.setLayout((Layout)layout_status);
        this.statusText = new CLabel(this.statusBar, 32);
        this.statusText.setForeground(fgColor);
        this.statusText.setLayoutData((Object)new GridData(784));
        Image image = ImageRepository.getImage(STATUS_ICON_WARN);
        int imageHeight = image == null ? 20 : image.getBounds().height;
        GC gc = new GC((Drawable)this.statusText);
        int height = Math.max(imageHeight, gc.getFontMetrics().getHeight()) + 6;
        gc.dispose();
        FormData formData = new FormData();
        formData.height = height;
        formData.bottom = new FormAttachment(100, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.statusBar.setLayoutData((Object)formData);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                if (MainStatusBar.this.clickListener == null) {
                    if (MainStatusBar.this.updateWindow != null) {
                        MainStatusBar.this.updateWindow.show();
                    }
                } else {
                    MainStatusBar.this.clickListener.UIStatusTextClicked();
                }
            }
        };
        this.statusText.addListener(4, listener);
        this.statusText.addListener(8, listener);
        this.progressBar = true == Constants.isOSX ? new AZProgressBar(this.statusBar, true) : new AZProgressBar(this.statusBar, false);
        this.progressBar.setVisible(false);
        this.progressGridData = new GridData(0x1000000, 0x1000000, false, false);
        this.progressGridData.widthHint = 5;
        this.progressBar.setLayoutData(this.progressGridData);
        if (this.isAZ3) {
            CLabelPadding feedback = new CLabelPadding(this.statusBar, 32);
            feedback.setText(MessageText.getString("statusbar.feedback"));
            Listener feedback_listener = new Listener(){

                public void handleEvent(Event e) {
                    String url = "feedback?" + Utils.getWidgetBGColorURLParam() + "&fromWeb=false&os.name=" + UrlUtils.encode(Constants.OSName) + "&os.version=" + UrlUtils.encode(System.getProperty("os.version")) + "&java.version=" + UrlUtils.encode(Constants.JAVA_VERSION);
                    UIFunctionsManagerSWT.getUIFunctionsSWT().viewURL(url, (String)null, 600, 520, true, false);
                }
            };
            feedback.setToolTipText(MessageText.getString("statusbar.feedback.tooltip"));
            feedback.setCursor(Cursors.handCursor);
            feedback.setForeground(Colors.blue);
            feedback.addListener(4, feedback_listener);
            feedback.addListener(8, feedback_listener);
        }
        this.progress_error_img = ImageRepository.getImage("progress_error");
        this.progress_info_img = ImageRepository.getImage("progress_info");
        this.progress_viewer_img = ImageRepository.getImage("progress_viewer");
        this.progressViewerImageLabel = new CLabelPadding(this.statusBar, 0);
        this.progressViewerImageLabel.setToolTipText(MessageText.getString("Progress.reporting.statusbar.button.tooltip"));
        this.progressViewerImageLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                block2: {
                    IProgressReporter[] reporters;
                    block1: {
                        reporters = MainStatusBar.this.PRManager.getReportersArray(false);
                        if (reporters.length != 0) break block1;
                        if (ProgressReporterWindow.isShowingEmpty()) break block2;
                        ProgressReporterWindow.open(reporters, 32);
                        break block2;
                    }
                    for (int i = 0; i < reporters.length; ++i) {
                        if (ProgressReporterWindow.isOpened(reporters[i])) continue;
                        ProgressReporterWindow.open(reporters, 32);
                        break;
                    }
                }
            }
        });
        this.statusBar.layout();
        this.plugin_label_composite = new Composite(this.statusBar, 0);
        this.plugin_label_composite.setForeground(fgColor);
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.numColumns = 20;
        GridData gridData = new GridData(1040);
        gridData.heightHint = height;
        gridData.minimumHeight = height;
        this.plugin_label_composite.setLayout((Layout)gridLayout);
        this.plugin_label_composite.setLayoutData((Object)gridData);
        this.srStatus = new CLabelPadding(this.statusBar, 32);
        this.srStatus.setText(MessageText.getString("SpeedView.stats.ratio"));
        COConfigurationManager.addAndFireParameterListener("Status Area Show SR", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                MainStatusBar.this.srStatus.setVisible(COConfigurationManager.getBooleanParameter(parameterName));
                MainStatusBar.this.statusBar.layout();
            }
        });
        this.natStatus = new CLabelPadding(this.statusBar, 32);
        this.natStatus.setText("");
        COConfigurationManager.addAndFireParameterListener("Status Area Show NAT", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                MainStatusBar.this.natStatus.setVisible(COConfigurationManager.getBooleanParameter(parameterName));
                MainStatusBar.this.statusBar.layout();
            }
        });
        this.dhtStatus = new CLabelPadding(this.statusBar, 32);
        this.dhtStatus.setText("");
        this.dhtStatus.setToolTipText(MessageText.getString("MainWindow.dht.status.tooltip"));
        COConfigurationManager.addAndFireParameterListener("Status Area Show DDB", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                MainStatusBar.this.dhtStatus.setVisible(COConfigurationManager.getBooleanParameter(parameterName));
                MainStatusBar.this.statusBar.layout();
            }
        });
        this.ipBlocked = new CLabelPadding(this.statusBar, 32);
        this.ipBlocked.setText("{} IPs:");
        Messages.setLanguageText((Widget)this.ipBlocked, "MainWindow.IPs.tooltip");
        this.ipBlocked.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                BlockedIpsWindow.showBlockedIps(MainStatusBar.this.azureusCore, parent.getShell());
            }
        });
        COConfigurationManager.addAndFireParameterListener("Status Area Show IPF", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                MainStatusBar.this.ipBlocked.setVisible(COConfigurationManager.getBooleanParameter(parameterName));
                MainStatusBar.this.statusBar.layout();
            }
        });
        this.statusDown = new CLabelPadding(this.statusBar, 32);
        this.statusDown.setImage(ImageRepository.getImage("down"));
        this.statusDown.setText("n/a");
        Messages.setLanguageText((Widget)this.statusDown, "MainWindow.status.updowndetails.tooltip");
        Listener lStats = new Listener(){

            public void handleEvent(Event e) {
                MainStatusBar.this.uiFunctions.openView(1, null);
            }
        };
        this.statusUp = new CLabelPadding(this.statusBar, 32);
        this.statusUp.setImage(ImageRepository.getImage("up"));
        this.statusUp.setText("n/a");
        Messages.setLanguageText((Widget)this.statusUp, "MainWindow.status.updowndetails.tooltip");
        this.statusDown.addListener(8, lStats);
        this.statusUp.addListener(8, lStats);
        Listener lDHT = new Listener(){

            public void handleEvent(Event e) {
                MainStatusBar.this.uiFunctions.openView(1, "dht");
            }
        };
        this.dhtStatus.addListener(8, lDHT);
        Listener lSR = new Listener(){

            public void handleEvent(Event e) {
                MainStatusBar.this.uiFunctions.openView(1, "transfers");
                OverallStats stats = StatsFactory.getStats();
                long ratio = 1000L * stats.getUploadedBytes() / (stats.getDownloadedBytes() + 1L);
                if (ratio < 900L) {
                    Utils.launch("http://www.azureuswiki.com/index.php/Share_Ratio");
                }
            }
        };
        this.srStatus.addListener(8, lSR);
        Listener lNAT = new Listener(){

            public void handleEvent(Event e) {
                MainStatusBar.this.uiFunctions.openView(4, "server");
                if (MainStatusBar.this.azureusCore.getPluginManager().getDefaultPluginInterface().getConnectionManager().getNATStatus() != 1) {
                    Utils.launch("http://www.azureuswiki.com/index.php/NAT_problem");
                }
            }
        };
        this.natStatus.addListener(8, lNAT);
        boolean bSpeedMenu = COConfigurationManager.getBooleanParameter("GUI_SWT_bOldSpeedMenu");
        if (bSpeedMenu) {
            final Menu menuUpSpeed = new Menu((Decorations)this.statusBar.getShell(), 8);
            menuUpSpeed.addListener(22, new Listener(){

                public void handleEvent(Event e) {
                    SelectableSpeedMenu.generateMenuItems(menuUpSpeed, core, globalManager, true);
                }
            });
            this.statusUp.setMenu(menuUpSpeed);
        } else {
            this.statusUp.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (e.button != 3 && (e.button != 1 || e.stateMask != 262144)) {
                        return;
                    }
                    Event event2 = new Event();
                    event2.type = 4;
                    event2.widget = e.widget;
                    event2.stateMask = e.stateMask;
                    event2.button = e.button;
                    e.widget.getDisplay().post(event2);
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            SelectableSpeedMenu.invokeSlider(true);
                        }
                    });
                }
            });
        }
        if (bSpeedMenu) {
            final Menu menuDownSpeed = new Menu((Decorations)this.statusBar.getShell(), 8);
            menuDownSpeed.addListener(22, new Listener(){

                public void handleEvent(Event e) {
                    SelectableSpeedMenu.generateMenuItems(menuDownSpeed, core, globalManager, false);
                }
            });
            this.statusDown.setMenu(menuDownSpeed);
        } else {
            this.statusDown.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (e.button != 3 && (e.button != 1 || e.stateMask != 262144)) {
                        return;
                    }
                    Event event2 = new Event();
                    event2.type = 4;
                    event2.widget = e.widget;
                    event2.stateMask = e.stateMask;
                    event2.button = e.button;
                    e.widget.getDisplay().post(event2);
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            SelectableSpeedMenu.invokeSlider(false);
                        }
                    });
                }
            });
        }
        this.PRManager.addListener(new ProgressListener());
        this.setProgressImage();
        this.uiFunctions.getUIUpdater().addUpdater(this);
        return this.statusBar;
    }

    public void setStatusText(String keyedSentence) {
        this.statusTextKey = keyedSentence == null ? "" : keyedSentence;
        this.statusImageKey = null;
        this.clickListener = null;
        if (this.statusTextKey.length() == 0) {
            this.resetStatus();
        }
        this.updateStatusText();
    }

    private void resetStatus() {
        if (Constants.isCVSVersion()) {
            this.statusTextKey = "MainWindow.status.unofficialversion (4.0.0.1_B06)";
            this.statusImageKey = STATUS_ICON_WARN;
        } else if (!Constants.isOSX) {
            this.statusTextKey = Constants.APP_NAME + " " + "4.0.0.1_B06";
            this.statusImageKey = null;
        }
    }

    public void setStatusText(int statustype, String string, UIStatusTextClickListener l) {
        String string2 = this.statusTextKey = string == null ? "" : string;
        if (this.statusTextKey.length() == 0) {
            this.resetStatus();
        }
        this.clickListener = l;
        if (statustype == 1) {
            this.statusImageKey = STATUS_ICON_WARN;
        }
        this.statusImageKey = statustype == 1 ? STATUS_ICON_WARN : null;
        this.updateStatusText();
    }

    public void updateStatusText() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        final String text = this.updateWindow != null ? "MainWindow.updateavail" : this.statusTextKey;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (MainStatusBar.this.statusText != null && !MainStatusBar.this.statusText.isDisposed()) {
                    MainStatusBar.this.statusText.setText(MessageText.getStringForSentence(text));
                    MainStatusBar.this.statusText.setImage(MainStatusBar.this.statusImageKey == null ? null : ImageRepository.getImage(MainStatusBar.this.statusImageKey));
                }
            }
        });
    }

    public void refreshStatusText() {
        if (this.statusText != null && !this.statusText.isDisposed()) {
            this.statusText.update();
        }
    }

    public void setUpdateNeeded(UpdateWindow updateWindow) {
        this.updateWindow = updateWindow;
        if (updateWindow != null) {
            this.statusText.setCursor(Cursors.handCursor);
            this.statusText.setForeground(Colors.colorWarning);
            this.updateStatusText();
        } else {
            this.statusText.setCursor(null);
            this.statusText.setForeground(null);
            this.updateStatusText();
        }
    }

    public void updateUI() {
        String seeding_only;
        if (this.statusBar.isDisposed()) {
            this.uiFunctions.getUIUpdater().removeUpdater(this);
            return;
        }
        Control[] plugin_elements = this.plugin_label_composite.getChildren();
        for (int i = 0; i < plugin_elements.length; ++i) {
            if (!(plugin_elements[i] instanceof UpdateableCLabel)) continue;
            ((UpdateableCLabel)plugin_elements[i]).checkForRefresh();
        }
        if (this.ipBlocked.isVisible()) {
            this.updateIPBlocked();
        }
        if (this.srStatus.isVisible()) {
            this.updateShareRatioStatus();
        }
        if (this.natStatus.isVisible()) {
            this.updateNatStatus();
        }
        if (this.dhtStatus.isVisible()) {
            this.updateDHTStatus();
        }
        int dl_limit = NetworkManager.getMaxDownloadRateBPS() / 1024;
        GlobalManagerStats stats = this.globalManager.getStats();
        this.statusDown.setText((dl_limit == 0 ? "" : "[" + dl_limit + "K] ") + DisplayFormatters.formatDataProtByteCountToKiBEtcPerSec(stats.getDataReceiveRate(), stats.getProtocolReceiveRate()));
        boolean auto_up = COConfigurationManager.getBooleanParameter(TransferSpeedValidator.getActiveAutoUploadParameter(this.globalManager)) && TransferSpeedValidator.isAutoUploadAvailable(this.azureusCore);
        int ul_limit_norm = NetworkManager.getMaxUploadRateBPSNormal() / 1024;
        if (NetworkManager.isSeedingOnlyUploadRate()) {
            int ul_limit_seed = NetworkManager.getMaxUploadRateBPSSeedingOnly() / 1024;
            if (ul_limit_seed == 0) {
                seeding_only = "+\u221eK";
            } else {
                int diff = ul_limit_seed - ul_limit_norm;
                seeding_only = (diff >= 0 ? "+" : "") + diff + "K";
            }
        } else {
            seeding_only = "";
        }
        this.statusUp.setText((ul_limit_norm == 0 ? "" : "[" + ul_limit_norm + "K" + seeding_only + "]") + (auto_up ? "* " : " ") + DisplayFormatters.formatDataProtByteCountToKiBEtcPerSec(stats.getDataSendRate(), stats.getProtocolSendRate()));
        this.statusBar.layout();
    }

    private void updateDHTStatus() {
        int dht_status = this.dhtPlugin == null ? 1 : this.dhtPlugin.getStatus();
        long dht_count = -1L;
        if (dht_status == 3) {
            DHT[] dhts = this.dhtPlugin.getDHTs();
            dht_count = dhts[0].getControl().getStats().getEstimatedDHTSize();
        }
        if (this.lastDHTstatus != dht_status || this.lastDHTcount != dht_count) {
            Image img = ImageRepository.getImage("sb_count");
            switch (dht_status) {
                case 3: {
                    this.dhtStatus.setToolTipText(MessageText.getString("MainWindow.dht.status.tooltip"));
                    this.dhtStatus.setText(MessageText.getString("MainWindow.dht.status.users").replaceAll("%1", this.numberFormat.format(dht_count)));
                    break;
                }
                case 1: {
                    this.dhtStatus.setText(MessageText.getString("MainWindow.dht.status.disabled"));
                    break;
                }
                case 2: {
                    this.dhtStatus.setText(MessageText.getString("MainWindow.dht.status.initializing"));
                    break;
                }
                case 4: {
                    this.dhtStatus.setText(MessageText.getString("MainWindow.dht.status.failed"));
                    break;
                }
                default: {
                    img = null;
                }
            }
            this.dhtStatus.setImage(img);
            this.lastDHTstatus = dht_status;
            this.lastDHTcount = dht_count;
        }
    }

    private void updateNatStatus() {
        int nat_status = this.connection_manager.getNATStatus();
        if (this.lastNATstatus != nat_status) {
            String statusID;
            String tooltipID;
            String imgID;
            switch (nat_status) {
                case 0: {
                    imgID = "grayled";
                    tooltipID = "MainWindow.nat.status.tooltip.unknown";
                    statusID = "MainWindow.nat.status.unknown";
                    break;
                }
                case 1: {
                    imgID = "greenled";
                    tooltipID = "MainWindow.nat.status.tooltip.ok";
                    statusID = "MainWindow.nat.status.ok";
                    break;
                }
                case 2: {
                    imgID = "yellowled";
                    tooltipID = "MainWindow.nat.status.tooltip.probok";
                    statusID = "MainWindow.nat.status.probok";
                    break;
                }
                default: {
                    imgID = "redled";
                    tooltipID = "MainWindow.nat.status.tooltip.bad";
                    statusID = "MainWindow.nat.status.bad";
                }
            }
            this.natStatus.setImage(ImageRepository.getImage(imgID));
            this.natStatus.setToolTipText(MessageText.getString(tooltipID));
            this.natStatus.setText(MessageText.getString(statusID));
            this.lastNATstatus = nat_status;
        }
    }

    private void updateShareRatioStatus() {
        long ratio = 1000L * this.overall_stats.getUploadedBytes() / (this.overall_stats.getDownloadedBytes() + 1L);
        int sr_status = ratio < 500L ? 0 : (ratio < 900L ? 1 : 2);
        if (sr_status != this.last_sr_status) {
            String imgID;
            switch (sr_status) {
                case 2: {
                    imgID = "greenled";
                    break;
                }
                case 1: {
                    imgID = "yellowled";
                    break;
                }
                default: {
                    imgID = "redled";
                }
            }
            this.srStatus.setImage(ImageRepository.getImage(imgID));
            this.last_sr_status = sr_status;
        }
        if (ratio != this.last_sr_ratio) {
            String tooltipID;
            switch (sr_status) {
                case 2: {
                    tooltipID = "MainWindow.sr.status.tooltip.ok";
                    break;
                }
                case 1: {
                    tooltipID = "MainWindow.sr.status.tooltip.poor";
                    break;
                }
                default: {
                    tooltipID = "MainWindow.sr.status.tooltip.bad";
                }
            }
            String ratio_str = "";
            String partial = "" + ratio % 1000L;
            while (partial.length() < 3) {
                partial = "0" + partial;
            }
            ratio_str = ratio / 1000L + "." + partial;
            this.srStatus.setToolTipText(MessageText.getString(tooltipID, new String[]{ratio_str}));
            this.last_sr_ratio = ratio;
        }
    }

    private void updateIPBlocked() {
        IpFilter ip_filter = this.azureusCore.getIpFilterManager().getIPFilter();
        this.ipBlocked.setText("IPs: " + this.numberFormat.format(ip_filter.getNbRanges()) + " - " + this.numberFormat.format(ip_filter.getNbIpsBlockedAndLoggable()) + "/" + this.numberFormat.format(ip_filter.getNbBannedIps()) + "/" + this.numberFormat.format(this.azureusCore.getIpFilterManager().getBadIps().getNbBadIps()));
        this.ipBlocked.setToolTipText(MessageText.getString("MainWindow.IPs.tooltip", new String[]{DisplayFormatters.formatDateShort(ip_filter.getLastUpdateTime())}));
    }

    public void setDebugInfo(String string) {
        if (!this.statusText.isDisposed()) {
            this.statusText.setToolTipText(string);
        }
    }

    public boolean isMouseOver() {
        if (this.statusText.isDisposed()) {
            return false;
        }
        return this.statusText.getDisplay().getCursorControl() == this.statusText;
    }

    public CLabel createStatusEntry(final CLabelUpdater updater) {
        final CLabel[] result = new CLabel[1];
        Utils.execSWTThread((Runnable)new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                try {
                    MainStatusBar.this.this_mon.enter();
                    result[0] = new UpdateableCLabel(MainStatusBar.this.plugin_label_composite, 32, updater);
                    result[0].setLayoutData((Object)new GridData(1808));
                }
                finally {
                    MainStatusBar.this.this_mon.exit();
                }
            }
        }, false);
        return result[0];
    }

    private void showProgressBar(boolean state) {
        if (state && !this.progressBar.isVisible()) {
            this.progressGridData.widthHint = 100;
            this.progressBar.setVisible(true);
            this.statusBar.layout();
        } else if (!state && this.progressBar.isVisible()) {
            this.progressBar.setVisible(false);
            this.progressGridData.widthHint = 0;
            this.statusBar.layout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProgressBarDisplay(IProgressReport pReport) {
        this.latestReport_mon.enter();
        try {
            this.latestReport = pReport;
        }
        finally {
            this.latestReport_mon.exit();
        }
        if (null == this.progressBar || this.progressBar.isDisposed() || this.updateProgressBarDisplayQueued) {
            return;
        }
        this.updateProgressBarDisplayQueued = true;
        Utils.execSWTThread((Runnable)new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                MainStatusBar.this.latestReport_mon.enter();
                try {
                    MainStatusBar.this.updateProgressBarDisplayQueued = false;
                    if (null == MainStatusBar.this.progressBar || MainStatusBar.this.progressBar.isDisposed()) {
                        return;
                    }
                    if (null != MainStatusBar.this.latestReport) {
                        MainStatusBar.this.progressBar.setMinimum(MainStatusBar.this.latestReport.getMinimum());
                        MainStatusBar.this.progressBar.setMaximum(MainStatusBar.this.latestReport.getMaximum());
                        MainStatusBar.this.progressBar.setIndeterminate(MainStatusBar.this.latestReport.isIndeterminate());
                        MainStatusBar.this.progressBar.setPercentage(MainStatusBar.this.latestReport.getPercentage());
                        MainStatusBar.this.showProgressBar(true);
                        if (MainStatusBar.this.isAZ3) {
                            MainStatusBar.this.statusText.setText(MainStatusBar.this.latestReport.getName());
                        } else {
                            MainStatusBar.this.setStatusText(MainStatusBar.this.latestReport.getName());
                        }
                    } else {
                        MainStatusBar.this.showProgressBar(false);
                        if (MainStatusBar.this.isAZ3) {
                            MainStatusBar.this.statusText.setText("");
                        } else {
                            MainStatusBar.this.setStatusText(null);
                        }
                    }
                }
                finally {
                    MainStatusBar.this.latestReport_mon.exit();
                }
            }
        }, true);
    }

    private void setProgressImage() {
        Image newProgressImage = this.PRManager.getReporterCount(2) > 0 ? this.progress_error_img : (this.PRManager.getReporterCount(0) > 0 ? this.progress_info_img : this.progress_viewer_img);
        if (this.currentProgressImage != newProgressImage) {
            this.currentProgressImage = newProgressImage;
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    if (MainStatusBar.this.progressViewerImageLabel.isDisposed()) {
                        return;
                    }
                    MainStatusBar.this.progressViewerImageLabel.setImage(MainStatusBar.this.currentProgressImage);
                }
            });
        }
    }

    public Rectangle getBounds() {
        if (null != this.statusBar) {
            return this.statusBar.getBounds();
        }
        return null;
    }

    public String getUpdateUIName() {
        return ID;
    }

    private class ProgressListener
    implements IProgressReportingListener,
    IProgressReportConstants {
        private ProgressListener() {
        }

        public int reporting(int eventType, IProgressReporter reporter) {
            MainStatusBar.this.setProgressImage();
            if (null == reporter) {
                return 0;
            }
            if (2 == eventType) {
                this.updateFromPrevious();
            } else if (1 == eventType || 3 == eventType) {
                IProgressReport pReport = reporter.getProgressReport();
                if (pReport.isInErrorState()) {
                    if ("reporterType_updater".equals(pReport.getReporterType())) {
                        return 0;
                    }
                    final IProgressReporter final_reporter = reporter;
                    if (!ProgressReporterWindow.isOpened(final_reporter)) {
                        Utils.execSWTThread((Runnable)new AERunnable(){

                            public void runSupport() {
                                if (!ProgressReporterWindow.isOpened(final_reporter)) {
                                    ProgressReporterWindow.open(final_reporter, 0);
                                }
                            }
                        }, true);
                    }
                }
                if (!pReport.isActive()) {
                    this.updateFromPrevious();
                } else {
                    this.update(pReport);
                }
            }
            return 0;
        }

        private void update(final IProgressReport pReport) {
            if (null == pReport) {
                MainStatusBar.this.updateProgressBarDisplay(null);
                return;
            }
            if (MainStatusBar.this.PRManager.hasMultipleActive()) {
                Utils.execSWTThread((Runnable)new AERunnable(){

                    public void runSupport() {
                        MainStatusBar.this.setStatusText(pReport.getName());
                        MainStatusBar.this.progressBar.setIndeterminate(true);
                        MainStatusBar.this.showProgressBar(true);
                    }
                }, true);
            } else {
                MainStatusBar.this.updateProgressBarDisplay(pReport);
            }
        }

        private void updateFromPrevious() {
            IProgressReporter previousReporter = MainStatusBar.this.PRManager.getNextActiveReporter();
            if (null != previousReporter) {
                this.update(previousReporter.getProgressReport());
            } else {
                this.update(null);
            }
        }
    }

    private class UpdateableCLabel
    extends CLabelPadding {
        private CLabelUpdater updater;

        public UpdateableCLabel(Composite parent, int style, CLabelUpdater updater) {
            super(parent, style);
            this.updater = updater;
        }

        private void checkForRefresh() {
            this.updater.update(this);
        }
    }

    private class CLabelPadding
    extends CLabel {
        private int lastWidth;
        private long widthSetOn;
        private static final int KEEPWIDTHFOR_MS = 30000;

        public CLabelPadding(Composite parent, int style) {
            super(parent, style | 0x1000000);
            this.lastWidth = 0;
            this.widthSetOn = 0L;
            GridData gridData = new GridData(80);
            this.setLayoutData(gridData);
            this.setForeground(parent.getForeground());
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            if (!this.isVisible()) {
                return new Point(0, 0);
            }
            Point pt = super.computeSize(wHint, hHint, changed);
            pt.x += 4;
            long now = System.currentTimeMillis();
            if (this.lastWidth > pt.x && now - this.widthSetOn < 30000L) {
                pt.x = this.lastWidth;
            } else {
                if (this.lastWidth != pt.x) {
                    this.lastWidth = pt.x;
                }
                this.widthSetOn = now;
            }
            return pt;
        }
    }

    public static interface CLabelUpdater {
        public void update(CLabel var1);
    }
}

