/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.ui.common.util.MenuItemManager;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.MenuFactory;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.BasicPluginViewImpl;
import org.gudy.azureus2.ui.swt.views.AbstractIView;

public class PluginsMenuHelper {
    private static PluginsMenuHelper INSTANCE = null;
    private AEMonitor plugin_helper_mon = new AEMonitor("plugin_helper_mon");
    private Map plugin_view_info_map = new TreeMap();
    private Map plugin_logs_view_info_map = new TreeMap();
    private List pluginAddedViewListener = new ArrayList();

    private PluginsMenuHelper() {
    }

    public static PluginsMenuHelper getInstance() {
        if (null == INSTANCE) {
            INSTANCE = new PluginsMenuHelper();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildPluginMenu(Menu pluginMenu, Shell parent, boolean includeGetPluginsMenu) {
        try {
            this.plugin_helper_mon.enter();
            this.createIViewInfoMenuItems(pluginMenu, this.plugin_view_info_map);
            org.eclipse.swt.widgets.MenuItem menu_plugin_logViews = MenuFactory.addLogsViewMenuItem(pluginMenu);
            this.createIViewInfoMenuItems(menu_plugin_logViews.getMenu(), this.plugin_logs_view_info_map);
        }
        finally {
            this.plugin_helper_mon.exit();
        }
        MenuFactory.addSeparatorMenuItem(pluginMenu);
        MenuItem[] plugin_items = MenuItemManager.getInstance().getAllAsArray("mainmenu");
        if (plugin_items.length > 0) {
            MenuBuildUtils.addPluginMenuItems((Composite)parent, plugin_items, pluginMenu, true, true, MenuBuildUtils.BASIC_MENU_ITEM_CONTROLLER);
            MenuFactory.addSeparatorMenuItem(pluginMenu);
        }
        MenuFactory.addPluginInstallMenuItem(pluginMenu);
        MenuFactory.addPluginUnInstallMenuItem(pluginMenu);
        if (includeGetPluginsMenu) {
            MenuFactory.addGetPluginsMenuItem(pluginMenu);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPluginView(String sViewID, UISWTViewEventListener l) {
        IViewInfo view_info = new IViewInfo();
        view_info.viewID = sViewID;
        view_info.event_listener = l;
        String sResourceID = "Views.plugins." + sViewID + ".title";
        boolean bResourceExists = MessageText.keyExists(sResourceID);
        String name = bResourceExists ? MessageText.getString(sResourceID) : ((bResourceExists = MessageText.keyExists(sResourceID = sViewID)) ? MessageText.getString(sResourceID) : sViewID.replace('.', ' '));
        view_info.name = name;
        Map map_to_use = l instanceof BasicPluginViewImpl ? this.plugin_logs_view_info_map : this.plugin_view_info_map;
        try {
            this.plugin_helper_mon.enter();
            map_to_use.put(name, view_info);
        }
        finally {
            this.plugin_helper_mon.exit();
        }
        this.triggerPluginAddedViewListeners(view_info);
    }

    private void removePluginViewsWithID(String sViewID, Map map) {
        if (sViewID == null) {
            return;
        }
        Iterator itr = map.values().iterator();
        IViewInfo view_info = null;
        while (itr.hasNext()) {
            view_info = (IViewInfo)itr.next();
            if (!sViewID.equals(view_info.viewID)) continue;
            itr.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePluginViews(final String sViewID) {
        try {
            this.plugin_helper_mon.enter();
            this.removePluginViewsWithID(sViewID, this.plugin_view_info_map);
            this.removePluginViewsWithID(sViewID, this.plugin_logs_view_info_map);
        }
        finally {
            this.plugin_helper_mon.exit();
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                if (uiFunctions != null) {
                    uiFunctions.closePluginViews(sViewID);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPluginView(AbstractIView view, String name) {
        IViewInfo view_info = new IViewInfo();
        view_info.name = name;
        view_info.view = view;
        try {
            this.plugin_helper_mon.enter();
            this.plugin_view_info_map.put(name, view_info);
        }
        finally {
            this.plugin_helper_mon.exit();
        }
        this.triggerPluginAddedViewListeners(view_info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePluginView(final AbstractIView view, String name) {
        IViewInfo view_info = null;
        try {
            this.plugin_helper_mon.enter();
            view_info = (IViewInfo)this.plugin_view_info_map.remove(name);
        }
        finally {
            this.plugin_helper_mon.exit();
        }
        if (view_info != null) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                    if (uiFunctions != null) {
                        uiFunctions.closePluginView(view);
                    }
                }
            });
        }
    }

    private void createIViewInfoMenuItem(Menu parent, final IViewInfo info) {
        org.eclipse.swt.widgets.MenuItem item = new org.eclipse.swt.widgets.MenuItem(parent, 0);
        item.setText(info.name);
        if (info.viewID != null) {
            item.setData("ViewID", (Object)info.viewID);
        }
        item.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                if (uiFunctions != null) {
                    info.openView(uiFunctions);
                }
            }
        });
    }

    private void createIViewInfoMenuItems(Menu parent, Map menu_data) {
        Iterator itr = menu_data.values().iterator();
        while (itr.hasNext()) {
            this.createIViewInfoMenuItem(parent, (IViewInfo)itr.next());
        }
    }

    public IViewInfo[] getPluginViewsInfo() {
        return this.plugin_view_info_map.values().toArray(new IViewInfo[0]);
    }

    public IViewInfo[] getPluginLogViewsInfo() {
        return this.plugin_logs_view_info_map.values().toArray(new IViewInfo[0]);
    }

    public void addPluginAddedViewListener(PluginAddedViewListener l) {
        this.pluginAddedViewListener.add(l);
    }

    public void triggerPluginAddedViewListeners(IViewInfo viewInfo) {
        Object[] listeners = this.pluginAddedViewListener.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            PluginAddedViewListener l = (PluginAddedViewListener)listeners[i];
            l.pluginViewAdded(viewInfo);
        }
    }

    public static interface PluginAddedViewListener {
        public void pluginViewAdded(IViewInfo var1);
    }

    public static class IViewInfo {
        public AbstractIView view;
        public String name;
        public String viewID;
        public UISWTViewEventListener event_listener;

        public void openView(UIFunctionsSWT uiFunctions) {
            if (this.event_listener != null) {
                uiFunctions.openPluginView("Main", this.viewID, this.event_listener, null, true);
            } else {
                uiFunctions.openPluginView(this.view, this.name);
            }
        }
    }
}

