/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.maketorrent;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.TrackersUtil;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.maketorrent.DirectoryPanel;
import org.gudy.azureus2.ui.swt.maketorrent.MultiTrackerPanel;
import org.gudy.azureus2.ui.swt.maketorrent.NewTorrentWizard;
import org.gudy.azureus2.ui.swt.maketorrent.SingleFilePanel;
import org.gudy.azureus2.ui.swt.maketorrent.WebSeedPanel;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;

public class ModePanel
extends AbstractWizardPanel {
    private Button bSingle;
    private Button bDirectory;
    private Combo tracker;

    public ModePanel(NewTorrentWizard wizard, AbstractWizardPanel previous) {
        super(wizard, previous);
    }

    public void show() {
        final NewTorrentWizard wizard = (NewTorrentWizard)this.wizard;
        wizard.setTitle(MessageText.getString("wizard.mode"));
        wizard.setCurrentInfo(MessageText.getString("wizard.singlefile.help"));
        Composite rootPanel = wizard.getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout((Layout)layout);
        Composite panel = new Composite(rootPanel, 0x400000);
        GridData gridData = new GridData(772);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 4;
        panel.setLayout((Layout)layout);
        final Button btnLocalTracker = new Button(panel, 16);
        Messages.setLanguageText((Widget)btnLocalTracker, "wizard.tracker.local");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        btnLocalTracker.setLayoutData((Object)gridData);
        final Button btnSSL = new Button(panel, 32);
        Messages.setLanguageText((Widget)btnSSL, "wizard.tracker.ssl");
        gridData = new GridData(128);
        gridData.horizontalSpan = 2;
        btnSSL.setLayoutData((Object)gridData);
        final String localTrackerHost = COConfigurationManager.getStringParameter("Tracker IP", "");
        final int localTrackerPort = COConfigurationManager.getIntParameter("Tracker Port", 6969);
        final int localTrackerPortSSL = COConfigurationManager.getIntParameter("Tracker Port SSL", 7000);
        final boolean SSLEnabled = COConfigurationManager.getBooleanParameter("Tracker Port SSL Enable", false);
        final String[] localTrackerUrl = new String[1];
        boolean showLocal = TRTrackerUtils.isTrackerEnabled();
        final Label labelLocalAnnounce = showLocal ? new Label(panel, 0) : null;
        final Label localTrackerValue = new Label(panel, 0);
        if (showLocal) {
            Messages.setLanguageText((Widget)labelLocalAnnounce, "wizard.announceUrl");
            localTrackerUrl[0] = "http://" + UrlUtils.convertIPV6Host(localTrackerHost) + ":" + localTrackerPort + "/announce";
            localTrackerValue.setText(localTrackerUrl[0]);
            btnSSL.setEnabled(SSLEnabled);
            gridData = new GridData();
            gridData.horizontalSpan = 3;
        } else {
            localTrackerUrl[0] = "";
            Messages.setLanguageText((Widget)localTrackerValue, "wizard.tracker.howToLocal");
            btnLocalTracker.setSelection(false);
            btnSSL.setEnabled(false);
            btnLocalTracker.setEnabled(false);
            localTrackerValue.setEnabled(true);
            if (wizard.getTrackerType() == 1) {
                wizard.setTrackerType(2);
            }
            gridData = new GridData();
            gridData.horizontalSpan = 4;
        }
        localTrackerValue.setLayoutData((Object)gridData);
        int tracker_type = wizard.getTrackerType();
        if (tracker_type == 1) {
            this.setTrackerUrl(localTrackerUrl[0]);
        } else if (tracker_type == 2) {
            this.setTrackerUrl("http://");
        } else {
            this.setTrackerUrl(NewTorrentWizard.TT_DECENTRAL_DEFAULT);
        }
        final Button btnExternalTracker = new Button(panel, 16);
        Messages.setLanguageText((Widget)btnExternalTracker, "wizard.tracker.external");
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        btnExternalTracker.setLayoutData((Object)gridData);
        final Label labelExternalAnnounce = new Label(panel, 0);
        Messages.setLanguageText((Widget)labelExternalAnnounce, "wizard.announceUrl");
        btnLocalTracker.setSelection(tracker_type == 1);
        if (showLocal) {
            localTrackerValue.setEnabled(tracker_type == 1);
        }
        btnSSL.setEnabled(SSLEnabled && tracker_type == 1);
        btnExternalTracker.setSelection(tracker_type == 2);
        labelExternalAnnounce.setEnabled(tracker_type == 2);
        this.tracker = new Combo(panel, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.tracker.setLayoutData((Object)gridData);
        List trackers = TrackersUtil.getInstance().getTrackersList();
        Iterator iter = trackers.iterator();
        while (iter.hasNext()) {
            this.tracker.add((String)iter.next());
        }
        this.tracker.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                String text = ModePanel.this.tracker.getText();
                ModePanel.this.setTrackerUrl(text);
                boolean valid = true;
                String errorMessage = "";
                try {
                    new URL(text);
                }
                catch (MalformedURLException e) {
                    valid = false;
                    errorMessage = MessageText.getString("wizard.invalidurl");
                }
                wizard.setErrorMessage(errorMessage);
                wizard.setNextEnabled(valid);
            }
        });
        this.tracker.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                String text = ModePanel.this.tracker.getText();
                ModePanel.this.setTrackerUrl(text);
                boolean valid = true;
                String errorMessage = "";
                try {
                    new URL(text);
                }
                catch (MalformedURLException ex) {
                    valid = false;
                    errorMessage = MessageText.getString("wizard.invalidurl");
                }
                wizard.setErrorMessage(errorMessage);
                wizard.setNextEnabled(valid);
            }
        });
        this.updateTrackerURL();
        this.tracker.setEnabled(tracker_type == 2);
        new Label(panel, 0);
        final Button btnDHTTracker = new Button(panel, 16);
        Messages.setLanguageText((Widget)btnDHTTracker, "wizard.tracker.dht");
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        btnDHTTracker.setLayoutData((Object)gridData);
        btnDHTTracker.setSelection(tracker_type == 3);
        panel = new Composite(rootPanel, 0x400000);
        gridData = new GridData(772);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 4;
        panel.setLayout((Layout)layout);
        Label label = new Label(panel, 258);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        final Button btnMultiTracker = new Button(panel, 32);
        Messages.setLanguageText((Widget)btnMultiTracker, "wizard.multitracker");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        btnMultiTracker.setLayoutData((Object)gridData);
        btnMultiTracker.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                wizard.useMultiTracker = btnMultiTracker.getSelection();
            }
        });
        btnMultiTracker.setSelection(wizard.useMultiTracker);
        btnMultiTracker.setEnabled(tracker_type != 3);
        final Button btnWebSeed = new Button(panel, 32);
        Messages.setLanguageText((Widget)btnWebSeed, "wizard.webseed");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        btnWebSeed.setLayoutData((Object)gridData);
        btnWebSeed.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                wizard.useWebSeed = btnWebSeed.getSelection();
            }
        });
        btnWebSeed.setSelection(wizard.useWebSeed);
        btnWebSeed.setEnabled(tracker_type != 3);
        final Button btnExtraHashes = new Button(panel, 32);
        Messages.setLanguageText((Widget)btnExtraHashes, "wizard.createtorrent.extrahashes");
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        btnExtraHashes.setLayoutData((Object)gridData);
        btnExtraHashes.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                wizard.setAddOtherHashes(btnExtraHashes.getSelection());
            }
        });
        btnExtraHashes.setSelection(wizard.getAddOtherHashes());
        panel = new Composite(rootPanel, 0);
        gridData = new GridData(772);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 4;
        panel.setLayout((Layout)layout);
        Label label1 = new Label(panel, 258);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        label1.setLayoutData((Object)gridData);
        this.bSingle = new Button(panel, 16);
        this.bSingle.setSelection(!wizard.create_from_dir);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.bSingle.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)this.bSingle, "wizard.singlefile");
        this.bSingle.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                ModePanel.this.activateMode(true);
            }
        });
        this.bDirectory = new Button(panel, 16);
        this.bDirectory.setSelection(wizard.create_from_dir);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.bDirectory.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)this.bDirectory, "wizard.directory");
        this.bDirectory.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                ModePanel.this.activateMode(false);
            }
        });
        btnSSL.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                String url = btnSSL.getSelection() ? "https://" + UrlUtils.convertIPV6Host(localTrackerHost) + ":" + localTrackerPortSSL + "/announce" : "http://" + UrlUtils.convertIPV6Host(localTrackerHost) + ":" + localTrackerPort + "/announce";
                localTrackerValue.setText(url);
                localTrackerUrl[0] = url;
                ModePanel.this.setTrackerUrl(url);
            }
        });
        btnLocalTracker.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                wizard.setTrackerType(1);
                ModePanel.this.setTrackerUrl(localTrackerUrl[0]);
                ModePanel.this.updateTrackerURL();
                btnExternalTracker.setSelection(false);
                btnLocalTracker.setSelection(true);
                btnDHTTracker.setSelection(false);
                ModePanel.this.tracker.setEnabled(false);
                btnSSL.setEnabled(SSLEnabled);
                if (labelLocalAnnounce != null) {
                    labelLocalAnnounce.setEnabled(true);
                }
                localTrackerValue.setEnabled(true);
                labelExternalAnnounce.setEnabled(false);
                btnMultiTracker.setEnabled(true);
            }
        });
        btnExternalTracker.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                wizard.setTrackerType(2);
                ModePanel.this.setTrackerUrl("http://");
                ModePanel.this.updateTrackerURL();
                btnLocalTracker.setSelection(false);
                btnExternalTracker.setSelection(true);
                btnDHTTracker.setSelection(false);
                ModePanel.this.tracker.setEnabled(true);
                btnSSL.setEnabled(false);
                if (labelLocalAnnounce != null) {
                    labelLocalAnnounce.setEnabled(false);
                }
                localTrackerValue.setEnabled(false);
                labelExternalAnnounce.setEnabled(true);
                btnMultiTracker.setEnabled(true);
            }
        });
        btnDHTTracker.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                wizard.setTrackerType(3);
                ModePanel.this.setTrackerUrl(NewTorrentWizard.TT_DECENTRAL_DEFAULT);
                ModePanel.this.updateTrackerURL();
                btnLocalTracker.setSelection(false);
                btnExternalTracker.setSelection(false);
                btnDHTTracker.setSelection(true);
                ModePanel.this.tracker.setEnabled(false);
                btnSSL.setEnabled(false);
                if (labelLocalAnnounce != null) {
                    labelLocalAnnounce.setEnabled(false);
                }
                localTrackerValue.setEnabled(false);
                labelExternalAnnounce.setEnabled(false);
                btnMultiTracker.setEnabled(false);
            }
        });
        label = new Label(panel, 258);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        label = new Label(panel, 0);
        Messages.setLanguageText((Widget)label, "wizard.comment");
        final Text comment = new Text(panel, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        comment.setLayoutData((Object)gridData);
        comment.setText(wizard.getComment());
        comment.addListener(24, new Listener(){

            public void handleEvent(Event event2) {
                wizard.setComment(comment.getText());
            }
        });
        label = new Label(panel, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        label.setText("\n");
        label = new Label(panel, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        label.setForeground(Colors.blue);
        Messages.setLanguageText((Widget)label, "wizard.hint.mode");
    }

    public IWizardPanel getNextPanel() {
        if (Constants.isOSX && ((NewTorrentWizard)this.wizard).getTrackerType() == 2) {
            this.setTrackerUrl(this.tracker.getText());
        }
        if (((NewTorrentWizard)this.wizard).useMultiTracker) {
            return new MultiTrackerPanel((NewTorrentWizard)this.wizard, this);
        }
        if (((NewTorrentWizard)this.wizard).useWebSeed) {
            return new WebSeedPanel((NewTorrentWizard)this.wizard, this);
        }
        if (((NewTorrentWizard)this.wizard).create_from_dir) {
            return new DirectoryPanel((NewTorrentWizard)this.wizard, (IWizardPanel)this);
        }
        return new SingleFilePanel((NewTorrentWizard)this.wizard, this);
    }

    public boolean isNextEnabled() {
        return true;
    }

    void activateMode(boolean singleFile) {
        this.wizard.setCurrentInfo(MessageText.getString(singleFile ? "wizard.singlefile.help" : "wizard.directory.help"));
        ((NewTorrentWizard)this.wizard).create_from_dir = !singleFile;
        this.bDirectory.setSelection(!singleFile);
        this.bSingle.setSelection(singleFile);
    }

    void updateTrackerURL() {
        this.tracker.setText(((NewTorrentWizard)this.wizard).trackerURL);
    }

    void setTrackerUrl(String url) {
        ((NewTorrentWizard)this.wizard).trackerURL = url;
        String config = ((NewTorrentWizard)this.wizard).multiTrackerConfig;
        if (config.equals("")) {
            List list = (List)((NewTorrentWizard)this.wizard).trackers.get(0);
            if (list.size() > 0) {
                list.remove(0);
            }
            list.add(url);
        }
    }
}

