/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.maketorrent;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.torrent.TOTorrentProgressListener;
import org.gudy.azureus2.core3.tracker.host.TRHostException;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.TrackersUtil;
import org.gudy.azureus2.ui.swt.maketorrent.NewTorrentWizard;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;

public class ProgressPanel
extends AbstractWizardPanel
implements TOTorrentProgressListener {
    Text tasks;
    ProgressBar progress;
    Display display;

    public ProgressPanel(NewTorrentWizard _wizard, IWizardPanel _previousPanel) {
        super(_wizard, _previousPanel);
    }

    public void show() {
        this.display = this.wizard.getDisplay();
        this.wizard.setTitle(MessageText.getString("wizard.progresstitle"));
        this.wizard.setCurrentInfo("");
        this.wizard.setPreviousEnabled(false);
        Composite rootPanel = this.wizard.getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout((Layout)layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(772);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 1;
        panel.setLayout((Layout)layout);
        this.tasks = new Text(panel, 2058);
        this.tasks.setBackground(this.display.getSystemColor(1));
        gridData = new GridData(1808);
        gridData.heightHint = 120;
        this.tasks.setLayoutData((Object)gridData);
        this.progress = new ProgressBar(panel, 0);
        this.progress.setMinimum(0);
        this.progress.setMaximum(0);
        gridData = new GridData(768);
        this.progress.setLayoutData((Object)gridData);
    }

    public void finish() {
        AEThread t = new AEThread("Torrent Maker"){

            public void runSupport() {
                ProgressPanel.this.makeTorrent();
            }
        };
        t.setPriority(1);
        t.setDaemon(true);
        t.start();
    }

    public void makeTorrent() {
        NewTorrentWizard _wizard = (NewTorrentWizard)this.wizard;
        int tracker_type = _wizard.getTrackerType();
        if (tracker_type == 2) {
            TrackersUtil.getInstance().addTracker(_wizard.trackerURL);
        }
        File f = _wizard.create_from_dir ? new File(_wizard.directoryPath) : new File(_wizard.singlePath);
        try {
            TOTorrent torrent;
            URL url = new URL(_wizard.trackerURL);
            if (_wizard.getPieceSizeComputed()) {
                _wizard.creator = TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(f, url, _wizard.getAddOtherHashes());
                _wizard.creator.addListener(this);
                torrent = _wizard.creator.create();
            } else {
                TOTorrentCreator c = TOTorrentFactory.createFromFileOrDirWithFixedPieceLength(f, url, _wizard.getAddOtherHashes(), _wizard.getPieceSizeManual());
                c.addListener(this);
                torrent = c.create();
            }
            if (tracker_type == 3) {
                TorrentUtils.setDecentralised(torrent);
            }
            torrent.setComment(_wizard.getComment());
            TorrentUtils.setDHTBackupEnabled(torrent, _wizard.permitDHT);
            TorrentUtils.setPrivate(torrent, _wizard.privateTorrent);
            LocaleTorrentUtil.setDefaultTorrentEncoding(torrent);
            final File save_dir = _wizard.create_from_dir ? f : f.getParentFile();
            if (_wizard.useMultiTracker) {
                this.reportCurrentTask(MessageText.getString("wizard.addingmt"));
                TorrentUtils.listToAnnounceGroups(((NewTorrentWizard)this.wizard).trackers, torrent);
            }
            if (_wizard.useWebSeed && _wizard.webseeds.size() > 0) {
                List webseed;
                this.reportCurrentTask(MessageText.getString("wizard.webseed.adding"));
                Map ws = _wizard.webseeds;
                List getright = (List)ws.get("getright");
                if (getright.size() > 0) {
                    for (int i = 0; i < getright.size(); ++i) {
                        this.reportCurrentTask("    GetRight: " + getright.get(i));
                    }
                    torrent.setAdditionalListProperty("url-list", new ArrayList(getright));
                }
                if ((webseed = (List)ws.get("webseed")).size() > 0) {
                    for (int i = 0; i < webseed.size(); ++i) {
                        this.reportCurrentTask("    WebSeed: " + webseed.get(i));
                    }
                    torrent.setAdditionalListProperty("httpseeds", new ArrayList(webseed));
                }
            }
            this.reportCurrentTask(MessageText.getString("wizard.savingfile"));
            final File torrent_file = new File(((NewTorrentWizard)this.wizard).savePath);
            torrent.serialiseToBEncodedFile(torrent_file);
            this.reportCurrentTask(MessageText.getString("wizard.filesaved"));
            this.wizard.switchToClose();
            if (((NewTorrentWizard)this.wizard).autoOpen) {
                new AEThread("TorrentOpener::openTorrent"){

                    public void runSupport() {
                        boolean default_start_stopped = COConfigurationManager.getBooleanParameter("Default Start Torrents Stopped");
                        byte[] hash = null;
                        try {
                            hash = torrent.getHash();
                        }
                        catch (TOTorrentException e1) {
                            // empty catch block
                        }
                        DownloadManager dm = ((NewTorrentWizard)ProgressPanel.this.wizard).getAzureusCore().getGlobalManager().addDownloadManager(torrent_file.toString(), hash, save_dir.toString(), default_start_stopped ? 70 : 75, true, true, null);
                        if (!default_start_stopped && dm != null) {
                            dm.getGlobalManager().moveTop(new DownloadManager[]{dm});
                        }
                        if (((NewTorrentWizard)((ProgressPanel)ProgressPanel.this).wizard).autoHost && ((NewTorrentWizard)ProgressPanel.this.wizard).getTrackerType() != 2) {
                            try {
                                ((NewTorrentWizard)ProgressPanel.this.wizard).getAzureusCore().getTrackerHost().hostTorrent(torrent, true, false);
                            }
                            catch (TRHostException e) {
                                Logger.log(new LogAlert(true, "Host operation fails", e));
                            }
                        }
                    }
                }.start();
            }
        }
        catch (Exception e) {
            if (e instanceof TOTorrentException) {
                TOTorrentException te = (TOTorrentException)e;
                if (te.getReason() != 9) {
                    this.reportCurrentTask(MessageText.getString("wizard.operationfailed"));
                    this.reportCurrentTask(TorrentUtils.exceptionToText(te));
                }
            } else {
                Debug.printStackTrace(e);
                this.reportCurrentTask(MessageText.getString("wizard.operationfailed"));
                this.reportCurrentTask(Debug.getStackTrace(e));
            }
            this.wizard.switchToClose();
        }
    }

    public void reportCurrentTask(final String task_description) {
        if (this.display != null && !this.display.isDisposed()) {
            this.display.asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    if (ProgressPanel.this.tasks != null && !ProgressPanel.this.tasks.isDisposed()) {
                        ProgressPanel.this.tasks.append(task_description + Text.DELIMITER);
                    }
                }
            });
        }
    }

    public void reportProgress(final int percent_complete) {
        if (this.display != null && !this.display.isDisposed()) {
            this.display.asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    if (ProgressPanel.this.progress != null && !ProgressPanel.this.progress.isDisposed()) {
                        ProgressPanel.this.progress.setSelection(percent_complete);
                    }
                }
            });
        }
    }
}

