/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.shells;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.ImageRepository;

public class GCStringPrinter {
    private static final boolean DEBUG = false;
    private static final String GOOD_STRING = "(/|,jI~`gy";
    private static final int FLAG_SKIPCLIP = 1;
    private static final int FLAG_FULLLINESONLY = 2;
    private static final int FLAG_NODRAW = 4;
    private static final int FLAG_KEEP_URL_INFO = 8;
    private static final Pattern patHREF = Pattern.compile("<\\s*?a\\s.*?href\\s*?=\\s*?\"(.+?)\".*?>(.*?)<\\s*?/a\\s*?>", 2);
    private static final Pattern patAHREF_TITLE = Pattern.compile("title=\\\"([^\\\"]+)", 2);
    private static final Pattern patAHREF_TARGET = Pattern.compile("target=\\\"([^\\\"]+)", 2);
    private static final int MAX_LINE_LEN = 4000;
    private static final int MAX_WORD_LEN = 4000;
    private boolean cutoff;
    private GC gc;
    private String string;
    private Rectangle printArea;
    private int swtFlags;
    private int printFlags;
    private Point size;
    private Color urlColor;
    private List listUrlInfo;
    private Image[] images;
    private float[] imageScales;

    public static boolean printString(GC gc, String string, Rectangle printArea) {
        return GCStringPrinter.printString(gc, string, printArea, false, false);
    }

    public static boolean printString(GC gc, String string, Rectangle printArea, boolean skipClip, boolean fullLinesOnly) {
        return GCStringPrinter.printString(gc, string, printArea, skipClip, fullLinesOnly, 192);
    }

    public static boolean printString(GC gc, String string, Rectangle printArea, boolean skipClip, boolean fullLinesOnly, int swtFlags) {
        try {
            GCStringPrinter sp = new GCStringPrinter(gc, string, printArea, skipClip, fullLinesOnly, swtFlags);
            return sp.printString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean _printString() {
        boolean b = false;
        try {
            boolean wasAdvanced = this.gc.getAdvanced();
            Rectangle clipping = null;
            if (this.gc.getAdvanced() && this.gc.getTextAntialias() == -1 && this.gc.getAlpha() == 255) {
                clipping = this.gc.getClipping();
                this.gc.setAdvanced(false);
                this.gc.setClipping(clipping);
            }
            b = this.__printString();
            if (wasAdvanced) {
                this.gc.setAdvanced(true);
                this.gc.setClipping(clipping);
            }
        }
        catch (Throwable t) {
            Debug.out(t);
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean __printString() {
        block68: {
            block67: {
                block65: {
                    block66: {
                        this.size = new Point(0, 0);
                        if (this.string == null) {
                            return false;
                        }
                        if (this.printArea == null) return false;
                        if (this.printArea.isEmpty()) {
                            return false;
                        }
                        lines = new ArrayList<LineInfo>();
                        while (this.string.indexOf(9) >= 0) {
                            this.string = this.string.replace('\t', ' ');
                        }
                        fullLinesOnly = (this.printFlags & 2) > 0;
                        skipClip = (this.printFlags & 1) > 0;
                        noDraw = (this.printFlags & 4) > 0;
                        v0 = wrap = (this.swtFlags & 64) > 0;
                        if ((this.printFlags & 8) == 0) {
                            htmlMatcher = GCStringPrinter.patHREF.matcher(this.string);
                            hasURL = htmlMatcher.find();
                            if (hasURL) {
                                this.listUrlInfo = new ArrayList<E>(1);
                                while (hasURL) {
                                    urlInfo = new URLInfo();
                                    urlInfo.fullString = htmlMatcher.group();
                                    urlInfo.relStartPos = htmlMatcher.start(0);
                                    urlInfo.url = this.string.substring(htmlMatcher.start(1), htmlMatcher.end(1));
                                    urlInfo.text = this.string.substring(htmlMatcher.start(2), htmlMatcher.end(2));
                                    urlInfo.titleLength = urlInfo.text.length();
                                    matcherTitle = GCStringPrinter.patAHREF_TITLE.matcher(urlInfo.fullString);
                                    if (matcherTitle.find()) {
                                        urlInfo.title = this.string.substring(urlInfo.relStartPos + matcherTitle.start(1), urlInfo.relStartPos + matcherTitle.end(1));
                                    }
                                    if ((matcherTarget = GCStringPrinter.patAHREF_TARGET.matcher(urlInfo.fullString)).find()) {
                                        urlInfo.target = this.string.substring(urlInfo.relStartPos + matcherTarget.start(1), urlInfo.relStartPos + matcherTarget.end(1));
                                    }
                                    this.string = htmlMatcher.replaceFirst(urlInfo.text.replaceAll("\\$", "\\\\\\$"));
                                    this.listUrlInfo.add(urlInfo);
                                    htmlMatcher = GCStringPrinter.patHREF.matcher(this.string);
                                    hasURL = htmlMatcher.find(urlInfo.relStartPos);
                                }
                            }
                        } else {
                            htmlMatcher = GCStringPrinter.patHREF.matcher(this.string);
                            this.string = htmlMatcher.replaceAll("$2");
                        }
                        rectDraw = new Rectangle(this.printArea.x, this.printArea.y, this.printArea.width, this.printArea.height);
                        oldClipping = null;
                        try {
                            if (!skipClip && !noDraw) {
                                oldClipping = this.gc.getClipping();
                                this.gc.setClipping(this.printArea);
                            }
                            iCurrentHeight = 0;
                            currentCharPos = 0;
                            pos1 = this.string.indexOf(10);
                            pos2 = this.string.indexOf(13);
                            if (pos2 == -1) {
                                pos2 = pos1;
                            }
                            if ((posNewLine = Math.min(pos1, pos2)) < 0) {
                                posNewLine = this.string.length();
                            }
                            posLastNewLine = 0;
                            while (posNewLine >= 0 && posLastNewLine < this.string.length()) {
                                sLine = this.string.substring(posLastNewLine, posNewLine);
                                do {
                                    block78: {
                                        block76: {
                                            block77: {
                                                block69: {
                                                    block71: {
                                                        block72: {
                                                            block73: {
                                                                block75: {
                                                                    block74: {
                                                                        block70: {
                                                                            lineInfo = new LineInfo(sLine, currentCharPos);
                                                                            lineInfo = this.processLine(this.gc, lineInfo, this.printArea, wrap, fullLinesOnly, false);
                                                                            sProcessedLine = lineInfo.lineOutputed;
                                                                            if (sProcessedLine == null || sProcessedLine.length() <= 0) break block69;
                                                                            if (lineInfo.width == 0 || lineInfo.height == 0) {
                                                                                gcExtent = this.gc.stringExtent(sProcessedLine);
                                                                                if (lineInfo.width == 0) {
                                                                                    lineInfo.width = gcExtent.x;
                                                                                }
                                                                                if (lineInfo.height == 0) {
                                                                                    lineInfo.height = gcExtent.y;
                                                                                }
                                                                            }
                                                                            extent = new Point(lineInfo.width, lineInfo.height);
                                                                            v1 = isOverY = (iCurrentHeight += extent.y) > this.printArea.height;
                                                                            if (!isOverY || fullLinesOnly) break block70;
                                                                            lines.add(lineInfo);
                                                                            break block71;
                                                                        }
                                                                        if (!isOverY || !fullLinesOnly) break block72;
                                                                        v2 = excess = lineInfo.excessPos >= 0 ? sLine.substring(lineInfo.excessPos) : null;
                                                                        if (excess == null) break block73;
                                                                        if (!fullLinesOnly) break block74;
                                                                        if (lines.size() > 0) {
                                                                            lineInfo = (LineInfo)lines.remove(lines.size() - 1);
                                                                            sProcessedLine = lineInfo.originalLine.length() > 4000 ? lineInfo.originalLine.substring(0, 4000) : lineInfo.originalLine;
                                                                            extent = this.gc.stringExtent(sProcessedLine);
                                                                            break block75;
                                                                        } else {
                                                                            var20_24 = false;
                                                                            var23_27 = null;
                                                                            if (lines.size() <= 0) break block65;
                                                                            fullText = new StringBuffer(this.string.length() + 10);
                                                                            iter = lines.iterator();
                                                                            break block66;
                                                                        }
                                                                    }
                                                                    v3 = sProcessedLine = sProcessedLine.length() > 4000 ? sProcessedLine.substring(0, 4000) : sProcessedLine;
                                                                }
                                                                if (excess.length() > 4000) {
                                                                    excess = excess.substring(0, 4000);
                                                                }
                                                                outputLine = new StringBuffer(sProcessedLine);
                                                                lineInfo.width = extent.x;
                                                                newExcessPos = this.processWord(this.gc, sProcessedLine, " " + excess, this.printArea, false, lineInfo, outputLine, new StringBuffer());
                                                                lineInfo.lineOutputed = outputLine.toString();
                                                                lines.add(lineInfo);
                                                            }
                                                            this.cutoff = true;
                                                            var20_26 = false;
                                                            break block67;
                                                        }
                                                        lines.add(lineInfo);
                                                    }
                                                    v4 = sLine = lineInfo.excessPos >= 0 && wrap != false ? sLine.substring(lineInfo.excessPos) : null;
                                                    if (lineInfo.excessPos < 0) break block76;
                                                    break block77;
                                                }
                                                lines.add(lineInfo);
                                                ++currentCharPos;
                                                break;
                                            }
                                            v5 = lineInfo.excessPos;
                                            break block78;
                                        }
                                        v5 = lineInfo.lineOutputed.length();
                                    }
                                    currentCharPos += v5;
                                } while (sLine != null);
                                if (this.string.length() > posNewLine && this.string.charAt(posNewLine) == '\r' && this.string.charAt(posNewLine + 1) == '\n') {
                                    ++posNewLine;
                                }
                                currentCharPos = posLastNewLine = posNewLine + 1;
                                pos1 = this.string.indexOf(10, posLastNewLine);
                                pos2 = this.string.indexOf(13, posLastNewLine);
                                if (pos2 == -1) {
                                    pos2 = pos1;
                                }
                                if ((posNewLine = Math.min(pos1, pos2)) >= 0) continue;
                                posNewLine = this.string.length();
                            }
                            break block68;
                        }
                        catch (Throwable var22_48) {
                            var23_30 = null;
                            if (lines.size() > 0) {
                                fullText = new StringBuffer(this.string.length() + 10);
                                for (LineInfo lineInfo : lines) {
                                    if (fullText.length() > 0) {
                                        fullText.append('\n');
                                    }
                                    fullText.append(lineInfo.lineOutputed);
                                }
                                for (LineInfo lineInfo : lines) {
                                    this.size.x += Math.max(lineInfo.width, this.size.x);
                                    this.size.y += lineInfo.height;
                                }
                                if ((this.swtFlags & 1024) != 0) {
                                    rectDraw.y = rectDraw.y + rectDraw.height - this.size.y;
                                } else if ((this.swtFlags & 128) == 0) {
                                    rectDraw.y += (rectDraw.height - this.size.y) / 2;
                                }
                                if (!noDraw || this.listUrlInfo != null) {
                                    for (LineInfo lineInfo : lines) {
                                        try {
                                            this.drawLine(this.gc, lineInfo, this.swtFlags, rectDraw, noDraw);
                                        }
                                        catch (Throwable t) {
                                            t.printStackTrace();
                                        }
                                    }
                                }
                            }
                            if (skipClip != false) throw var22_48;
                            if (noDraw != false) throw var22_48;
                            this.gc.setClipping(oldClipping);
                            throw var22_48;
                        }
                    }
                    while (iter.hasNext()) {
                        lineInfo = (LineInfo)iter.next();
                        if (fullText.length() > 0) {
                            fullText.append('\n');
                        }
                        fullText.append(lineInfo.lineOutputed);
                    }
                    for (LineInfo lineInfo : lines) {
                        this.size.x += Math.max(lineInfo.width, this.size.x);
                        this.size.y += lineInfo.height;
                    }
                    if ((this.swtFlags & 1024) != 0) {
                        rectDraw.y = rectDraw.y + rectDraw.height - this.size.y;
                    } else if ((this.swtFlags & 128) == 0) {
                        rectDraw.y += (rectDraw.height - this.size.y) / 2;
                    }
                    if (!noDraw || this.listUrlInfo != null) {
                        for (LineInfo lineInfo : lines) {
                            ** try [egrp 1[TRYBLOCK] [4 : 1596->1617)] { 
lbl193:
                            // 1 sources

                            this.drawLine(this.gc, lineInfo, this.swtFlags, rectDraw, noDraw);
lbl195:
                            // 1 sources

                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }
                    }
                }
                if (skipClip != false) return var20_24;
                if (noDraw != false) return var20_24;
                this.gc.setClipping(oldClipping);
                return var20_24;
            }
            var23_28 = null;
            if (lines.size() > 0) {
                fullText = new StringBuffer(this.string.length() + 10);
                for (LineInfo lineInfo : lines) {
                    if (fullText.length() > 0) {
                        fullText.append('\n');
                    }
                    fullText.append(lineInfo.lineOutputed);
                }
                for (LineInfo lineInfo : lines) {
                    this.size.x += Math.max(lineInfo.width, this.size.x);
                    this.size.y += lineInfo.height;
                }
                if ((this.swtFlags & 1024) != 0) {
                    rectDraw.y = rectDraw.y + rectDraw.height - this.size.y;
                } else if ((this.swtFlags & 128) == 0) {
                    rectDraw.y += (rectDraw.height - this.size.y) / 2;
                }
                if (!noDraw || this.listUrlInfo != null) {
                    for (LineInfo lineInfo : lines) {
                        ** try [egrp 1[TRYBLOCK] [4 : 1596->1617)] { 
lbl226:
                        // 1 sources

                        this.drawLine(this.gc, lineInfo, this.swtFlags, rectDraw, noDraw);
lbl228:
                        // 1 sources

                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                }
            }
            if (skipClip != false) return var20_26;
            if (noDraw != false) return var20_26;
            this.gc.setClipping(oldClipping);
            return var20_26;
        }
        var23_29 = null;
        if (lines.size() > 0) {
            fullText = new StringBuffer(this.string.length() + 10);
            for (LineInfo lineInfo : lines) {
                if (fullText.length() > 0) {
                    fullText.append('\n');
                }
                fullText.append(lineInfo.lineOutputed);
            }
            for (LineInfo lineInfo : lines) {
                this.size.x += Math.max(lineInfo.width, this.size.x);
                this.size.y += lineInfo.height;
            }
            if ((this.swtFlags & 1024) != 0) {
                rectDraw.y = rectDraw.y + rectDraw.height - this.size.y;
            } else if ((this.swtFlags & 128) == 0) {
                rectDraw.y += (rectDraw.height - this.size.y) / 2;
            }
            if (!noDraw || this.listUrlInfo != null) {
                for (LineInfo lineInfo : lines) {
                    ** try [egrp 1[TRYBLOCK] [4 : 1596->1617)] { 
lbl258:
                    // 1 sources

                    this.drawLine(this.gc, lineInfo, this.swtFlags, rectDraw, noDraw);
lbl260:
                    // 1 sources

                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }
        if (!skipClip && !noDraw) {
            this.gc.setClipping(oldClipping);
        }
        if (this.cutoff != false) return false;
        if (this.size.y > this.printArea.height) return false;
        return true;
    }

    private LineInfo processLine(GC gc, LineInfo lineInfo, Rectangle printArea, boolean wrap, boolean fullLinesOnly, boolean hasMoreElements) {
        if (lineInfo.originalLine.length() == 0) {
            lineInfo.lineOutputed = "";
            lineInfo.height = gc.stringExtent((String)GOOD_STRING).y;
            return lineInfo;
        }
        StringBuffer outputLine = new StringBuffer();
        int excessPos = -1;
        if (this.images != null || lineInfo.originalLine.length() > 4000 || gc.stringExtent((String)lineInfo.originalLine).x > printArea.width) {
            StringBuffer space = new StringBuffer(1);
            if (!wrap && this.images == null) {
                String sProcessedLine = lineInfo.originalLine.length() > 4000 ? lineInfo.originalLine.substring(0, 4000) : lineInfo.originalLine;
                excessPos = this.processWord(gc, lineInfo.originalLine, sProcessedLine, printArea, wrap, lineInfo, outputLine, space);
            } else {
                int posLastWordStart = 0;
                int posWordStart = lineInfo.originalLine.indexOf(32);
                if (posWordStart < 0) {
                    posWordStart = lineInfo.originalLine.length();
                }
                int curPos = 0;
                while (posWordStart >= 0 && posLastWordStart < lineInfo.originalLine.length()) {
                    String word = lineInfo.originalLine.substring(posLastWordStart, posWordStart);
                    if (word.length() == 0) {
                        excessPos = -1;
                        outputLine.append(' ');
                    }
                    for (int i = 0; i < word.length(); i += 4000) {
                        int endPos = i + 4000;
                        String subWord = endPos > word.length() ? word.substring(i) : word.substring(i, endPos);
                        excessPos = this.processWord(gc, lineInfo.originalLine, subWord, printArea, wrap, lineInfo, outputLine, space);
                        if (excessPos >= 0) {
                            excessPos += curPos;
                            break;
                        }
                        if (endPos <= word.length()) {
                            space.setLength(0);
                        }
                        curPos += subWord.length() + 1;
                    }
                    if (excessPos < 0) {
                        posLastWordStart = posWordStart + 1;
                        if ((posWordStart = lineInfo.originalLine.indexOf(32, posLastWordStart)) >= 0) continue;
                        posWordStart = lineInfo.originalLine.length();
                        continue;
                    }
                    break;
                }
            }
        } else {
            outputLine.append(lineInfo.originalLine);
        }
        if (!wrap && hasMoreElements && excessPos >= 0) {
            int len = outputLine.length();
            if (len > 2) {
                len -= 2;
            }
            outputLine.setLength(len);
            outputLine.append("\u2026");
            this.cutoff = true;
        }
        lineInfo.excessPos = excessPos;
        lineInfo.lineOutputed = outputLine.toString();
        return lineInfo;
    }

    private int processWord(GC gc, String sLine, String word, Rectangle printArea, boolean wrap, LineInfo lineInfo, StringBuffer outputLine, StringBuffer space) {
        boolean bWordLargerThanWidth;
        int imgIdx;
        if (word.length() == 0) {
            space.append(' ');
            return -1;
        }
        if (this.images != null && word.length() >= 2 && word.charAt(0) == '%' && this.images.length > (imgIdx = word.charAt(1) - 48) && imgIdx >= 0 && this.images[imgIdx] != null) {
            Image img = this.images[imgIdx];
            Rectangle bounds = img.getBounds();
            if (this.imageScales != null && this.imageScales.length > imgIdx) {
                bounds.width = (int)((float)bounds.width * this.imageScales[imgIdx]);
                bounds.height = (int)((float)bounds.height * this.imageScales[imgIdx]);
            }
            Point spaceExtent = gc.stringExtent(space.toString());
            int newWidth = lineInfo.width + bounds.width + spaceExtent.x;
            if (newWidth > printArea.width && (bounds.width + spaceExtent.x < printArea.width || lineInfo.width > 0)) {
                return 0;
            }
            if (lineInfo.imageIndexes == null) {
                lineInfo.imageIndexes = new int[]{imgIdx};
            }
            int targetWidth = lineInfo.width + newWidth;
            lineInfo.width = newWidth;
            lineInfo.height = Math.max(bounds.height, lineInfo.height);
            Point ptWordSize = gc.stringExtent(word.substring(2) + " ");
            if (lineInfo.width + ptWordSize.x > printArea.width) {
                outputLine.append(space);
                outputLine.append(word.substring(0, 2));
                return 2;
            }
            outputLine.append(space);
            space.setLength(0);
            outputLine.append(word.substring(0, 2));
            word = word.substring(2);
        }
        Point ptWordSize = gc.stringExtent(word + " ");
        boolean bl = bWordLargerThanWidth = ptWordSize.x > printArea.width;
        if (bWordLargerThanWidth && lineInfo.width > 0) {
            return 0;
        }
        int targetWidth = lineInfo.width + ptWordSize.x;
        if (targetWidth > printArea.width) {
            int endIndex = word.length();
            long diff = endIndex;
            while (targetWidth != printArea.width) {
                if ((diff = (diff >> 1) + diff % 2L) <= 0L) {
                    diff = 1L;
                }
                if (targetWidth > printArea.width) {
                    if ((endIndex = (int)((long)endIndex - diff)) < 1) {
                        endIndex = 1;
                    }
                } else if ((endIndex = (int)((long)endIndex + diff)) > word.length()) {
                    endIndex = word.length();
                }
                ptWordSize = gc.stringExtent(word.substring(0, endIndex) + " ");
                targetWidth = lineInfo.width + ptWordSize.x;
                if (diff > 1L) continue;
            }
            if (endIndex == 0) {
                endIndex = 1;
            }
            if (targetWidth > printArea.width && endIndex > 1) {
                ptWordSize = gc.stringExtent(word.substring(0, --endIndex) + " ");
            }
            if (endIndex > 0 && outputLine.length() > 0) {
                outputLine.append(space);
            }
            if (endIndex == 0 && outputLine.length() == 0) {
                endIndex = 1;
            }
            if (wrap && ptWordSize.x < printArea.width && !bWordLargerThanWidth) {
                return 0;
            }
            outputLine.append(word.substring(0, endIndex));
            if (!wrap) {
                int len = outputLine.length();
                if (len == 0) {
                    if (word.length() > 0) {
                        outputLine.append(word.charAt(0));
                    } else if (sLine.length() > 0) {
                        outputLine.append(sLine.charAt(0));
                    }
                } else {
                    if (len > 2) {
                        len -= 2;
                    }
                    outputLine.setLength(len);
                    outputLine.append("\u2026");
                    this.cutoff = true;
                }
            }
            return endIndex;
        }
        lineInfo.width += ptWordSize.x;
        if (lineInfo.width > printArea.width) {
            if (space.length() > 0) {
                space.delete(0, space.length());
            }
            if (!wrap) {
                int len = outputLine.length();
                if (len == 0) {
                    if (word.length() > 0) {
                        outputLine.append(word.charAt(0));
                    } else if (sLine.length() > 0) {
                        outputLine.append(sLine.charAt(0));
                    }
                } else {
                    if (len > 2) {
                        len -= 2;
                    }
                    outputLine.setLength(len);
                    outputLine.append("\u2026");
                    this.cutoff = true;
                }
                return -1;
            }
            return 0;
        }
        if (outputLine.length() > 0) {
            outputLine.append(space);
        }
        outputLine.append(word);
        if (space.length() > 0) {
            space.delete(0, space.length());
        }
        space.append(' ');
        return -1;
    }

    private void drawLine(GC gc, LineInfo lineInfo, int swtFlags, Rectangle printArea, boolean noDraw) {
        String text = lineInfo.lineOutputed;
        if (lineInfo.width == 0 || lineInfo.height == 0) {
            Point gcExtent = gc.stringExtent(text);
            if (lineInfo.width == 0) {
                lineInfo.width = gcExtent.x;
            }
            if (lineInfo.height == 0) {
                lineInfo.height = gcExtent.y;
            }
        }
        Point drawSize = new Point(lineInfo.width, lineInfo.height);
        int x0 = (swtFlags & 0x20000) > 0 ? printArea.x + printArea.width - drawSize.x : ((swtFlags & 0x1000000) > 0 ? printArea.x + (printArea.width - drawSize.x) / 2 : printArea.x);
        int y0 = printArea.y;
        int lineInfoRelEndPos = lineInfo.relStartPos + lineInfo.lineOutputed.length();
        int relStartPos = lineInfo.relStartPos;
        int lineStartPos = 0;
        URLInfo urlInfo = null;
        boolean drawURL = this.hasHitUrl();
        if (drawURL) {
            URLInfo[] hitUrlInfo = this.getHitUrlInfo();
            int nextHitUrlInfoPos = 0;
            while (drawURL) {
                int i;
                drawURL = false;
                for (i = nextHitUrlInfoPos; i < hitUrlInfo.length; ++i) {
                    urlInfo = hitUrlInfo[i];
                    boolean bl = drawURL = urlInfo.relStartPos < lineInfoRelEndPos && urlInfo.relStartPos + urlInfo.titleLength > relStartPos && relStartPos >= lineInfo.relStartPos && relStartPos < lineInfoRelEndPos;
                    if (!drawURL) continue;
                    nextHitUrlInfoPos = i + 1;
                    break;
                }
                if (!drawURL) break;
                i = lineStartPos + urlInfo.relStartPos - relStartPos;
                if (i > 0 && i > lineStartPos && i <= text.length()) {
                    String s = text.substring(lineStartPos, i);
                    x0 += this.drawText((GC)gc, (String)s, (int)x0, (int)y0, (int)lineInfo.height, null, (boolean)noDraw).x;
                    relStartPos += i - lineStartPos;
                    lineStartPos += i - lineStartPos;
                }
                int end = i + urlInfo.titleLength;
                if (i < 0) {
                    i = 0;
                }
                if (end > text.length()) {
                    end = text.length();
                }
                String s = text.substring(i, end);
                relStartPos += end - i;
                lineStartPos += end - i;
                Point pt = null;
                Color fgColor = null;
                if (!noDraw) {
                    fgColor = gc.getForeground();
                    if (urlInfo.dropShadowColor != null) {
                        gc.setForeground(urlInfo.dropShadowColor);
                        this.drawText(gc, s, x0 + 1, y0 + 1, lineInfo.height, null, noDraw);
                    }
                    if (urlInfo.urlColor != null) {
                        gc.setForeground(urlInfo.urlColor);
                    } else if (this.urlColor != null) {
                        gc.setForeground(this.urlColor);
                    }
                }
                if (urlInfo.hitAreas == null) {
                    urlInfo.hitAreas = new ArrayList(1);
                }
                pt = this.drawText(gc, s, x0, y0, lineInfo.height, urlInfo.hitAreas, noDraw);
                if (!noDraw) {
                    if (urlInfo.urlUnderline) {
                        gc.drawLine(x0, y0 + pt.y - 1, x0 + pt.x - 1, y0 + pt.y - 1);
                    }
                    gc.setForeground(fgColor);
                }
                if (urlInfo.hitAreas == null) {
                    urlInfo.hitAreas = new ArrayList(1);
                }
                x0 += pt.x;
            }
        }
        if (lineStartPos < text.length()) {
            String s = text.substring(lineStartPos);
            if (!noDraw) {
                this.drawText(gc, s, x0, y0, lineInfo.height, null, noDraw);
            }
        }
        printArea.y += drawSize.y;
    }

    private Point drawText(GC gc, String s, int x, int y, int height, List hitAreas, boolean nodraw) {
        if (this.images != null) {
            Point textExtent;
            int pctPos = s.indexOf(37);
            int lastPos = 0;
            int w = 0;
            int h = 0;
            while (pctPos >= 0) {
                if (pctPos >= 0 && s.length() > pctPos + 1) {
                    int centerY;
                    String sStart;
                    int imgIdx = s.charAt(pctPos + 1) - 48;
                    if (imgIdx >= this.images.length || imgIdx < 0 || this.images[imgIdx] == null) {
                        sStart = s.substring(lastPos, pctPos + 1);
                        textExtent = gc.textExtent(sStart);
                        centerY = y + (height / 2 - textExtent.y / 2);
                        if (hitAreas != null) {
                            hitAreas.add(new Rectangle(x, centerY, textExtent.x, textExtent.y));
                        }
                        if (!nodraw) {
                            gc.drawText(sStart, x, centerY, true);
                        }
                        x += textExtent.x;
                        w += textExtent.x;
                        h = Math.max(h, textExtent.y);
                        lastPos = pctPos + 1;
                        pctPos = s.indexOf(37, pctPos + 1);
                        continue;
                    }
                    sStart = s.substring(lastPos, pctPos);
                    textExtent = gc.textExtent(sStart);
                    centerY = y + (height / 2 - textExtent.y / 2);
                    if (!nodraw) {
                        gc.drawText(sStart, x, centerY, true);
                    }
                    x += textExtent.x;
                    w += textExtent.x;
                    h = Math.max(h, textExtent.y);
                    if (hitAreas != null) {
                        hitAreas.add(new Rectangle(x, centerY, textExtent.x, textExtent.y));
                    }
                    Rectangle imgBounds = this.images[imgIdx].getBounds();
                    float scale = 1.0f;
                    if (this.imageScales != null && this.imageScales.length > imgIdx) {
                        scale = this.imageScales[imgIdx];
                    }
                    int scaleImageWidth = (int)((float)imgBounds.width * scale);
                    int scaleImageHeight = (int)((float)imgBounds.height * scale);
                    centerY = y + (height / 2 - scaleImageHeight / 2);
                    if (hitAreas != null) {
                        hitAreas.add(new Rectangle(x, centerY, scaleImageWidth, scaleImageHeight));
                    }
                    if (!nodraw) {
                        gc.drawImage(this.images[imgIdx], 0, 0, imgBounds.width, imgBounds.height, x, centerY, scaleImageWidth, scaleImageHeight);
                    }
                    x += scaleImageWidth;
                    w += scaleImageWidth;
                    h = Math.max(h, scaleImageHeight);
                }
                lastPos = pctPos + 2;
                pctPos = s.indexOf(37, lastPos);
            }
            if (s.length() >= lastPos) {
                String sEnd = s.substring(lastPos);
                textExtent = gc.textExtent(sEnd);
                int centerY = y + (height / 2 - textExtent.y / 2);
                if (hitAreas != null) {
                    hitAreas.add(new Rectangle(x, centerY, textExtent.x, textExtent.y));
                }
                if (!nodraw) {
                    gc.drawText(sEnd, x, centerY, true);
                }
                x += textExtent.x;
                w += textExtent.x;
                h = Math.max(h, textExtent.y);
            }
            return new Point(w, h);
        }
        if (!nodraw) {
            gc.drawText(s, x, y, true);
        }
        Point textExtent = gc.textExtent(s);
        if (hitAreas != null) {
            hitAreas.add(new Rectangle(x, y, textExtent.x, textExtent.y));
        }
        return textExtent;
    }

    public static void main(String[] args) {
        final Display display = Display.getDefault();
        final Shell shell = new Shell(display, 1264);
        ImageRepository.loadImagesForSplashWindow(display);
        final Image[] images = new Image[]{ImageRepository.getImage("azureus32"), ImageRepository.getImage("azureus64"), ImageRepository.getImage("azureus"), ImageRepository.getImage("azureus128")};
        String text = "Apple <A HREF=\"aa\">Banana</a>, Cow <A HREF=\"ss\">Dug Ergo</a>, Flip Only. test of the string printer averlongwordthisisyesindeed";
        shell.setSize(500, 500);
        GridLayout gridLayout = new GridLayout(2, false);
        shell.setLayout((Layout)gridLayout);
        Composite cButtons = new Composite((Composite)shell, 0);
        GridData gridData = new GridData(0, 4, false, true);
        cButtons.setLayoutData((Object)gridData);
        final Canvas cPaint = new Canvas((Composite)shell, 0x20000000);
        gridData = new GridData(4, 4, true, true);
        cPaint.setLayoutData((Object)gridData);
        cButtons.setLayout((Layout)new RowLayout(512));
        Listener l = new Listener(){

            public void handleEvent(Event event2) {
                cPaint.redraw();
            }
        };
        final Text txtText = new Text(cButtons, 2114);
        txtText.setText("Apple <A HREF=\"aa\">Banana</a>, Cow <A HREF=\"ss\">Dug Ergo</a>, Flip Only. test of the string printer averlongwordthisisyesindeed");
        txtText.addListener(24, l);
        txtText.setLayoutData((Object)new RowData(100, 200));
        txtText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 97 && e.stateMask == 262144) {
                    txtText.selectAll();
                }
            }
        });
        final Button btnSkipClip = new Button(cButtons, 32);
        btnSkipClip.setText("Skip Clip");
        btnSkipClip.setSelection(true);
        btnSkipClip.addListener(13, l);
        final Button btnFullOnly = new Button(cButtons, 32);
        btnFullOnly.setText("Full Lines Only");
        btnFullOnly.setSelection(true);
        btnFullOnly.addListener(13, l);
        final Combo cboVAlign = new Combo(cButtons, 8);
        cboVAlign.add("Top");
        cboVAlign.add("Bottom");
        cboVAlign.add("None");
        cboVAlign.addListener(13, l);
        cboVAlign.select(0);
        final Combo cboHAlign = new Combo(cButtons, 8);
        cboHAlign.add("Left");
        cboHAlign.add("Center");
        cboHAlign.add("Right");
        cboHAlign.add("None");
        cboHAlign.addListener(13, l);
        cboHAlign.select(0);
        final Button btnWrap = new Button(cButtons, 32);
        btnWrap.setText("Wrap");
        btnWrap.setSelection(true);
        btnWrap.addListener(13, l);
        final Label lblInfo = new Label((Composite)shell, 64);
        lblInfo.setText("Welcome");
        Listener l2 = new Listener(){
            URLInfo lastHitInfo = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEvent(Event event2) {
                boolean ourGC;
                GC gc = event2.gc;
                boolean bl = ourGC = gc == null;
                if (ourGC) {
                    gc = new GC((Drawable)cPaint);
                }
                try {
                    GCStringPrinter sp = this.buildSP(gc);
                    Color colorURL = gc.getDevice().getSystemColor(3);
                    Color colorURL2 = gc.getDevice().getSystemColor(12);
                    if (event2.type == 5) {
                        String url2;
                        Point pt = cPaint.toControl(display.getCursorLocation());
                        URLInfo hitUrl = sp.getHitUrl(pt.x, pt.y);
                        String url1 = hitUrl == null || hitUrl.url == null ? "" : hitUrl.url;
                        String string = url2 = this.lastHitInfo == null || this.lastHitInfo.url == null ? "" : this.lastHitInfo.url;
                        if (url1.equals(url2)) {
                            return;
                        }
                        cPaint.redraw();
                        this.lastHitInfo = hitUrl;
                        return;
                    }
                    Rectangle bounds = cPaint.getClientArea();
                    Color colorBox = gc.getDevice().getSystemColor(7);
                    Color colorText = gc.getDevice().getSystemColor(2);
                    gc.setForeground(colorText);
                    Point pt = cPaint.toControl(display.getCursorLocation());
                    sp.setUrlColor(colorURL);
                    URLInfo hitUrl = sp.getHitUrl(pt.x, pt.y);
                    if (hitUrl != null) {
                        shell.setCursor(shell.getDisplay().getSystemCursor(21));
                        hitUrl.urlColor = colorURL2;
                    } else {
                        shell.setCursor(null);
                    }
                    boolean fit = sp.printString();
                    lblInfo.setText(fit ? "fit" : "no fit");
                    --bounds.width;
                    --bounds.height;
                    gc.setForeground(colorBox);
                    gc.drawRectangle(bounds);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                finally {
                    if (ourGC) {
                        gc.dispose();
                    }
                }
            }

            private GCStringPrinter buildSP(GC gc) {
                int style;
                Rectangle bounds = cPaint.getClientArea();
                int n = style = btnWrap.getSelection() ? 64 : 0;
                if (cboVAlign.getSelectionIndex() == 0) {
                    style |= 0x80;
                } else if (cboVAlign.getSelectionIndex() == 1) {
                    style |= 0x400;
                }
                if (cboHAlign.getSelectionIndex() == 0) {
                    style |= 0x4000;
                } else if (cboHAlign.getSelectionIndex() == 1) {
                    style |= 0x1000000;
                } else if (cboHAlign.getSelectionIndex() == 2) {
                    style |= 0x20000;
                }
                String text = txtText.getText();
                text = text.replaceAll("\r\n", "\n");
                GCStringPrinter sp = new GCStringPrinter(gc, text, bounds, btnSkipClip.getSelection(), btnFullOnly.getSelection(), style);
                sp.setImages(images);
                sp.calculateMetrics();
                return sp;
            }
        };
        cPaint.addListener(9, l2);
        cPaint.addListener(5, l2);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public GCStringPrinter(GC gc, String string, Rectangle printArea, boolean skipClip, boolean fullLinesOnly, int swtFlags) {
        this.gc = gc;
        this.string = string;
        this.printArea = printArea;
        this.swtFlags = swtFlags;
        this.printFlags = 0;
        if (skipClip) {
            this.printFlags |= 1;
        }
        if (fullLinesOnly) {
            this.printFlags |= 2;
        }
    }

    public GCStringPrinter(GC gc, String string, Rectangle printArea, int printFlags, int swtFlags) {
        this.gc = gc;
        this.string = string;
        this.printArea = printArea;
        this.swtFlags = swtFlags;
        this.printFlags = printFlags;
    }

    public boolean printString() {
        return this._printString();
    }

    public boolean printString(int printFlags) {
        int oldPrintFlags = this.printFlags;
        printFlags |= printFlags;
        boolean b = this._printString();
        this.printFlags = oldPrintFlags;
        return b;
    }

    public void calculateMetrics() {
        int oldPrintFlags = this.printFlags;
        this.printFlags |= 4;
        this._printString();
        this.printFlags = oldPrintFlags;
    }

    public void printString(GC gc, Rectangle rectangle, int swtFlags) {
        this.gc = gc;
        int printFlags = this.printFlags;
        if (this.printArea.width == rectangle.width) {
            printFlags |= 8;
        }
        this.printArea = rectangle;
        this.swtFlags = swtFlags;
        this.printString(printFlags);
    }

    public Point getCalculatedSize() {
        return this.size;
    }

    public Color getUrlColor() {
        return this.urlColor;
    }

    public void setUrlColor(Color urlColor) {
        this.urlColor = urlColor;
    }

    public URLInfo getHitUrl(int x, int y) {
        if (this.listUrlInfo == null || this.listUrlInfo.size() == 0) {
            return null;
        }
        for (URLInfo urlInfo : this.listUrlInfo) {
            if (urlInfo.hitAreas == null) continue;
            for (Rectangle r : urlInfo.hitAreas) {
                if (!r.contains(x, y)) continue;
                return urlInfo;
            }
        }
        return null;
    }

    public URLInfo[] getHitUrlInfo() {
        if (this.listUrlInfo == null) {
            return new URLInfo[0];
        }
        return this.listUrlInfo.toArray(new URLInfo[0]);
    }

    public boolean hasHitUrl() {
        return this.listUrlInfo != null && this.listUrlInfo.size() > 0;
    }

    public boolean isCutoff() {
        return this.cutoff;
    }

    public void setImages(Image[] images) {
        this.images = images;
    }

    public float[] getImageScales() {
        return this.imageScales;
    }

    public void setImageScales(float[] imageScales) {
        this.imageScales = imageScales;
    }

    public String getText() {
        return this.string;
    }

    private class LineInfo {
        public int width;
        String originalLine;
        String lineOutputed;
        int excessPos;
        public int relStartPos;
        public int height;
        public int[] imageIndexes;

        public LineInfo(String originalLine, int relStartPos) {
            this.originalLine = originalLine;
            this.relStartPos = relStartPos;
        }

        public String toString() {
            return super.toString() + ": relStart=" + this.relStartPos + ";xcess=" + this.excessPos + ";orig=" + this.originalLine + ";output=" + this.lineOutputed;
        }
    }

    public static class URLInfo {
        public String url;
        public String text;
        public Color urlColor;
        public Color dropShadowColor;
        int relStartPos;
        public List hitAreas = null;
        int titleLength;
        public String fullString;
        public String title;
        public String target;
        public boolean urlUnderline;

        public String toString() {
            return super.toString() + ": relStart=" + this.relStartPos + ";url=" + this.url + ";title=" + this.text + ";hit=" + (this.hitAreas == null ? 0 : this.hitAreas.size());
        }
    }
}

