/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.stats;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.stats.transfer.OverallStats;
import org.gudy.azureus2.core3.stats.transfer.StatsFactory;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.Legend;
import org.gudy.azureus2.ui.swt.components.graphics.SpeedGraphic;
import org.gudy.azureus2.ui.swt.views.AbstractIView;

public class ActivityView
extends AbstractIView
implements ParameterListener {
    GlobalManager manager;
    GlobalManagerStats stats;
    OverallStats totalStats;
    Composite panel;
    Canvas downSpeedCanvas;
    SpeedGraphic downSpeedGraphic;
    Canvas upSpeedCanvas;
    SpeedGraphic upSpeedGraphic;

    public ActivityView(GlobalManager manager) {
        this.manager = manager;
        this.stats = manager.getStats();
        this.totalStats = StatsFactory.getStats();
    }

    public void periodicUpdate() {
        int swarms_peer_speed = (int)this.stats.getTotalSwarmsPeerRate(true, false);
        this.downSpeedGraphic.addIntsValue(new int[]{this.stats.getDataReceiveRate() + this.stats.getProtocolReceiveRate(), this.stats.getProtocolReceiveRate(), COConfigurationManager.getIntParameter("Max Download Speed KBs") * 1024, swarms_peer_speed});
        this.upSpeedGraphic.addIntsValue(new int[]{this.stats.getDataSendRate() + this.stats.getProtocolSendRate(), this.stats.getProtocolSendRate(), COConfigurationManager.getIntParameter(TransferSpeedValidator.getActiveUploadParameter(this.manager)) * 1024, swarms_peer_speed});
    }

    public void initialize(Composite composite) {
        this.panel = new Composite(composite, 0);
        this.panel.setLayout((Layout)new GridLayout());
        Group gDownSpeed = new Group(this.panel, 0);
        Messages.setLanguageText((Widget)gDownSpeed, "SpeedView.downloadSpeed.title");
        GridData gridData = new GridData(1808);
        gDownSpeed.setLayoutData((Object)gridData);
        gDownSpeed.setLayout((Layout)new GridLayout());
        this.downSpeedCanvas = new Canvas((Composite)gDownSpeed, 262144);
        gridData = new GridData(1808);
        this.downSpeedCanvas.setLayoutData((Object)gridData);
        this.downSpeedGraphic = SpeedGraphic.getInstance();
        this.downSpeedGraphic.initialize(this.downSpeedCanvas);
        Color[] colors = this.downSpeedGraphic.colors;
        Group gUpSpeed = new Group(this.panel, 0);
        Messages.setLanguageText((Widget)gUpSpeed, "SpeedView.uploadSpeed.title");
        gridData = new GridData(1808);
        gUpSpeed.setLayoutData((Object)gridData);
        gUpSpeed.setLayout((Layout)new GridLayout());
        this.upSpeedCanvas = new Canvas((Composite)gUpSpeed, 262144);
        gridData = new GridData(1808);
        this.upSpeedCanvas.setLayoutData((Object)gridData);
        this.upSpeedGraphic = SpeedGraphic.getInstance();
        this.upSpeedGraphic.initialize(this.upSpeedCanvas);
        COConfigurationManager.addAndFireParameterListener("Stats Graph Dividers", this);
        this.upSpeedGraphic.setLineColors(colors);
        String[] colorConfigs = new String[]{"ActivityView.legend.peeraverage", "ActivityView.legend.achieved", "ActivityView.legend.overhead", "ActivityView.legend.limit", "ActivityView.legend.swarmaverage", "ActivityView.legend.trimmed"};
        Legend.createLegendComposite(this.panel, colors, colorConfigs);
    }

    public void delete() {
        Utils.disposeComposite(this.panel);
        this.downSpeedGraphic.dispose();
        this.upSpeedGraphic.dispose();
        COConfigurationManager.removeParameterListener("Stats Graph Dividers", this);
    }

    public String getFullTitle() {
        return MessageText.getString("SpeedView.title.full");
    }

    public Composite getComposite() {
        return this.panel;
    }

    public void refresh() {
        this.downSpeedGraphic.refresh();
        this.upSpeedGraphic.refresh();
    }

    public String getData() {
        return "SpeedView.title.full";
    }

    public void parameterChanged(String param_name) {
        boolean update_dividers = COConfigurationManager.getBooleanParameter("Stats Graph Dividers");
        int update_divider_width = update_dividers ? 60 : 0;
        this.downSpeedGraphic.setUpdateDividerWidth(update_divider_width);
        this.upSpeedGraphic.setUpdateDividerWidth(update_divider_width);
    }
}

