/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.impl;

import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import java.util.ArrayList;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseMoveListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellVisibilityListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerFileInfoImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerTorrentImpl;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedTableItem;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;
import org.gudy.azureus2.ui.swt.views.table.TableRowSWT;

public class FakeTableCell
implements TableCellSWT,
PaintListener,
MouseListener,
MouseMoveListener,
MouseTrackListener {
    private AEMonitor this_mon = new AEMonitor("FakeTableCell");
    private ArrayList refreshListeners;
    private ArrayList disposeListeners;
    private ArrayList tooltipListeners;
    private ArrayList cellMouseListeners;
    private ArrayList cellMouseMoveListeners;
    private ArrayList cellVisibilityListeners;
    private Image image;
    private Rectangle imageBounds;
    private int marginHeight;
    private int orientation;
    private int marginWidth;
    private Comparable sortValue;
    private Object coreDataSource;
    private Composite composite;
    private final TableColumnCore tableColumn;
    private Graphic graphic;
    private String text;
    private Object pluginDataSource;
    private Object tooltip;
    private Rectangle cellArea;
    private boolean hadMore;
    private ArrayList cellSWTPaintListeners;
    private boolean valid = false;

    public FakeTableCell(TableColumn column) {
        this.tableColumn = (TableColumnCore)column;
        this.setOrientationViaColumn();
    }

    public FakeTableCell(TableColumnCore column) {
        this.tableColumn = column;
        this.setOrientationViaColumn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRefreshListener(TableCellRefreshListener listener) {
        try {
            this.this_mon.enter();
            if (this.refreshListeners == null) {
                this.refreshListeners = new ArrayList(1);
            }
            this.refreshListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRefreshListener(TableCellRefreshListener listener) {
        try {
            this.this_mon.enter();
            if (this.refreshListeners == null) {
                return;
            }
            this.refreshListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDisposeListener(TableCellDisposeListener listener) {
        try {
            this.this_mon.enter();
            if (this.disposeListeners == null) {
                this.disposeListeners = new ArrayList(1);
            }
            this.disposeListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDisposeListener(TableCellDisposeListener listener) {
        try {
            this.this_mon.enter();
            if (this.disposeListeners == null) {
                return;
            }
            this.disposeListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToolTipListener(TableCellToolTipListener listener) {
        try {
            this.this_mon.enter();
            if (this.tooltipListeners == null) {
                this.tooltipListeners = new ArrayList(1);
            }
            this.tooltipListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToolTipListener(TableCellToolTipListener listener) {
        try {
            this.this_mon.enter();
            if (this.tooltipListeners == null) {
                return;
            }
            this.tooltipListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMouseListener(TableCellMouseListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellMouseListeners == null) {
                this.cellMouseListeners = new ArrayList(1);
            }
            this.cellMouseListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMouseListener(TableCellMouseListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellMouseListeners == null) {
                return;
            }
            this.cellMouseListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMouseMoveListener(TableCellMouseMoveListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellMouseMoveListeners == null) {
                this.cellMouseMoveListeners = new ArrayList(1);
            }
            this.cellMouseMoveListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMouseMoveListener(TableCellMouseMoveListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellMouseMoveListeners == null) {
                return;
            }
            this.cellMouseMoveListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVisibilityListener(TableCellVisibilityListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellVisibilityListeners == null) {
                this.cellVisibilityListeners = new ArrayList(1);
            }
            this.cellVisibilityListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVisibilityListener(TableCellVisibilityListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellVisibilityListeners == null) {
                return;
            }
            this.cellVisibilityListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSWTPaintListener(TableCellSWTPaintListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellSWTPaintListeners == null) {
                this.cellSWTPaintListeners = new ArrayList(1);
            }
            this.cellSWTPaintListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void invokeSWTPaintListeners(GC gc) {
        Object[] swtPaintListeners;
        if (this.tableColumn != null && (swtPaintListeners = this.tableColumn.getCellOtherListeners("SWTPaint")) != null) {
            for (int i = 0; i < swtPaintListeners.length; ++i) {
                try {
                    TableCellSWTPaintListener l = (TableCellSWTPaintListener)swtPaintListeners[i];
                    l.cellPaint(gc, this);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        if (this.cellSWTPaintListeners == null) {
            return;
        }
        for (int i = 0; i < this.cellSWTPaintListeners.size(); ++i) {
            try {
                TableCellSWTPaintListener l = (TableCellSWTPaintListener)this.cellSWTPaintListeners.get(i);
                l.cellPaint(gc, this);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void addListeners(Object listenerObject) {
        if (listenerObject instanceof TableCellDisposeListener) {
            this.addDisposeListener((TableCellDisposeListener)listenerObject);
        }
        if (listenerObject instanceof TableCellRefreshListener) {
            this.addRefreshListener((TableCellRefreshListener)listenerObject);
        }
        if (listenerObject instanceof TableCellToolTipListener) {
            this.addToolTipListener((TableCellToolTipListener)listenerObject);
        }
        if (listenerObject instanceof TableCellMouseMoveListener) {
            this.addMouseMoveListener((TableCellMouseMoveListener)listenerObject);
        }
        if (listenerObject instanceof TableCellMouseListener) {
            this.addMouseListener((TableCellMouseListener)listenerObject);
        }
        if (listenerObject instanceof TableCellVisibilityListener) {
            this.addVisibilityListener((TableCellVisibilityListener)listenerObject);
        }
        if (listenerObject instanceof TableCellSWTPaintListener) {
            this.addSWTPaintListener((TableCellSWTPaintListener)listenerObject);
        }
    }

    public void invokeMouseListeners(TableCellMouseEvent event2) {
        ArrayList listeners;
        if (event2.cell != null && event2.row == null) {
            event2.row = event2.cell.getTableRow();
        }
        try {
            this.tableColumn.invokeCellMouseListeners(event2);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        ArrayList arrayList = listeners = event2.eventType == 3 ? this.cellMouseMoveListeners : this.cellMouseListeners;
        if (listeners == null) {
            return;
        }
        for (int i = 0; i < listeners.size(); ++i) {
            try {
                TableCellMouseListener l = (TableCellMouseListener)listeners.get(i);
                l.cellMouseTrigger(event2);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public Object getDataSource() {
        TRHostTorrent item;
        DiskManagerFileInfo fileInfo2;
        PEPiece piece;
        PEPeer peer;
        DownloadManager dm;
        boolean bCoreObject = this.tableColumn.getUseCoreDataSource();
        if (bCoreObject) {
            return this.coreDataSource;
        }
        if (this.pluginDataSource != null) {
            return this.pluginDataSource;
        }
        if (this.coreDataSource instanceof DownloadManager && (dm = (DownloadManager)this.coreDataSource) != null) {
            try {
                this.pluginDataSource = DownloadManagerImpl.getDownloadStatic(dm);
            }
            catch (DownloadException e) {
                // empty catch block
            }
        }
        if (this.coreDataSource instanceof PEPeer && (peer = (PEPeer)this.coreDataSource) != null) {
            this.pluginDataSource = PeerManagerImpl.getPeerForPEPeer(peer);
        }
        if (this.coreDataSource instanceof PEPiece && (piece = (PEPiece)this.coreDataSource) != null) {
            this.pluginDataSource = null;
        }
        if (this.coreDataSource instanceof DiskManagerFileInfo && (fileInfo2 = (DiskManagerFileInfo)this.coreDataSource) != null) {
            try {
                this.pluginDataSource = new DiskManagerFileInfoImpl(DownloadManagerImpl.getDownloadStatic(fileInfo2.getDownloadManager()), fileInfo2);
            }
            catch (DownloadException downloadException) {
                // empty catch block
            }
        }
        if (this.coreDataSource instanceof TRHostTorrent && (item = (TRHostTorrent)this.coreDataSource) != null) {
            this.pluginDataSource = new TrackerTorrentImpl(item);
        }
        return this.pluginDataSource;
    }

    public int[] getForeground() {
        if (this.composite == null || this.composite.isDisposed()) {
            return null;
        }
        Color fg = this.composite.getForeground();
        return new int[]{fg.getRed(), fg.getGreen(), fg.getBlue()};
    }

    public int[] getBackground() {
        return new int[]{0, 0, 0};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graphic getBackgroundGraphic() {
        if (this.composite == null || this.composite.isDisposed()) {
            return null;
        }
        try {
            Rectangle bounds = this.composite.getBounds();
            if (bounds.isEmpty()) {
                return null;
            }
            Image imgCap = new Image((Device)this.composite.getDisplay(), bounds.width, bounds.height);
            Control bgControl = Utils.findBackgroundImageControl((Control)this.composite);
            Image imgBG = this.composite.getBackgroundImage();
            GC gc = new GC((Drawable)imgCap);
            try {
                if (imgBG == null) {
                    gc.setBackground(this.composite.getBackground());
                    gc.fillRectangle(0, 0, bounds.width, bounds.height);
                }
                if (imgBG != null) {
                    Point controlPos = new Point(0, 0);
                    if (bgControl instanceof Composite) {
                        Rectangle compArea = ((Composite)bgControl).getClientArea();
                        controlPos.x = compArea.x;
                        controlPos.y = compArea.y;
                    }
                    Point absControlLoc = bgControl.toDisplay(controlPos.x, controlPos.y);
                    Rectangle shellClientArea = this.composite.getShell().getClientArea();
                    Point absShellLoc = this.composite.getParent().toDisplay(shellClientArea.x, shellClientArea.y);
                    Point ofs = new Point(absControlLoc.x - absShellLoc.x, absControlLoc.y - absShellLoc.y);
                    Rectangle imgBGBounds = imgBG.getBounds();
                    ofs.x %= imgBGBounds.width;
                    ofs.y %= imgBGBounds.height;
                    gc.drawImage(imgBG, ofs.x, ofs.y);
                }
            }
            finally {
                gc.dispose();
            }
            return new UISWTGraphicImpl(imgCap);
        }
        catch (Exception e) {
            Debug.out(e);
            return null;
        }
    }

    public Graphic getGraphic() {
        return this.graphic;
    }

    public int getHeight() {
        if (this.composite != null && !this.composite.isDisposed()) {
            return this.composite.getSize().y;
        }
        return 0;
    }

    public int getMaxLines() {
        return -1;
    }

    public Comparable getSortValue() {
        return this.sortValue;
    }

    public TableColumn getTableColumn() {
        return this.tableColumn;
    }

    public String getTableID() {
        return this.tableColumn == null ? null : this.tableColumn.getTableID();
    }

    public TableRow getTableRow() {
        return null;
    }

    public String getText() {
        return this.text;
    }

    public Object getToolTip() {
        if (this.tooltip == null && this.hadMore) {
            return this.text;
        }
        return this.tooltip;
    }

    public int getWidth() {
        if (!this.isDisposed()) {
            return this.composite.getSize().x;
        }
        return 0;
    }

    public void invalidate() {
        this.valid = false;
    }

    public boolean isDisposed() {
        return this.composite == null || this.composite.isDisposed();
    }

    public boolean isShown() {
        return true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setFillCell(boolean fillCell) {
    }

    public boolean setForeground(int red, int green, int blue) {
        if (this.isDisposed()) {
            return false;
        }
        if (red < 0 || green < 0 || blue < 0) {
            this.composite.setForeground(null);
        } else {
            this.composite.setForeground(ColorCache.getColor((Device)this.composite.getDisplay(), red, green, blue));
        }
        return true;
    }

    public boolean setForeground(int[] rgb) {
        if (rgb == null || rgb.length < 3) {
            return this.setForeground(-1, -1, -1);
        }
        return this.setForeground(rgb[0], rgb[1], rgb[2]);
    }

    public boolean setForegroundToErrorColor() {
        if (this.isDisposed()) {
            return false;
        }
        this.composite.setForeground(Colors.colorError);
        return true;
    }

    public boolean setGraphic(Graphic img) {
        Image imgSWT = null;
        if (img instanceof UISWTGraphic) {
            imgSWT = ((UISWTGraphic)img).getImage();
        }
        if (imgSWT != null && imgSWT.isDisposed()) {
            return false;
        }
        if (this.image == imgSWT) {
            return false;
        }
        this.image = imgSWT;
        if (this.image != null) {
            this.imageBounds = this.image.getBounds();
        }
        if (this.composite != null && !this.composite.isDisposed()) {
            this.redraw();
        }
        this.graphic = img;
        return true;
    }

    public void setMarginHeight(int height) {
    }

    public void setMarginWidth(int width) {
    }

    public boolean setSortValue(Comparable valueToSort) {
        return false;
    }

    public boolean setSortValue(float valueToSort) {
        return false;
    }

    public boolean setText(String text) {
        if (text != null && text.equals(this.text)) {
            return false;
        }
        this.text = text;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (!FakeTableCell.this.isDisposed()) {
                    FakeTableCell.this.composite.redraw();
                }
            }
        });
        return true;
    }

    public void setToolTip(Object tooltip) {
        this.tooltip = tooltip;
        if (!this.isDisposed()) {
            this.composite.setToolTipText(tooltip == null ? null : tooltip.toString());
        }
    }

    private boolean _setSortValue(Comparable valueToSort) {
        if (this.sortValue == valueToSort) {
            return false;
        }
        if (valueToSort instanceof String && this.sortValue instanceof String && this.sortValue.equals(valueToSort)) {
            return false;
        }
        if (valueToSort instanceof Number && this.sortValue instanceof Number && this.sortValue.equals(valueToSort)) {
            return false;
        }
        this.sortValue = valueToSort;
        return true;
    }

    public boolean setSortValue(long valueToSort) {
        if (this.sortValue instanceof Long && (Long)this.sortValue == valueToSort) {
            return false;
        }
        return this._setSortValue(new Long(valueToSort));
    }

    public void doPaint(GC gc, Rectangle bounds) {
        if (this.isDisposed()) {
            return;
        }
        if (bounds == null) {
            return;
        }
        if (this.image != null && !this.image.isDisposed()) {
            int x;
            Point size = new Point(bounds.width, bounds.height);
            int y = this.marginHeight;
            y += (size.y - this.imageBounds.height) / 2;
            if (this.orientation == 0x1000000) {
                x = this.marginWidth;
                x += (size.x - this.marginWidth * 2 - this.imageBounds.width) / 2;
            } else {
                x = this.orientation == 131072 ? bounds.width - this.marginWidth - this.imageBounds.width : this.marginWidth;
            }
            int width = Math.min(bounds.width - x - this.marginWidth, this.imageBounds.width);
            int height = Math.min(bounds.height - y - this.marginHeight, this.imageBounds.height);
            if (width >= 0 && height >= 0) {
                gc.drawImage(this.image, 0, 0, width, height, bounds.x + x, bounds.y + y, width, height);
            }
        }
        if (this.text != null && this.text.length() > 0) {
            GCStringPrinter sp = new GCStringPrinter(gc, this.text, bounds, true, false, this.orientation);
            sp.printString();
            this.hadMore = sp.isCutoff();
        }
        this.invokeSWTPaintListeners(gc);
    }

    public boolean refresh() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                try {
                    FakeTableCell.this.tableColumn.invokeCellRefreshListeners(FakeTableCell.this, false);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                if (FakeTableCell.this.refreshListeners != null) {
                    for (int i = 0; i < FakeTableCell.this.refreshListeners.size(); ++i) {
                        ((TableCellRefreshListener)FakeTableCell.this.refreshListeners.get(i)).refresh(FakeTableCell.this);
                    }
                }
                FakeTableCell.this.valid = true;
            }
        });
        return true;
    }

    public void setDataSource(Object datasource) {
        this.coreDataSource = datasource;
        if (datasource != null && !this.isDisposed()) {
            this.invokeVisibilityListeners(0, true);
        }
    }

    public void setControl(Composite composite) {
        this.setControl(composite, null);
    }

    public void setControl(Composite composite, Rectangle cellArea) {
        if (composite == null) {
            this.dispose();
            this.composite = null;
            return;
        }
        this.composite = composite;
        this.cellArea = cellArea;
        composite.addPaintListener((PaintListener)this);
        composite.addMouseListener((MouseListener)this);
        composite.addMouseMoveListener((MouseMoveListener)this);
        composite.addMouseTrackListener((MouseTrackListener)this);
        this.setForeground(-1, -1, -1);
        this.setText(null);
        this.setToolTip(null);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FakeTableCell.this.dispose();
            }
        });
        if (this.coreDataSource != null && !this.isDisposed()) {
            this.invokeVisibilityListeners(0, true);
        }
    }

    public void paintControl(PaintEvent e) {
        this.doPaint(e.gc, this.cellArea == null ? this.composite.getClientArea() : this.cellArea);
    }

    public void mouseUp(MouseEvent e) {
        this.invokeMouseListeners(this.buildMouseEvent(e, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseDown(MouseEvent e) {
        try {
            if (this.composite == null || this.composite.getMenu() != null || this.cellMouseListeners != null && this.cellMouseListeners.size() > 0 || this.text == null || this.text.length() == 0) {
                return;
            }
            if (e.button != 3 && (e.button != 1 || e.stateMask != 262144)) {
                return;
            }
            Menu menu = new Menu((Decorations)this.composite.getShell(), 8);
            MenuItem item = new MenuItem(menu, 0);
            item.setText(MessageText.getString("ConfigView.copy.to.clipboard.tooltip"));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    if (!FakeTableCell.this.composite.isDisposed() && FakeTableCell.this.text != null && FakeTableCell.this.text.length() > 0) {
                        new Clipboard(FakeTableCell.this.composite.getDisplay()).setContents(new Object[]{FakeTableCell.this.text}, new Transfer[]{TextTransfer.getInstance()});
                    }
                }
            });
            this.composite.setMenu(menu);
            menu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuHidden(MenuEvent arg0) {
                    if (!FakeTableCell.this.composite.isDisposed()) {
                        FakeTableCell.this.composite.setMenu(null);
                    }
                }
            });
            menu.setVisible(true);
        }
        finally {
            this.invokeMouseListeners(this.buildMouseEvent(e, 0));
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        this.invokeMouseListeners(this.buildMouseEvent(e, 2));
    }

    public void mouseMove(MouseEvent e) {
        this.invokeMouseListeners(this.buildMouseEvent(e, 3));
    }

    public void mouseHover(MouseEvent e) {
        this.invokeToolTipListeners(0);
    }

    public void mouseExit(MouseEvent e) {
        this.invokeMouseListeners(this.buildMouseEvent(e, 5));
    }

    public void mouseEnter(MouseEvent e) {
        this.invokeMouseListeners(this.buildMouseEvent(e, 4));
    }

    protected TableCellMouseEvent buildMouseEvent(MouseEvent e, int eventType) {
        if (this.isDisposed()) {
            return null;
        }
        TableCellMouseEvent event2 = new TableCellMouseEvent();
        event2.cell = this;
        event2.button = e.button;
        event2.keyboardState = e.stateMask;
        event2.eventType = eventType;
        Rectangle r = this.composite.getBounds();
        if (this.cellArea != null) {
            r = new Rectangle(r.x + this.cellArea.x, r.y + this.cellArea.y, this.cellArea.width, this.cellArea.height);
        }
        event2.x = e.x - r.x;
        event2.y = e.y - r.y;
        return event2;
    }

    private void setOrientationViaColumn() {
        int align = this.tableColumn.getAlignment();
        if (align == 3) {
            this.orientation = 0x1000000;
        } else if (align == 1) {
            this.orientation = 16384;
        } else if (align == 2) {
            this.orientation = 131072;
        }
    }

    public void dispose() {
        if (this.composite != null && !this.composite.isDisposed()) {
            this.composite.removePaintListener((PaintListener)this);
            this.composite.removeMouseListener((MouseListener)this);
            this.composite.removeMouseMoveListener((MouseMoveListener)this);
            this.composite.removeMouseTrackListener((MouseTrackListener)this);
        }
        if (this.disposeListeners != null) {
            for (TableCellDisposeListener listener : this.disposeListeners) {
                try {
                    listener.dispose(this);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            this.disposeListeners = null;
        }
        this.tableColumn.invokeCellDisposeListeners(this);
        this.tableColumn.invalidateCells();
    }

    public int getCursorID() {
        return 0;
    }

    public String getObfusticatedText() {
        return this.text;
    }

    public TableRowCore getTableRowCore() {
        return null;
    }

    public boolean getVisuallyChangedSinceRefresh() {
        return true;
    }

    public void invalidate(boolean mustRefresh) {
    }

    public void invokeToolTipListeners(int type) {
        if (this.tableColumn == null) {
            return;
        }
        this.tableColumn.invokeCellToolTipListeners(this, type);
        if (this.tooltipListeners == null) {
            return;
        }
        try {
            if (type == 0) {
                for (int i = 0; i < this.tooltipListeners.size(); ++i) {
                    ((TableCellToolTipListener)this.tooltipListeners.get(i)).cellHover(this);
                }
            } else {
                for (int i = 0; i < this.tooltipListeners.size(); ++i) {
                    ((TableCellToolTipListener)this.tooltipListeners.get(i)).cellHoverComplete(this);
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    public void invokeVisibilityListeners(int visibility, boolean invokeColumnListeners) {
        if (invokeColumnListeners) {
            this.tableColumn.invokeCellVisibilityListeners(this, visibility);
        }
        if (this.cellVisibilityListeners == null) {
            return;
        }
        for (int i = 0; i < this.cellVisibilityListeners.size(); ++i) {
            try {
                TableCellVisibilityListener l = (TableCellVisibilityListener)this.cellVisibilityListeners.get(i);
                l.cellVisibilityChanged(this, visibility);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public boolean isMouseOver() {
        if (this.isDisposed()) {
            return false;
        }
        Rectangle r = this.composite.getBounds();
        if (this.cellArea != null) {
            r = new Rectangle(r.x + this.cellArea.x, r.y + this.cellArea.y, this.cellArea.width, this.cellArea.height);
        }
        Point ptStart = this.composite.toDisplay(r.x, r.y);
        r.x = ptStart.x;
        r.y = ptStart.y;
        Point ptCursor = this.composite.getDisplay().getCursorLocation();
        return r.contains(ptCursor);
    }

    public boolean isUpToDate() {
        return false;
    }

    public void locationChanged() {
    }

    public boolean needsPainting() {
        return true;
    }

    public boolean refresh(boolean doGraphics) {
        return this.refresh();
    }

    public boolean refresh(boolean doGraphics, boolean rowVisible, boolean cellVisible) {
        return this.refresh();
    }

    public boolean refresh(boolean doGraphics, boolean rowVisible) {
        return this.refresh();
    }

    public void setCursorID(int cursorID) {
    }

    public void setUpToDate(boolean upToDate) {
    }

    public int compareTo(Object arg0) {
        return 0;
    }

    public void setOrentation(int o) {
        this.orientation = o;
    }

    public Rectangle getCellArea() {
        return this.cellArea;
    }

    public void setCellArea(Rectangle cellArea) {
        this.cellArea = cellArea;
    }

    public int[] getMouseOffset() {
        if (this.isDisposed()) {
            return null;
        }
        Rectangle r = this.composite.getBounds();
        if (this.cellArea != null) {
            r = new Rectangle(r.x + this.cellArea.x, r.y + this.cellArea.y, this.cellArea.width, this.cellArea.height);
        }
        Point ptStart = this.composite.toDisplay(r.x, r.y);
        r.x = ptStart.x;
        r.y = ptStart.y;
        Point ptCursor = this.composite.getDisplay().getCursorLocation();
        if (!r.contains(ptCursor)) {
            return null;
        }
        return new int[]{ptCursor.x - r.x, ptCursor.y - r.y};
    }

    public int getMarginHeight() {
        return this.marginHeight;
    }

    public int getMarginWidth() {
        return this.marginWidth;
    }

    public void refreshAsync() {
        this.refresh();
    }

    public void redraw() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (!FakeTableCell.this.isDisposed()) {
                    FakeTableCell.this.composite.redraw();
                }
            }
        });
    }

    public void doPaint(GC gc) {
        this.doPaint(gc, this.cellArea == null ? this.composite.getClientArea() : this.cellArea);
    }

    public Image getBackgroundImage() {
        return null;
    }

    public Color getBackgroundSWT() {
        return null;
    }

    public Rectangle getBounds() {
        return this.cellArea == null ? this.composite.getClientArea() : this.cellArea;
    }

    public BufferedTableItem getBufferedTableItem() {
        return null;
    }

    public Color getForegroundSWT() {
        return null;
    }

    public Image getGraphicSWT() {
        return null;
    }

    public Image getIcon() {
        return null;
    }

    public Point getSize() {
        Rectangle bounds = this.getBounds();
        if (bounds == null) {
            return null;
        }
        return new Point(bounds.width, bounds.height);
    }

    public TableRowSWT getTableRowSWT() {
        return null;
    }

    public int getTextAlpha() {
        return 0;
    }

    public boolean setForeground(Color color) {
        return false;
    }

    public boolean setGraphic(Image img) {
        this.graphic = null;
        this.image = img;
        if (this.image != null) {
            this.imageBounds = this.image.getBounds();
        }
        if (this.composite != null && !this.composite.isDisposed()) {
            this.redraw();
        }
        return true;
    }

    public boolean setIcon(Image img) {
        return false;
    }

    public void setTextAlpha(int textOpacity) {
    }
}

