/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.impl;

import com.aelitis.azureus.ui.common.table.TableCellCore;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Table;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableRowMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableRowMouseListener;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedTableRow;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableRowSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableCellImpl;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWTImpl;

public class TableRowImpl
extends BufferedTableRow
implements TableRowSWT {
    private Map mTableCells;
    private String sTableID;
    private Object coreDataSource;
    private Object pluginDataSource;
    private boolean bDisposed;
    private boolean bSetNotUpToDateLastRefresh = false;
    private TableView tableView;
    private static AEMonitor this_mon = new AEMonitor("TableRowImpl");
    private ArrayList mouseListeners;
    private boolean wasShown = false;
    private Map dataList;
    private int lastIndex = -1;
    private int fontStyle;
    private int alpha = 255;
    private static final boolean DEBUG_SET_FOREGROUND = System.getProperty("debug.setforeground") != null;

    public TableRowImpl(TableView tv, Table table, String sTableID, TableColumnCore[] columnsSorted, Object dataSource, boolean bSkipFirstColumn) {
        super(table);
        this.tableView = tv;
        this.sTableID = sTableID;
        this.coreDataSource = dataSource;
        this.mTableCells = new LightHashMap();
        this.bDisposed = false;
        for (int i = 0; i < columnsSorted.length; ++i) {
            if (columnsSorted[i] == null) continue;
            TableCellImpl cell = new TableCellImpl(this, columnsSorted[i], bSkipFirstColumn ? i + 1 : i);
            this.mTableCells.put(columnsSorted[i].getName(), cell);
        }
    }

    public boolean isValid() {
        if (this.bDisposed) {
            return true;
        }
        boolean valid = true;
        for (TableCellSWT cell : this.mTableCells.values()) {
            if (cell == null) continue;
            valid &= cell.isValid();
        }
        return valid;
    }

    public Object getDataSource() {
        return this.getDataSource(false);
    }

    public String getTableID() {
        return this.sTableID;
    }

    public TableCell getTableCell(String field) {
        if (this.bDisposed) {
            return null;
        }
        return (TableCell)this.mTableCells.get(field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMouseListener(TableRowMouseListener listener) {
        try {
            this_mon.enter();
            if (this.mouseListeners == null) {
                this.mouseListeners = new ArrayList(1);
            }
            this.mouseListeners.add(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMouseListener(TableRowMouseListener listener) {
        try {
            this_mon.enter();
            if (this.mouseListeners == null) {
                return;
            }
            this.mouseListeners.remove(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    public void invokeMouseListeners(TableRowMouseEvent event2) {
        ArrayList listeners = this.mouseListeners;
        if (listeners == null) {
            return;
        }
        for (int i = 0; i < listeners.size(); ++i) {
            try {
                TableRowMouseListener l = (TableRowMouseListener)listeners.get(i);
                l.rowMouseTrigger(event2);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        this_mon.enter();
        try {
            if (this.bDisposed) {
                return;
            }
            if (TableViewSWT.DEBUGADDREMOVE) {
                System.out.println((this.table.isDisposed() ? "" : this.table.getData("Name")) + " row delete; index=" + this.getIndex());
            }
            for (TableCellSWT item : this.mTableCells.values()) {
                item.dispose();
            }
            this.setForeground((Color)null);
            this.bDisposed = true;
        }
        finally {
            this_mon.exit();
        }
    }

    public List refresh(boolean bDoGraphics) {
        if (this.bDisposed) {
            return Collections.EMPTY_LIST;
        }
        boolean bVisible = this.isVisible();
        return this.refresh(bDoGraphics, bVisible);
    }

    public List refresh(boolean bDoGraphics, boolean bVisible) {
        ArrayList<TableCellSWT> list = Collections.EMPTY_LIST;
        if (this.bDisposed) {
            return list;
        }
        if (!bVisible) {
            if (!this.bSetNotUpToDateLastRefresh) {
                this.setUpToDate(false);
                this.bSetNotUpToDateLastRefresh = true;
            }
            return list;
        }
        this.bSetNotUpToDateLastRefresh = false;
        ((TableViewSWTImpl)this.tableView).invokeRefreshListeners(this);
        for (TableCellSWT item : this.mTableCells.values()) {
            boolean changed;
            TableColumn column = item.getTableColumn();
            if (column != this.tableView.getSortColumn() && !this.tableView.isColumnVisible(column) || !(changed = item.refresh(bDoGraphics, bVisible))) continue;
            if (list == Collections.EMPTY_LIST) {
                list = new ArrayList<TableCellSWT>(this.mTableCells.size());
            }
            list.add(item);
        }
        return list;
    }

    public void setAlternatingBGColor(boolean bEvenIfNotVisible) {
        super.setAlternatingBGColor(bEvenIfNotVisible);
    }

    public void locationChanged(int iStartColumn) {
        if (this.bDisposed || !this.isVisible()) {
            return;
        }
        for (TableCellSWT item : this.mTableCells.values()) {
            if (item.getTableColumn().getPosition() <= iStartColumn) continue;
            item.locationChanged();
        }
    }

    public void doPaint(GC gc) {
        this.doPaint(gc, this.isVisible());
    }

    public void doPaint(GC gc, boolean bVisible) {
        if (this.bDisposed || !bVisible) {
            return;
        }
        for (TableCellSWT cell : this.mTableCells.values()) {
            if (cell == null || !cell.needsPainting()) continue;
            cell.doPaint(gc);
        }
    }

    public TableCellCore getTableCellCore(String field) {
        if (this.bDisposed) {
            return null;
        }
        return (TableCellCore)this.mTableCells.get(field);
    }

    public TableCellSWT getTableCellSWT(String name) {
        if (this.bDisposed) {
            return null;
        }
        return (TableCellSWT)this.mTableCells.get(name);
    }

    public Object getDataSource(boolean bCoreObject) {
        if (this.bDisposed) {
            return null;
        }
        if (bCoreObject) {
            return this.coreDataSource;
        }
        if (this.pluginDataSource != null) {
            return this.pluginDataSource;
        }
        this.pluginDataSource = PluginCoreUtils.convert(this.coreDataSource, bCoreObject);
        return this.pluginDataSource;
    }

    public boolean isRowDisposed() {
        return this.bDisposed;
    }

    public int getIndex() {
        TableRowCore row;
        if (this.bDisposed) {
            return -1;
        }
        if (this.lastIndex >= 0 && (row = ((TableViewSWTImpl)this.tableView).getRowQuick(this.lastIndex)) == this) {
            return this.lastIndex;
        }
        this.lastIndex = ((TableViewSWTImpl)this.tableView).indexOf(this);
        return this.lastIndex;
    }

    public int getRealIndex() {
        return super.getIndex();
    }

    public boolean setTableItem(int newIndex, boolean isVisible) {
        if (this.bDisposed) {
            System.out.println("XXX setTI: bDisposed from " + Debug.getCompressedStackTrace());
            return false;
        }
        boolean changed = super.setTableItem(newIndex, false, isVisible);
        if (this.lastIndex != newIndex) {
            this.lastIndex = newIndex;
        }
        this.setShown(this.tableView.isRowVisible(this), changed);
        return changed;
    }

    public boolean setTableItem(int newIndex) {
        return this.setTableItem(newIndex, true);
    }

    private static void setForegroundDebug(String method_sig, Color c) {
        if (DEBUG_SET_FOREGROUND && c != null) {
            Debug.out("BufferedTableRow " + method_sig + " -> " + c);
        }
    }

    private static void setForegroundDebug(String method_sig, int r, int g, int b) {
        if (DEBUG_SET_FOREGROUND && (r != 0 || g != 0 || b != 0)) {
            Debug.out("BufferedTableRow " + method_sig + " -> " + r + "," + g + "," + b);
        }
    }

    public void setForeground(int r, int g, int b) {
        TableRowImpl.setForegroundDebug("setForeground(r, g, b)", r, g, b);
        if (!this.isVisible()) {
            return;
        }
        super.setForeground(r, g, b);
    }

    public void setForeground(final Color c) {
        TableRowImpl.setForegroundDebug("setForeground(Color)", c);
        if (!this.isVisible()) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                TableRowImpl.this.setForegroundInSWTThread(c);
            }
        });
    }

    private void setForegroundInSWTThread(Color c) {
        TableRowImpl.setForegroundDebug("setForegroundInSWTThread(Color)", c);
        if (!this.isVisible()) {
            return;
        }
        super.setForeground(c);
    }

    public void setForeground(int[] rgb) {
        if (rgb == null || rgb.length < 3) {
            this.setForeground((Color)null);
            return;
        }
        this.setForeground(rgb[0], rgb[1], rgb[2]);
    }

    public void setForegroundToErrorColor() {
        this.setForeground(Colors.colorError);
    }

    public void invalidate() {
        super.invalidate();
        if (this.bDisposed) {
            return;
        }
        for (TableCellSWT cell : this.mTableCells.values()) {
            if (cell == null) continue;
            cell.invalidate(true);
        }
    }

    public void setUpToDate(boolean upToDate) {
        if (this.bDisposed) {
            return;
        }
        for (TableCellSWT cell : this.mTableCells.values()) {
            if (cell == null) continue;
            cell.setUpToDate(upToDate);
        }
    }

    public void redraw() {
        Rectangle bounds = this.getBounds();
        this.table.redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
    }

    public String toString() {
        String result = "TableRowImpl@" + Integer.toHexString(this.hashCode()) + "/#" + this.lastIndex;
        return result;
    }

    public TableView getView() {
        return this.tableView;
    }

    public void setShown(boolean b, boolean force) {
        if (this.bDisposed) {
            return;
        }
        if (b == this.wasShown && !force) {
            return;
        }
        this.wasShown = b;
        for (TableCellSWT cell : this.mTableCells.values()) {
            if (cell == null) continue;
            cell.invokeVisibilityListeners(b ? 0 : 1, true);
        }
    }

    public boolean isMouseOver() {
        return this.tableView.getTableRowWithCursor() == this;
    }

    public void setData(String id, Object data) {
        if (this.dataList == null) {
            this.dataList = new HashMap(1);
        }
        if (data == null) {
            this.dataList.remove("id");
        } else {
            this.dataList.put(id, data);
        }
    }

    public Object getData(String id) {
        return this.dataList == null ? null : this.dataList.get(id);
    }

    public boolean setDrawableHeight(int height) {
        return this.setHeight(height);
    }

    public Rectangle getBounds() {
        Rectangle bounds = this.getBounds(1);
        if (bounds == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        bounds.x = 0;
        bounds.width = this.table.getSize().x;
        return bounds;
    }

    public boolean setFontStyle(int style) {
        if (this.fontStyle == style) {
            return false;
        }
        this.fontStyle = style;
        this.invalidate();
        return true;
    }

    public boolean setAlpha(int alpha) {
        if (this.alpha == alpha) {
            return false;
        }
        this.alpha = alpha;
        this.invalidate();
        return true;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }
}

