/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnDateSizer
extends CoreTableColumn
implements TableCellRefreshListener {
    private static int PADDING = 10;
    int curFormat = 0;
    int[] maxWidthUsed = new int[TimeFormatter.DATEFORMATS_DESC.length];
    Date[] maxWidthDate = new Date[TimeFormatter.DATEFORMATS_DESC.length];
    private boolean showTime = true;
    private boolean multiline = true;
    private static Font fontBold;

    public ColumnDateSizer(String columnID, int width, String tableID) {
        super(columnID, width, tableID);
        this.setAlignment(2);
        Boolean bShowTime = (Boolean)this.getUserData("showTime");
        this.showTime = bShowTime != null ? bShowTime : COConfigurationManager.getBooleanParameter("v3.Start Advanced");
        TableContextMenuItem menuShowTime = this.addContextMenuItem("TableColumn.menu.date_added.time");
        menuShowTime.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                ColumnDateSizer.this.showTime = !ColumnDateSizer.this.showTime;
                ColumnDateSizer.this.setUserData("showTime", new Boolean(ColumnDateSizer.this.showTime));
                ColumnDateSizer.this.maxWidthUsed = new int[TimeFormatter.DATEFORMATS_DESC.length];
                ColumnDateSizer.this.maxWidthDate = new Date[TimeFormatter.DATEFORMATS_DESC.length];
                ColumnDateSizer.this.curFormat = -1;
                ColumnDateSizer.this.recalcWidth(new Date());
                if (ColumnDateSizer.this.curFormat < 0) {
                    ColumnDateSizer.this.curFormat = TimeFormatter.DATEFORMATS_DESC.length - 1;
                }
            }
        });
    }

    public final void refresh(TableCell cell) {
        this.refresh(cell, 0L);
    }

    public void refresh(TableCell cell, long timestamp) {
        if (!cell.setSortValue(timestamp) && cell.isValid()) {
            return;
        }
        if (timestamp <= 0L) {
            return;
        }
        Date date = new Date(timestamp);
        if (this.curFormat >= 0) {
            if (this.multiline && cell.getHeight() < 20) {
                this.multiline = false;
            }
            String suffix = this.showTime && !this.multiline ? " hh:mm a" : "";
            int newWidth = this.calcWidth(date, TimeFormatter.DATEFORMATS_DESC[this.curFormat] + suffix);
            if (newWidth > cell.getWidth() - PADDING) {
                if (newWidth > this.maxWidthUsed[this.curFormat]) {
                    this.maxWidthUsed[this.curFormat] = newWidth;
                    this.maxWidthDate[this.curFormat] = date;
                }
                this.recalcWidth(date);
            }
            String s = TimeFormatter.DATEFORMATS_DESC[this.curFormat] + suffix;
            SimpleDateFormat temp = new SimpleDateFormat(s + (this.showTime && this.multiline ? "\nh:mm a" : ""));
            cell.setText(temp.format(date));
        }
    }

    public void setWidth(int width) {
        int oldWidth = this.getWidth();
        super.setWidth(width);
        if (oldWidth == width) {
            return;
        }
        if (this.maxWidthDate != null) {
            if (this.maxWidthDate[this.curFormat] == null) {
                this.maxWidthDate[this.curFormat] = new Date();
            }
            this.recalcWidth(this.maxWidthDate[this.curFormat]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recalcWidth(Date date) {
        int i;
        String suffix = this.showTime && !this.multiline ? " hh:mm a" : "";
        int width = this.getWidth();
        if (this.maxWidthDate == null) {
            this.maxWidthUsed = new int[TimeFormatter.DATEFORMATS_DESC.length];
            this.maxWidthDate = new Date[TimeFormatter.DATEFORMATS_DESC.length];
        }
        int idxFormat = TimeFormatter.DATEFORMATS_DESC.length - 1;
        GC gc = new GC((Drawable)Display.getDefault());
        if (fontBold == null) {
            FontData[] fontData = gc.getFont().getFontData();
            for (i = 0; i < fontData.length; ++i) {
                FontData fd = fontData[i];
                fd.setStyle(1);
            }
            fontBold = new Font(gc.getDevice(), fontData);
        }
        gc.setFont(fontBold);
        try {
            Point minSize = new Point(99999, 0);
            for (i = 0; i < TimeFormatter.DATEFORMATS_DESC.length; ++i) {
                if (this.maxWidthUsed[i] > width - PADDING) continue;
                SimpleDateFormat temp = new SimpleDateFormat(TimeFormatter.DATEFORMATS_DESC[i] + suffix);
                Point newSize = gc.stringExtent(temp.format(date));
                if (newSize.x < width - PADDING) {
                    idxFormat = i;
                    if (this.maxWidthUsed[i] < newSize.x) {
                        this.maxWidthUsed[i] = newSize.x;
                        this.maxWidthDate[i] = date;
                    }
                    break;
                }
                if (newSize.x >= minSize.x) continue;
                minSize = newSize;
                idxFormat = i;
            }
        }
        catch (Throwable t) {
            return;
        }
        finally {
            gc.dispose();
        }
        if (this.curFormat != idxFormat) {
            this.curFormat = idxFormat;
            this.invalidateCells();
        }
    }

    public int calcWidth(Date date, String format) {
        GC gc = new GC((Drawable)Display.getDefault());
        if (fontBold == null) {
            FontData[] fontData = gc.getFont().getFontData();
            for (int i = 0; i < fontData.length; ++i) {
                FontData fd = fontData[i];
                fd.setStyle(1);
            }
            fontBold = new Font(gc.getDevice(), fontData);
        }
        gc.setFont(fontBold);
        SimpleDateFormat temp = new SimpleDateFormat(format);
        Point newSize = gc.stringExtent(temp.format(date));
        gc.dispose();
        return newSize.x;
    }

    public boolean getShowTime() {
        return this.showTime;
    }

    public void setShowTime(boolean showTime) {
        this.showTime = showTime;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }
}

