/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.files;

import com.aelitis.azureus.core.AzureusCoreOperation;
import com.aelitis.azureus.core.AzureusCoreOperationTask;
import java.io.File;
import java.io.IOException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.MessageBox;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellLightRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.debug.ObfusticateCellText;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class NameItem
extends CoreTableColumn
implements TableCellLightRefreshListener,
ObfusticateCellText,
TableCellDisposeListener {
    private static boolean bShowIcon;
    final TableContextMenuItem menuItem;

    public NameItem() {
        super("name", 1, -2, 300, "Files");
        this.setInplaceEdit(true);
        this.setType(1);
        this.menuItem = this.addContextMenuItem("FilesView.name.fastRename");
        this.menuItem.setStyle(2);
        this.menuItem.setData(this.isInplaceEdit());
        this.menuItem.addMultiListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                menu.setData(!NameItem.this.isInplaceEdit());
                NameItem.this.setInplaceEdit(!NameItem.this.isInplaceEdit());
            }
        });
    }

    public void postConfigLoad() {
        this.setInplaceEdit(this.getUserData("noInplaceEdit") == null);
        this.menuItem.setData(this.isInplaceEdit());
    }

    public void preConfigSave() {
        if (this.isInplaceEdit()) {
            this.removeUserData("noInplaceEdit");
        } else {
            this.setUserData("noInplaceEdit", new Integer(1));
        }
    }

    public void refresh(TableCell cell, boolean sortOnlyRefresh) {
        String name;
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        String string = name = fileInfo2 == null ? "" : fileInfo2.getFile(true).getName();
        if (name == null) {
            name = "";
        }
        if ((cell.setText(name) || !cell.isValid()) && bShowIcon && !sortOnlyRefresh) {
            Image icon = fileInfo2 == null ? null : ImageRepository.getPathIcon(fileInfo2.getFile(true).getPath());
            ((TableCellSWT)cell).setIcon(icon);
        }
    }

    public void refresh(TableCell cell) {
        this.refresh(cell, false);
    }

    public String getObfusticatedText(TableCell cell) {
        String name;
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        String string = name = fileInfo2 == null ? "" : Debug.secretFileName(fileInfo2.getFile(true).getName());
        if (name == null) {
            name = "";
        }
        return name;
    }

    public void dispose(TableCell cell) {
    }

    private void disposeCellIcon(TableCell cell) {
        Image img = ((TableCellSWT)cell).getIcon();
        if (img != null) {
            ((TableCellSWT)cell).setIcon(null);
            if (!img.isDisposed()) {
                img.dispose();
            }
        }
    }

    public boolean inplaceValueSet(TableCell cell, String value, boolean finalEdit) {
        File target;
        if (value.equalsIgnoreCase(cell.getText()) || "".equals(value) || "".equals(cell.getText())) {
            return true;
        }
        final DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        try {
            target = new File(fileInfo2.getFile(true).getParentFile(), value).getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        if (!finalEdit) {
            return !target.exists();
        }
        if (target.exists()) {
            return false;
        }
        final boolean[] result = new boolean[]{false};
        boolean paused = fileInfo2.getDownloadManager().pause();
        FileUtil.runAsTask(new AzureusCoreOperationTask(){

            public void run(AzureusCoreOperation operation) {
                result[0] = fileInfo2.setLink(target);
            }
        });
        if (paused) {
            fileInfo2.getDownloadManager().resume();
        }
        if (!result[0]) {
            MessageBox mb = new MessageBox(Utils.findAnyShell(), 33);
            mb.setText(MessageText.getString("FilesView.rename.failed.title"));
            mb.setMessage(MessageText.getString("FilesView.rename.failed.text"));
            mb.open();
        }
        return true;
    }

    static {
        COConfigurationManager.addAndFireParameterListener("NameColumn.showProgramIcon", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                bShowIcon = COConfigurationManager.getBooleanParameter("NameColumn.showProgramIcon");
            }
        });
    }
}

