/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnCreator;
import org.gudy.azureus2.ui.swt.views.tableitems.ColumnDateSizer;

public class DateCompletedItem
extends ColumnDateSizer {
    public static final String COLUMN_ID = "DateCompleted";
    private static final long SHOW_ETA_AFTER_MS = 30000L;

    public DateCompletedItem(String sTableID) {
        super(COLUMN_ID, TableColumnCreator.DATE_COLUMN_WIDTH, sTableID);
        this.setMultiline(false);
    }

    public DateCompletedItem(String tableID, boolean v) {
        this(tableID);
        this.setVisible(v);
    }

    public void refresh(TableCell cell, long timestamp) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        long value = 0L;
        if (dm == null) {
            return;
        }
        if (dm.isDownloadComplete(false)) {
            long completedTime = dm.getDownloadState().getLongParameter("stats.download.completed.time");
            value = completedTime <= 0L ? dm.getDownloadState().getLongParameter("stats.download.added.time") : completedTime;
        } else {
            long diff = SystemTime.getCurrentTime() - dm.getStats().getTimeStarted();
            if (diff > 30000L) {
                long eta = dm.getStats().getETA();
                if (eta > 0L) {
                    String sETA = TimeFormatter.format(eta);
                    value = eta << 42;
                    if (value < 0L) {
                        value = Long.MAX_VALUE;
                    }
                    cell.setText(MessageText.getString("MyTorrents.column.ColumnProgressETA.2ndLine", new String[]{sETA}));
                } else {
                    cell.setText("");
                    value = SystemTime.getCurrentTime() / 1000L * 1001L;
                }
            } else {
                cell.setText("");
                value = SystemTime.getCurrentTime() / 1000L * 1002L;
            }
            cell.invalidate();
            cell.setSortValue(value);
            return;
        }
        super.refresh(cell, value);
    }
}

