/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.StringInterner;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class FilesDoneItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "filesdone";

    public FilesDoneItem(String sTableID) {
        super(COLUMN_ID, 3, -1, 50, sTableID);
        this.setRefreshInterval(5);
        this.setMinWidthAuto(true);
    }

    public void refresh(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        String text = "";
        if (dm != null) {
            int complete = 0;
            int skipped = 0;
            int skipped_complete = 0;
            DiskManagerFileInfo[] files = dm.getDiskManagerFileInfo();
            int total = files.length;
            for (int i = 0; i < files.length; ++i) {
                DiskManagerFileInfo file = files[i];
                if (file.getLength() == file.getDownloaded()) {
                    ++complete;
                    if (!file.isSkipped()) continue;
                    ++skipped;
                    ++skipped_complete;
                    continue;
                }
                if (!file.isSkipped()) continue;
                ++skipped;
            }
            text = skipped == 0 ? StringInterner.intern(complete + "/" + total) : complete - skipped_complete + "(" + complete + ")/" + (total - skipped) + "(" + total + ")";
        }
        cell.setText(text);
    }
}

