/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import com.aelitis.azureus.core.AzureusCoreFactory;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.tracker.host.TRHost;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class HealthItem
extends CoreTableColumn
implements TableCellAddedListener,
TableCellRefreshListener {
    static final int COLUMN_WIDTH = 16;
    public static final String COLUMN_ID = "health";
    static TRHost tracker_host = AzureusCoreFactory.getSingleton().getTrackerHost();

    public HealthItem(String sTableID) {
        super(COLUMN_ID, sTableID);
        this.initializeAsGraphic(-2, 16);
        this.setMinWidth(16);
    }

    public void cellAdded(TableCell cell) {
        cell.setMarginWidth(0);
        cell.setMarginHeight(0);
    }

    public void refresh(TableCell cell) {
        String image_name;
        TRHostTorrent ht;
        int health;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm == null) {
            health = 0;
            ht = null;
        } else {
            health = dm.getHealthStatus();
            ht = tracker_host.getHostTorrent(dm.getTorrent());
        }
        if (!cell.setSortValue(health + (ht == null ? 0 : 256)) && cell.isValid()) {
            return;
        }
        String sHelpID = null;
        if (health == 5) {
            image_name = "st_ko";
            sHelpID = "health.explain.red";
        } else if (health == 4) {
            image_name = "st_ok";
            sHelpID = "health.explain.green";
        } else if (health == 2) {
            image_name = "st_no_tracker";
            sHelpID = "health.explain.blue";
        } else if (health == 3) {
            image_name = "st_no_remote";
            sHelpID = "health.explain.yellow";
        } else if (health == 6) {
            image_name = "st_error";
        } else {
            image_name = "st_stopped";
            sHelpID = "health.explain.grey";
        }
        if (ht != null) {
            image_name = image_name + "_shared";
        }
        boolean graphicWasSet = false;
        graphicWasSet = cell instanceof TableCellSWT ? ((TableCellSWT)cell).setGraphic(ImageRepository.getImage(image_name)) : cell.setGraphic(new UISWTGraphicImpl(ImageRepository.getImage(image_name)));
        if (graphicWasSet) {
            String sToolTip;
            String string = sToolTip = health == 6 ? dm.getErrorDetails() : MessageText.getString(sHelpID);
            if (ht != null) {
                sToolTip = sToolTip + "\n" + MessageText.getString("health.explain.share");
            }
            cell.setToolTip(sToolTip);
        }
    }
}

