/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import com.aelitis.azureus.core.AzureusCoreFactory;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class RankItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "#";
    private boolean bInvalidByTrigger = false;
    private boolean showCompleteIncomplete = false;

    public RankItem(String sTableID) {
        super(COLUMN_ID, 2, -2, 50, sTableID);
        this.setRefreshInterval(-3);
        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
        gm.addListener(new GMListener());
        this.setMaxWidthAuto(true);
        this.setMinWidthAuto(true);
    }

    public RankItem(String sTableID, boolean showCompleteIncomplete) {
        this(sTableID);
        this.showCompleteIncomplete = showCompleteIncomplete;
    }

    public void refresh(TableCell cell) {
        String text;
        long value;
        this.bInvalidByTrigger = false;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        long l = value = dm == null ? 0L : (long)dm.getPosition();
        if (this.showCompleteIncomplete) {
            boolean complete = dm == null ? false : dm.getAssumedComplete();
            text = (complete ? "Done\n#" : "Partial\n#") + value;
            if (complete) {
                value += 65536L;
            }
        } else {
            text = "" + value;
        }
        cell.setSortValue(value);
        cell.setText(text);
    }

    public boolean isShowCompleteIncomplete() {
        return this.showCompleteIncomplete;
    }

    public void setShowCompleteIncomplete(boolean showCompleteIncomplete) {
        this.showCompleteIncomplete = showCompleteIncomplete;
    }

    private class GMListener
    implements GlobalManagerListener {
        DownloadManagerListener listener;

        public GMListener() {
            this.listener = new DownloadManagerListener(){

                public void completionChanged(DownloadManager manager, boolean bCompleted) {
                }

                public void downloadComplete(DownloadManager manager) {
                }

                public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
                    if (RankItem.this.bInvalidByTrigger) {
                        return;
                    }
                    RankItem.this.invalidateCells();
                    RankItem.this.bInvalidByTrigger = true;
                }

                public void stateChanged(DownloadManager manager, int state) {
                }

                public void filePriorityChanged(DownloadManager download, DiskManagerFileInfo file) {
                }
            };
        }

        public void destroyed() {
        }

        public void destroyInitiated() {
            GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
            gm.removeListener(this);
        }

        public void downloadManagerAdded(DownloadManager dm) {
            dm.addListener(this.listener);
        }

        public void downloadManagerRemoved(DownloadManager dm) {
            dm.removeListener(this.listener);
        }

        public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
        }
    }
}

