/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.AbstractTrackerCell;

public class SeedsItem
extends CoreTableColumn
implements TableCellAddedListener,
ParameterListener {
    private static final String CFG_FC_SEEDSTART = "StartStopManager_iFakeFullCopySeedStart";
    private static final String CFG_FC_NUMPEERS = "StartStopManager_iNumPeersAsFullCopy";
    public static final String COLUMN_ID = "seeds";
    private int iFC_MinSeeds;
    private int iFC_NumPeers;

    public SeedsItem(String sTableID) {
        super(COLUMN_ID, 3, -2, 60, sTableID);
        this.setRefreshInterval(-2);
        this.setMinWidthAuto(true);
        this.iFC_MinSeeds = COConfigurationManager.getIntParameter(CFG_FC_SEEDSTART);
        this.iFC_NumPeers = COConfigurationManager.getIntParameter(CFG_FC_NUMPEERS);
        COConfigurationManager.addParameterListener(CFG_FC_SEEDSTART, (ParameterListener)this);
        COConfigurationManager.addParameterListener(CFG_FC_NUMPEERS, (ParameterListener)this);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        COConfigurationManager.removeParameterListener(CFG_FC_SEEDSTART, this);
        COConfigurationManager.removeParameterListener(CFG_FC_NUMPEERS, this);
    }

    public void cellAdded(TableCell cell) {
        new Cell(cell);
    }

    public void parameterChanged(String parameterName) {
        this.iFC_MinSeeds = COConfigurationManager.getIntParameter(CFG_FC_SEEDSTART);
        this.iFC_NumPeers = COConfigurationManager.getIntParameter(CFG_FC_NUMPEERS);
    }

    private class Cell
    extends AbstractTrackerCell {
        private long lTotalPeers;
        private long lTotalSeeds;

        public Cell(TableCell cell) {
            super(cell);
            this.lTotalPeers = 0L;
            this.lTotalSeeds = -1L;
        }

        public void scrapeResult(TRTrackerScraperResponse response) {
            if (this.checkScrapeResult(response)) {
                this.lTotalSeeds = response.getSeeds();
                this.lTotalPeers = response.getPeers();
            }
        }

        public void refresh(TableCell cell) {
            super.refresh(cell);
            long lConnectedSeeds = 0L;
            if (this.dm != null) {
                TRTrackerScraperResponse response;
                lConnectedSeeds = this.dm.getNbSeeds();
                if (this.lTotalSeeds == -1L && (response = this.dm.getTrackerScrapeResponse()) != null && response.isValid()) {
                    this.lTotalSeeds = response.getSeeds();
                    this.lTotalPeers = response.getPeers();
                }
            }
            long value = lConnectedSeeds << 42;
            if (this.lTotalSeeds > 0L) {
                value += this.lTotalSeeds << 21;
            }
            if (this.lTotalPeers > 0L) {
                value += this.lTotalPeers;
            }
            if (!cell.setSortValue(value) && cell.isValid()) {
                return;
            }
            boolean bCompleteTorrent = this.dm == null ? false : this.dm.getAssumedComplete();
            String tmp = String.valueOf(lConnectedSeeds);
            if (this.lTotalSeeds != -1L) {
                long lSeedsToAdd;
                tmp = tmp + " (" + this.lTotalSeeds;
                if (bCompleteTorrent && SeedsItem.this.iFC_NumPeers > 0 && this.lTotalSeeds >= (long)SeedsItem.this.iFC_MinSeeds && this.lTotalPeers > 0L && (lSeedsToAdd = this.lTotalPeers / (long)SeedsItem.this.iFC_NumPeers) > 0L) {
                    tmp = tmp + "+" + lSeedsToAdd;
                }
                tmp = tmp + ")";
            }
            cell.setText(tmp);
        }

        public void cellHover(TableCell cell) {
            boolean bCompleteTorrent;
            super.cellHover(cell);
            long lConnectedSeeds = 0L;
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            if (dm != null) {
                lConnectedSeeds = dm.getNbSeeds();
            }
            String sToolTip = lConnectedSeeds + " " + MessageText.getString("GeneralView.label.connected") + "\n";
            if (this.lTotalSeeds != -1L) {
                sToolTip = sToolTip + this.lTotalSeeds + " " + MessageText.getString("GeneralView.label.in_swarm");
            } else {
                TRTrackerScraperResponse response = dm.getTrackerScrapeResponse();
                sToolTip = sToolTip + "?? " + MessageText.getString("GeneralView.label.in_swarm");
                if (response != null) {
                    sToolTip = sToolTip + "(" + response.getStatusString() + ")";
                }
            }
            boolean bl = bCompleteTorrent = dm == null ? false : dm.getAssumedComplete();
            if (bCompleteTorrent && SeedsItem.this.iFC_NumPeers > 0 && this.lTotalSeeds >= (long)SeedsItem.this.iFC_MinSeeds && this.lTotalPeers > 0L) {
                long lSeedsToAdd = this.lTotalPeers / (long)SeedsItem.this.iFC_NumPeers;
                sToolTip = sToolTip + "\n" + MessageText.getString("MyTorrentsView.seeds.fullcopycalc", new String[]{"" + this.lTotalPeers, "" + lSeedsToAdd});
            }
            cell.setToolTip(sToolTip);
        }
    }
}

