/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.StringInterner;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TrackerCellUtils;

public class TrackerNameItem
extends CoreTableColumn
implements TableCellRefreshListener,
TableCellToolTipListener {
    public static final String COLUMN_ID = "trackername";

    public TrackerNameItem(String sTableID) {
        super(COLUMN_ID, -1, 120, sTableID);
        this.setRefreshInterval(5);
    }

    public void refresh(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        String name = "";
        if (dm != null && dm.getTorrent() != null) {
            String host = dm.getTorrent().getAnnounceURL().getHost();
            String[] parts = host.split("\\.");
            int used = 0;
            for (int i = parts.length - 1; i >= 0 && used <= 4; ++used, --i) {
                String chunk = parts[i];
                if (used >= 2 && chunk.length() >= 11) break;
                name = used == 0 ? chunk : chunk + "." + name;
            }
            name = name.equals(host) ? host : StringInterner.intern(name);
        }
        if (cell.setText(name) || !cell.isValid()) {
            TrackerCellUtils.updateColor(cell, dm);
        }
    }

    public void cellHover(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        cell.setToolTip(TrackerCellUtils.getTooltipText(cell, dm));
    }

    public void cellHoverComplete(TableCell cell) {
        cell.setToolTip(null);
    }
}

