/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytracker;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.debug.ObfusticateCellText;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class NameItem
extends CoreTableColumn
implements TableCellRefreshListener,
ObfusticateCellText,
TableCellDisposeListener {
    private static boolean bShowIcon;

    public NameItem() {
        super("name", -2, 250, "MyTracker");
        this.setType(1);
    }

    public void refresh(TableCell cell) {
        String name;
        TRHostTorrent item = (TRHostTorrent)cell.getDataSource();
        String string = name = item == null ? "" : TorrentUtils.getLocalisedName(item.getTorrent());
        if ((cell.setText(name) || !cell.isValid()) && bShowIcon) {
            TOTorrent torrent;
            boolean folder_icon = false;
            if (item != null && (torrent = item.getTorrent()) != null && !torrent.isSimpleTorrent()) {
                folder_icon = true;
            }
            if (folder_icon) {
                Image icon = ImageRepository.getFolderImage();
                ((TableCellSWT)cell).setIcon(icon);
            } else {
                int sep = name.lastIndexOf(46);
                if (sep < 0) {
                    sep = 0;
                }
                String ext = name.substring(sep);
                Image icon = ImageRepository.getIconFromExtension(ext);
                if (Constants.isWindows && icon != null) {
                    Image dstImage = new Image((Device)Display.getCurrent(), icon.getBounds().width, icon.getBounds().height);
                    GC gc = new GC((Drawable)dstImage);
                    gc.drawImage(icon, 0, 0);
                    gc.dispose();
                    icon = dstImage;
                }
                ((TableCellSWT)cell).setIcon(icon);
            }
        }
    }

    public String getObfusticatedText(TableCell cell) {
        TRHostTorrent item = (TRHostTorrent)cell.getDataSource();
        String name = null;
        try {
            name = ByteFormatter.nicePrint(item.getTorrent().getHash(), true);
        }
        catch (TOTorrentException e) {
            // empty catch block
        }
        if (name == null) {
            name = "";
        }
        return name;
    }

    public void dispose(TableCell cell) {
        if (bShowIcon && Constants.isWindows) {
            Image img = ((TableCellSWT)cell).getIcon();
            Image icon = ImageRepository.getFolderImage();
            if (img != null && !img.equals((Object)icon)) {
                ((TableCellSWT)cell).setIcon(null);
                if (!img.isDisposed()) {
                    img.dispose();
                }
            }
        }
    }

    static {
        COConfigurationManager.addAndFireParameterListener("NameColumn.showProgramIcon", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                bShowIcon = COConfigurationManager.getBooleanParameter("NameColumn.showProgramIcon");
            }
        });
    }
}

