/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class GainItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public GainItem(String table_id) {
        super("gain", 2, -1, 70, table_id);
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        long value;
        PEPeer peer = (PEPeer)cell.getDataSource();
        long l = value = peer == null ? 0L : peer.getStats().getTotalDataBytesReceived() - peer.getStats().getTotalDataBytesSent();
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        cell.setText((value >= 0L ? "" : "-") + DisplayFormatters.formatByteCountToKiBEtc(Math.abs(value)));
    }
}

