/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.systray;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.common.updater.UIUpdatableAlways;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.util.List;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.ui.common.util.MenuItemManager;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.SelectableSpeedMenu;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class SystemTraySWT
implements UIUpdatableAlways {
    Display display;
    UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
    Tray tray;
    TrayItem trayItem;
    Menu menu;

    public SystemTraySWT() {
        this.display = SWTThread.getInstance().getDisplay();
        this.tray = this.display.getSystemTray();
        this.trayItem = new TrayItem(this.tray, 0);
        if (!Constants.isOSX) {
            this.trayItem.setImage(ImageRepository.getImage("azureus"));
        } else {
            this.trayItem.setImage(ImageRepository.getImage("azureus_grey"));
        }
        this.trayItem.setVisible(true);
        this.menu = new Menu((Decorations)this.uiFunctions.getMainShell(), 8);
        this.menu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent _menu) {
            }

            public void menuHidden(MenuEvent _menu) {
                if (Constants.isOSX) {
                    SystemTraySWT.this.trayItem.setImage(ImageRepository.getImage("azureus_grey"));
                }
            }
        });
        MenuBuildUtils.addMaintenanceListenerForMenu(this.menu, new MenuBuildUtils.MenuBuilder(){

            public void buildMenu(Menu menu) {
                SystemTraySWT.this.fillMenu(menu);
            }
        });
        this.trayItem.addListener(14, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.showMainWindow();
            }
        });
        this.trayItem.addListener(13, new Listener(){
            long lastTime = 0L;

            public void handleEvent(Event arg0) {
                if (Constants.isWindows) {
                    long now = SystemTime.getCurrentTime();
                    if (now - this.lastTime < 200L) {
                        SystemTraySWT.this.showMainWindow();
                    } else {
                        this.lastTime = now;
                    }
                } else if (Constants.isOSX) {
                    SystemTraySWT.this.trayItem.setImage(ImageRepository.getImage("azureus_white"));
                    SystemTraySWT.this.menu.setVisible(true);
                }
            }
        });
        this.trayItem.addListener(35, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.menu.setVisible(true);
            }
        });
        this.uiFunctions.getUIUpdater().addUpdater(this);
    }

    public void fillMenu(Menu menu) {
        org.eclipse.swt.widgets.MenuItem itemShow = new org.eclipse.swt.widgets.MenuItem(menu, 0);
        Messages.setLanguageText((Widget)itemShow, "SystemTray.menu.show");
        new org.eclipse.swt.widgets.MenuItem(menu, 2);
        org.eclipse.swt.widgets.MenuItem itemCloseAll = new org.eclipse.swt.widgets.MenuItem(menu, 0);
        Messages.setLanguageText((Widget)itemCloseAll, "SystemTray.menu.closealldownloadbars");
        org.eclipse.swt.widgets.MenuItem itemShowGlobalTransferBar = new org.eclipse.swt.widgets.MenuItem(menu, 32);
        Messages.setLanguageText((Widget)itemShowGlobalTransferBar, "SystemTray.menu.open_global_transfer_bar");
        new org.eclipse.swt.widgets.MenuItem(menu, 2);
        MenuItem[] menu_items = MenuItemManager.getInstance().getAllAsArray("systray");
        if (menu_items.length > 0) {
            MenuBuildUtils.addPluginMenuItems((Composite)this.uiFunctions.getMainShell(), menu_items, menu, true, true, MenuBuildUtils.BASIC_MENU_ITEM_CONTROLLER);
            new org.eclipse.swt.widgets.MenuItem(menu, 2);
        }
        this.createUploadLimitMenu(menu);
        this.createDownloadLimitMenu(menu);
        new org.eclipse.swt.widgets.MenuItem(menu, 2);
        org.eclipse.swt.widgets.MenuItem itemStartAll = new org.eclipse.swt.widgets.MenuItem(menu, 0);
        Messages.setLanguageText((Widget)itemStartAll, "SystemTray.menu.startalltransfers");
        org.eclipse.swt.widgets.MenuItem itemStopAll = new org.eclipse.swt.widgets.MenuItem(menu, 0);
        Messages.setLanguageText((Widget)itemStopAll, "SystemTray.menu.stopalltransfers");
        org.eclipse.swt.widgets.MenuItem itemPause = new org.eclipse.swt.widgets.MenuItem(menu, 0);
        Messages.setLanguageText((Widget)itemPause, "SystemTray.menu.pausetransfers");
        org.eclipse.swt.widgets.MenuItem itemResume = new org.eclipse.swt.widgets.MenuItem(menu, 0);
        Messages.setLanguageText((Widget)itemResume, "SystemTray.menu.resumetransfers");
        new org.eclipse.swt.widgets.MenuItem(menu, 2);
        org.eclipse.swt.widgets.MenuItem itemExit = new org.eclipse.swt.widgets.MenuItem(menu, 0);
        Messages.setLanguageText((Widget)itemExit, "SystemTray.menu.exit");
        itemShow.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.showMainWindow();
            }
        });
        itemStartAll.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                AzureusCoreFactory.getSingleton().getGlobalManager().startAllDownloads();
            }
        });
        itemStopAll.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                ManagerUtils.asyncStopAll();
            }
        });
        itemPause.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                ManagerUtils.asyncPause();
            }
        });
        itemResume.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                AzureusCoreFactory.getSingleton().getGlobalManager().resumeDownloads();
            }
        });
        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
        itemPause.setEnabled(gm.canPauseDownloads());
        itemResume.setEnabled(gm.canResumeDownloads());
        itemCloseAll.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.uiFunctions.closeDownloadBars();
            }
        });
        itemShowGlobalTransferBar.setSelection(this.uiFunctions.isGlobalTransferBarShown());
        itemShowGlobalTransferBar.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (SystemTraySWT.this.uiFunctions.isGlobalTransferBarShown()) {
                    SystemTraySWT.this.uiFunctions.closeGlobalTransferBar();
                } else {
                    SystemTraySWT.this.uiFunctions.showGlobalTransferBar();
                }
            }
        });
        itemExit.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.uiFunctions.dispose(false, false);
            }
        });
    }

    private final void createUploadLimitMenu(Menu parent) {
        org.eclipse.swt.widgets.MenuItem uploadSpeedItem = new org.eclipse.swt.widgets.MenuItem(parent, 64);
        uploadSpeedItem.setText(MessageText.getString("GeneralView.label.maxuploadspeed"));
        final Menu uploadSpeedMenu = new Menu((Decorations)this.uiFunctions.getMainShell(), 4);
        uploadSpeedMenu.addListener(22, new Listener(){

            public void handleEvent(Event event2) {
                AzureusCore core = AzureusCoreFactory.getSingleton();
                SelectableSpeedMenu.generateMenuItems(uploadSpeedMenu, core, core.getGlobalManager(), true);
            }
        });
        uploadSpeedItem.setMenu(uploadSpeedMenu);
    }

    private final void createDownloadLimitMenu(Menu parent) {
        org.eclipse.swt.widgets.MenuItem downloadSpeedItem = new org.eclipse.swt.widgets.MenuItem(parent, 64);
        downloadSpeedItem.setText(MessageText.getString("GeneralView.label.maxdownloadspeed"));
        final Menu downloadSpeedMenu = new Menu((Decorations)this.uiFunctions.getMainShell(), 4);
        downloadSpeedMenu.addListener(22, new Listener(){

            public void handleEvent(Event event2) {
                AzureusCore core = AzureusCoreFactory.getSingleton();
                SelectableSpeedMenu.generateMenuItems(downloadSpeedMenu, core, core.getGlobalManager(), false);
            }
        });
        downloadSpeedItem.setMenu(downloadSpeedMenu);
    }

    public void dispose() {
        this.uiFunctions.getUIUpdater().removeUpdater(this);
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (SystemTraySWT.this.trayItem != null && !SystemTraySWT.this.trayItem.isDisposed()) {
                    SystemTraySWT.this.trayItem.dispose();
                }
            }
        });
    }

    public void updateUI() {
        if (this.trayItem.isDisposed()) {
            this.uiFunctions.getUIUpdater().removeUpdater(this);
            return;
        }
        List managers = AzureusCoreFactory.getSingleton().getGlobalManager().getDownloadManagers();
        StringBuffer toolTip = new StringBuffer();
        int seeding = 0;
        int downloading = 0;
        for (int i = 0; i < managers.size(); ++i) {
            DownloadManager manager = (DownloadManager)managers.get(i);
            int state = manager.getState();
            if (state == 50) {
                ++downloading;
            }
            if (state != 60) continue;
            ++seeding;
        }
        String seeding_text = MessageText.getString("SystemTray.tooltip.seeding").replaceAll("%1", "" + seeding);
        String downloading_text = MessageText.getString("SystemTray.tooltip.downloading").replaceAll("%1", "" + downloading);
        if (!downloading_text.startsWith(" ")) {
            downloading_text = " " + downloading_text;
        }
        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
        GlobalManagerStats stats = gm.getStats();
        toolTip.append(seeding_text).append(downloading_text).append("\n");
        toolTip.append(MessageText.getString("ConfigView.download.abbreviated")).append(" ");
        toolTip.append(DisplayFormatters.formatDataProtByteCountToKiBEtcPerSec(stats.getDataReceiveRate(), stats.getProtocolReceiveRate()));
        toolTip.append(", ").append(MessageText.getString("ConfigView.upload.abbreviated")).append(" ");
        toolTip.append(DisplayFormatters.formatDataProtByteCountToKiBEtcPerSec(stats.getDataSendRate(), stats.getProtocolSendRate()));
        this.trayItem.setToolTipText(toolTip.toString());
        this.trayItem.setVisible(true);
    }

    private void showMainWindow() {
        this.uiFunctions.bringToFront(false);
    }

    public void updateLanguage() {
        if (this.menu != null) {
            Messages.updateLanguageForControl((Widget)this.menu);
        }
        this.updateUI();
    }

    public String getUpdateUIName() {
        return "SystemTraySWT";
    }
}

