/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.lucene;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.wltea.analyzer.lucene.IKTokenizer;

public final class IKAnalyzer
extends Analyzer {
    private boolean useSmart;

    public boolean useSmart() {
        return this.useSmart;
    }

    public void setUseSmart(boolean useSmart) {
        this.useSmart = useSmart;
    }

    public IKAnalyzer() {
        this(false);
    }

    public IKAnalyzer(boolean useSmart) {
        this.useSmart = useSmart;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        return new IKTokenizer(reader, this.useSmart());
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        Tokenizer _IKTokenizer = (Tokenizer)this.getPreviousTokenStream();
        if (_IKTokenizer == null) {
            _IKTokenizer = new IKTokenizer(reader, this.useSmart());
            this.setPreviousTokenStream(_IKTokenizer);
        } else {
            _IKTokenizer.reset(reader);
        }
        return _IKTokenizer;
    }
}

