/*
 * Decompiled with CFR 0.152.
 */
package yuxingwang.common;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class CommonUtil {
    private static CommonUtil commonUtil = null;

    public static CommonUtil getInstance() {
        if (commonUtil == null) {
            commonUtil = new CommonUtil();
        }
        return commonUtil;
    }

    public String encodedStr(String str, String bytesType, String returnType) {
        String encodedStr = str;
        if (str == null) {
            return null;
        }
        try {
            encodedStr = new String(encodedStr.getBytes(bytesType), returnType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encodedStr;
    }

    public String getThisYear() {
        int ys = Integer.parseInt(this.getDate().substring(0, 4)) - 1911;
        return String.valueOf(ys);
    }

    public String getThisMonth() {
        int ms = Integer.parseInt(this.getDate().substring(5, 7));
        return String.valueOf(ms);
    }

    public String getThisDay() {
        int ds = Integer.parseInt(this.getDate().substring(8));
        return String.valueOf(ds);
    }

    public String getDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
        Calendar calendar = Calendar.getInstance();
        return simpleDateFormat.format(calendar.getTime());
    }

    public String getDateSn() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        Calendar calendar = Calendar.getInstance();
        return simpleDateFormat.format(calendar.getTime());
    }

    public String getNow() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        Calendar calendar = Calendar.getInstance();
        return simpleDateFormat.format(calendar.getTime());
    }

    public String parseToDateTime(String dateString) {
        if (dateString == null) {
            return null;
        }
        dateString = dateString.replace('-', '/');
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        try {
            Date date = simpleDateFormat.parse(dateString);
            return simpleDateFormat.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String parseToDateTime(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        try {
            return simpleDateFormat.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String parseToDateData(String dateString) {
        if (dateString == null) {
            return null;
        }
        dateString = dateString.replace('-', '/');
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
        try {
            String dateStringRtn = "";
            Date date = simpleDateFormat.parse(dateString);
            dateStringRtn = simpleDateFormat.format(date);
            dateStringRtn = String.valueOf(dateStringRtn.substring(5)) + "/" + dateStringRtn.substring(0, 4);
            return dateStringRtn;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getWeek(String dateStr) {
        if (dateStr == null) {
            return null;
        }
        int yearInt = Integer.parseInt(dateStr.substring(0, 4));
        int monthInt = Integer.parseInt(dateStr.substring(5, 7)) - 1;
        int dayInt = Integer.parseInt(dateStr.substring(8));
        Calendar calendar = Calendar.getInstance();
        calendar.set(yearInt, monthInt, dayInt);
        int dayOfWeek = calendar.get(7);
        String weekCh = "";
        switch (dayOfWeek) {
            case 1: {
                weekCh = "\u65e5";
                break;
            }
            case 2: {
                weekCh = "\u4e00";
                break;
            }
            case 3: {
                weekCh = "\u4e8c";
                break;
            }
            case 4: {
                weekCh = "\u4e09";
                break;
            }
            case 5: {
                weekCh = "\u56db";
                break;
            }
            case 6: {
                weekCh = "\u4e94";
                break;
            }
            case 7: {
                weekCh = "\u516d";
            }
        }
        return "\u661f\u671f" + weekCh;
    }
}

