/*
 * Decompiled with CFR 0.152.
 */
package yuxingwang.common.image;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import com.sun.imageio.plugins.png.PNGImageWriter;
import com.sun.imageio.plugins.png.PNGImageWriterSpi;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.JComponent;
import yuxingwang.common.debug.DebugConsole;

public class SwingComponentImageGenerator {
    private static SwingComponentImageGenerator instance = new SwingComponentImageGenerator();

    private SwingComponentImageGenerator() {
    }

    public static SwingComponentImageGenerator getInstance() {
        return instance;
    }

    public void generateJPEGImage(JComponent component, String filePath) throws IOException {
        Rectangle bounds = component.getBounds();
        this.generateJPEGImage(new Dimension(bounds.width, bounds.height), new JComponent[]{component}, new Rectangle[]{bounds}, filePath);
    }

    public void generateJPEGImage(Dimension size, JComponent[] components, Rectangle[] areas, String filePath) throws IOException {
        DebugConsole.paintebug("Generate JPEG image file");
        if (components.length == 0 || components.length != areas.length) {
            throw new RuntimeException("The specified components is not fulfil the requirement");
        }
        if (filePath == null) {
            String dir = String.valueOf(System.getProperty("user.dir")) + System.getProperty("file.separator") + "image";
            filePath = String.valueOf(dir) + System.getProperty("file.separator") + "ganttchart.jpg";
        }
        SwingComponentImageGenerator.checkAndCreateDirForFilePath(filePath);
        BufferedImage image = new BufferedImage(size.width, size.height, 1);
        Graphics imageGraphic = image.getGraphics();
        imageGraphic.setColor(Color.WHITE);
        imageGraphic.fillRect(0, 0, size.width, size.height);
        int i = 0;
        while (i < components.length) {
            JComponent curCom = components[i];
            Rectangle bounds = areas[i];
            System.out.println("Start to paint component " + curCom.getClass().getName() + " to image:" + bounds);
            curCom.paint(imageGraphic);
            if (bounds.x > 0 || bounds.y > 0) {
                imageGraphic.copyArea(0, 0, bounds.width, bounds.height, bounds.x, bounds.y);
            }
            ++i;
        }
        try {
            File imgFile = new File(filePath);
            FileOutputStream fos = new FileOutputStream(imgFile);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)bos);
            encoder.encode(image);
            bos.close();
            System.out.println("Image:" + filePath + " generated");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException(String.valueOf(ex.getMessage()) + ex.getStackTrace());
        }
    }

    public void generatePNGImage(JComponent component, String filePath) throws IOException {
        Rectangle bounds = component.getBounds();
        this.generatePNGImage(new Dimension(bounds.width, bounds.height), new JComponent[]{component}, new Rectangle[]{bounds}, filePath);
    }

    public void generatePNGImage(Dimension size, JComponent[] components, Rectangle[] areas, String filePath) throws IOException {
        DebugConsole.paintebug("Generate JPEG image file");
        if (components.length != areas.length) {
            throw new RuntimeException("The specified components is not fulfil the requirement");
        }
        if (filePath == null) {
            String dir = String.valueOf(System.getProperty("user.dir")) + System.getProperty("file.separator") + "image";
            filePath = String.valueOf(dir) + System.getProperty("file.separator") + "ganttchart.jpg";
        }
        SwingComponentImageGenerator.checkAndCreateDirForFilePath(filePath);
        BufferedImage image = new BufferedImage(size.width, size.height, 1);
        Graphics imageGraphic = image.getGraphics();
        imageGraphic.setColor(Color.WHITE);
        imageGraphic.fillRect(0, 0, size.width, size.height);
        int i = 0;
        while (i < components.length) {
            JComponent curCom = components[i];
            Rectangle bounds = areas[i];
            System.out.println("Start to paint component " + curCom.getClass().getName() + " to image:" + bounds);
            curCom.paint(imageGraphic);
            if (bounds.x > 0 || bounds.y > 0) {
                imageGraphic.copyArea(0, 0, bounds.width, bounds.height, bounds.x, bounds.y);
            }
            ++i;
        }
        try {
            File imgFile = new File(filePath);
            FileImageOutputStream ios = new FileImageOutputStream(imgFile);
            PNGImageWriterSpi iwspi = new PNGImageWriterSpi();
            PNGImageWriter pngImageWriter = new PNGImageWriter(iwspi);
            pngImageWriter.setOutput(ios);
            pngImageWriter.write(image);
            System.out.println("Image:" + filePath + " generated");
            ios.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException(String.valueOf(ex.getMessage()) + ex.getStackTrace());
        }
    }

    public static void checkAndCreateDirForFilePath(String filePath) {
        File file = new File(filePath);
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    public static void main(String[] args) {
        SwingComponentImageGenerator.checkAndCreateDirForFilePath("e:\\temp\\image\\hello.txt");
    }
}

