/*
 * Decompiled with CFR 0.152.
 */
package yuxingwang.common.time;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class TimeFormatter {
    public static final String TIME_FORMAT_HH_MM_SS = "HH:mm:ss";
    public static final String TIME_FORMAT_WHOLE_SLASH = "yyyy/MM/dd HH:mm:ss";
    public static final String TIME_FORMAT_YYYY_MM_SLASH = "yyyy/MM";
    public static final String TIME_FORMAT_YYYY_MM_DD_SLASH = "yyyy/MM/dd";
    public static final String TIME_FORMAT_YYYY_MM_DD_HH_MM_SS_SLASH = "yyyy/MM/dd HH:mm:ss";
    public static final String TIME_FORMAT_YYYY_MM_BAR = "yyyy-MM";
    public static final String TIME_FORMAT_YYYY_MM_DD_BAR = "yyyy-MM-dd";
    public static final String TIME_FORMAT_YYYY_MM_DD_HH_MM_SS_BAR = "yyyy-MM-dd HH:mm:ss";

    public static String formatCalendar(Calendar calendar, String formatString) {
        if (calendar == null) {
            return "[Format calendar error]";
        }
        return TimeFormatter.formatDate(calendar.getTime(), formatString);
    }

    public static String formatDate(Date date, String formatString) {
        if (date == null) {
            return null;
        }
        if (formatString == null || formatString.length() == 0) {
            formatString = "yyyy/MM/dd HH:mm:ss";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(formatString);
        try {
            return simpleDateFormat.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "[Format date error]";
        }
    }

    public static Calendar parseToCalendar(String timeStr, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date dateTime = null;
        try {
            dateTime = sdf.parse(timeStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar retTime = Calendar.getInstance();
        if (dateTime != null) {
            retTime.setTime(dateTime);
        }
        return retTime;
    }
}

