/*
 * Decompiled with CFR 0.152.
 */
package com.yuxingwang.gantt.model;

import com.yuxingwang.gantt.Config;
import com.yuxingwang.gantt.GanttChart;
import com.yuxingwang.gantt.common.CalendarUtils;
import com.yuxingwang.gantt.event.PredecessorChangeEvent;
import com.yuxingwang.gantt.event.PredecessorChangeListener;
import com.yuxingwang.gantt.model.BaseTask;
import com.yuxingwang.gantt.model.TaskHelper;
import com.yuxingwang.gantt.ui.TimeUnit;
import com.yuxingwang.gantt.ui.timeaxis.BaseTimeAxis;
import com.yuxingwang.gantt.ui.timeaxis.TimeAxisUtils;
import java.util.Calendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Task
extends BaseTask<Task>
implements PredecessorChangeListener {
    private static final long serialVersionUID = 1L;

    public Task() {
        this.addPredecessorChangeListener(this);
    }

    public Task(String string, Calendar calendar, Calendar calendar2) {
        this();
        this.name = string;
        this.setStart(calendar);
        this.setEnd(calendar2);
    }

    public Task(String string, Calendar calendar, Calendar calendar2, int n) {
        this(string, calendar, calendar2);
        this.setProgress(n);
    }

    public Task(String string, Calendar calendar, Calendar calendar2, List<Task> list) {
        this(string, calendar, calendar2);
        if (list != null) {
            this.predecessors = list;
            for (Task task : list) {
                task.subsequences.add(this);
            }
        }
    }

    public Task(String string, String string2, Calendar calendar, Calendar calendar2, int n, List<Task> list) {
        this(string, calendar, calendar2, list);
        this.description = string2;
        this.setProgress(n);
    }

    public void copy(Task task) {
        this.name = task.getName();
        this.description = task.getDescription();
        this.setStart(task.getStart());
        this.setEnd(task.getEnd());
        this.progress = task.getProgress();
    }

    public Task getEarliestSubTask() {
        Task task = this.getEarlistOrLatestSubTask(this, true);
        return task;
    }

    public Task getEarliestTask() {
        Task task = this.getEarlistOrLatestSubTask(this, true);
        if (task != null && task.getActualStart().after(this.getActualStart())) {
            task = this;
        }
        return task;
    }

    public Task getLatestSubTask() {
        Task task = this.getEarlistOrLatestSubTask(this, false);
        return task;
    }

    public Task getLatestTask() {
        Task task = this.getEarlistOrLatestSubTask(this, false);
        if (task != null && task.getActualEnd().before(this.getActualEnd())) {
            task = this;
        }
        return task;
    }

    private Task getEarlistOrLatestSubTask(Task task, boolean bl) {
        Task task2 = null;
        for (int i = 0; i < task.getChildCount(); ++i) {
            Task task3 = (Task)task.children.get(i);
            Task task4 = null;
            if (!task3.isLeaf()) {
                task4 = this.getEarlistOrLatestSubTask(task3, bl);
            }
            if (bl) {
                if (task4 == null || task4.getActualStart().after(task3.getActualStart())) {
                    task4 = task3;
                }
                if (task2 != null && !task2.getActualStart().after(task4.getActualStart())) continue;
                task2 = task4;
                continue;
            }
            if (task4 == null || task4.getActualEnd().before(task3.getActualEnd())) {
                task4 = task3;
            }
            if (task2 != null && !task2.getActualEnd().before(task4.getActualEnd())) continue;
            task2 = task4;
        }
        return task2;
    }

    public int calcTaskSteps() {
        if (this.treeModel == null || this.treeModel.getTimeUnit() == null) {
            return 0;
        }
        TimeUnit timeUnit = this.treeModel.getTimeUnit();
        return TimeAxisUtils.getTimeIntervalByTimeUnit(timeUnit, this.getActualStart(), this.getActualEnd()) + 1;
    }

    public int calcProgressSteps() {
        int n = 0;
        int n2 = this.getProgress();
        if (this.treeModel == null || this.treeModel.getTimeUnit() == null) {
            this.logger.debug((Object)"No tree model or not specified time unit");
            return n;
        }
        TimeUnit timeUnit = this.treeModel.getTimeUnit();
        Config config = GanttChart.getStaticConfig();
        if (timeUnit == TimeUnit.Hour) {
            int[] nArray = GanttChart.getStaticConfig().getWorkingHoursSpanOfDay();
            int n3 = config.getWorkingHoursOfDay();
            int n4 = 0;
            int n5 = this.start.get(11);
            n4 = n5 < nArray[0] || n5 > nArray[1] ? 1 : n5 - nArray[0] + 1;
            int n6 = TaskHelper.getTimeCycleStepsByTimeUnit(timeUnit);
            n = TaskHelper.calcActualStepForProgress(n2, n4, n6, 0, n3, 1);
        } else if (timeUnit == TimeUnit.AllDay) {
            n = n2;
        } else if (timeUnit == TimeUnit.Day) {
            n = 0;
            int n7 = this.start.get(7);
            n = TaskHelper.calcActualStepForProgress(n2, n7, 7, 1, 5, 1);
        } else if (timeUnit == TimeUnit.Week) {
            n = n2;
        } else if (timeUnit == TimeUnit.Month) {
            n = n2;
        } else if (timeUnit == TimeUnit.Year) {
            n = n2;
        }
        return n;
    }

    protected int calcDispalyingStepForProgress(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = 0;
        if (n2 <= n4) {
            n8 = n5;
            n7 = n3 - n4;
        } else if (n2 > n4 + n5) {
            n7 = 0;
        } else {
            n8 = n3 - n2;
            n7 = n8 + n6;
        }
        if (n <= n8) {
            return n;
        }
        n -= n8;
        while (n >= n5) {
            n -= n5;
            n7 += n3;
        }
        if (n > 0) {
            n7 += n + n4;
        }
        return n7;
    }

    public int getDuration() {
        return this.calcDuration();
    }

    public int getProgress() {
        if (this.progress < 0) {
            return 0;
        }
        int n = this.getDuration();
        if (this.progress > n) {
            return n;
        }
        return this.progress;
    }

    public void setProgress(int n) {
        Integer n2 = this.progress;
        this.progress = n;
        this.firePropertyChanged("Progress", n2, n);
    }

    public Calendar getStart() {
        return this.checkAndLimitStartTime(this.start);
    }

    public void setStart(Calendar calendar) {
        Calendar calendar2 = this.start;
        this.start = calendar;
        if (this.predecessors.size() > 0) {
            Task task = (Task)super.getLatestPredecessor();
            if (task != null && (task.getEnd().after(calendar) || task.getEnd().equals(calendar))) {
                this.adjustActualTimesByPredecessor(task);
            } else {
                this.actualStart = (Calendar)calendar.clone();
            }
        } else {
            this.actualStart = (Calendar)calendar.clone();
        }
        this.firePropertyChanged("Start", calendar2, calendar);
    }

    @Override
    public void predecessorChanged(PredecessorChangeEvent predecessorChangeEvent) {
        Task task = (Task)predecessorChangeEvent.getPredecessor();
        if (task != null && task.getEnd() != null && task.getEnd().after(this.getStart())) {
            this.adjustActualTimesByPredecessor();
        }
    }

    public void adjustActualTimesByPredecessor() {
        Task task = (Task)this.getLatestPredecessor();
        this.adjustActualTimesByPredecessor(task);
    }

    protected void adjustActualTimesByPredecessor(Task task) {
        if (this.treeModel == null) {
            return;
        }
        if (task != null) {
            this.logger.debug((Object)("Adjust task's time by predecessor task: " + task.getName()));
            if (this.start != null && CalendarUtils.getDateInterval(this.start, task.getEnd()) >= 0) {
                int n = TimeAxisUtils.getTimeIntervalByTimeUnit(this.treeModel.getTimeUnit(), this.start, task.getEnd());
                this.actualStart = TaskHelper.increaseCloneTimeByTimeUnit(this.treeModel.getTimeUnit(), this.start, ++n);
                this.actualEnd = TaskHelper.increaseCloneTimeByTimeUnit(this.treeModel.getTimeUnit(), this.end, n);
            }
            this.logger.debug((Object)("    After adjustment: " + this));
        }
        for (Task task2 : this.getChildren()) {
            Task task3 = (Task)task2.getLatestPredecessor();
            task2.adjustActualTimesByPredecessor(task3);
        }
    }

    public Calendar getActualStart() {
        return this.checkAndLimitStartTime(this.actualStart);
    }

    protected void setActualStart(Calendar calendar) {
        this.actualStart = calendar;
    }

    public Calendar getEnd() {
        Calendar calendar = this.checkAndLimitEndTime(this.end);
        return calendar;
    }

    public void setEnd(Calendar calendar) {
        Calendar calendar2 = this.end;
        this.end = calendar;
        if (this.start != null && this.predecessors.size() > 0) {
            Task task = (Task)super.getLatestPredecessor();
            if (task != null && task.getEnd() != null && task.getEnd().after(this.start) || task.getEnd().equals(this.start)) {
                this.adjustActualTimesByPredecessor(task);
            } else {
                this.actualEnd = (Calendar)calendar.clone();
            }
        } else {
            this.actualEnd = (Calendar)calendar.clone();
        }
        for (Task task : this.subsequences) {
            task.adjustActualTimesByPredecessor(this);
        }
        this.firePropertyChanged("End", calendar2, calendar);
    }

    public Calendar getActualEnd() {
        return this.checkAndLimitEndTime(this.actualEnd);
    }

    protected void setActualEnd(Calendar calendar) {
        this.actualEnd = calendar;
    }

    private int calcDuration() {
        int n = 0;
        if (this.treeModel == null || this.getActualEnd() == null) {
            return n;
        }
        Config config = GanttChart.getStaticConfig();
        TimeUnit timeUnit = this.treeModel.getTimeUnit();
        Calendar calendar = (Calendar)this.getActualEnd().clone();
        if (timeUnit != null && this.getActualStart() != null && calendar != null) {
            if (timeUnit == TimeUnit.Hour) {
                n = CalendarUtils.calcWorkingHours(this.getActualStart(), calendar, config.getWorkingHoursOfDay(), config.getWorkingHoursSpanOfDay()[0]);
            } else if (timeUnit == TimeUnit.AllDay) {
                n = CalendarUtils.getHourInterval(this.start, this.end) + 1;
            } else if (timeUnit == TimeUnit.Day) {
                n = CalendarUtils.calcWorkingDays(this.getActualStart(), calendar, GanttChart.getStaticConfig().getWorkingDaysSpanOfWeek());
            } else if (timeUnit == TimeUnit.Week) {
                int n2 = this.getActualEnd().get(1) - this.getActualStart().get(1) - 1;
                int n3 = 52 - this.getActualStart().get(3) + this.getActualEnd().get(3);
                n = n2 * 52 + n3;
            } else if (timeUnit == TimeUnit.Month) {
                int n4 = this.getActualEnd().get(1) - this.getActualStart().get(1) - 1;
                int n5 = 12 - this.getActualStart().get(2) + this.getActualEnd().get(2);
                n = n4 * 12 + n5;
            } else if (timeUnit == TimeUnit.Year) {
                n = this.getActualEnd().get(1) - this.getActualStart().get(1);
            }
        }
        return n;
    }

    private Calendar checkAndLimitStartTime(Calendar calendar) {
        if (calendar == null || this.treeModel == null || this.treeModel.getTimeUnit() == null) {
            return calendar;
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        TimeUnit timeUnit = this.treeModel.getTimeUnit();
        if (timeUnit == TimeUnit.Hour) {
            int n = GanttChart.getStaticConfig().getWorkingHoursSpanOfDay()[0];
            int n2 = n + BaseTimeAxis.STEPS_OF_MAJOR_SCALE - 1;
            int n3 = calendar.get(11);
            if (n3 < n || n3 > n2) {
                calendar2.set(11, n);
            }
            if (n3 > n2) {
                calendar2.add(5, 1);
            }
        } else if (timeUnit == TimeUnit.Day) {
            int n = 0;
            int[] nArray = GanttChart.getStaticConfig().getWorkingDaysSpanOfWeek();
            int n4 = calendar.get(7);
            if (n4 < nArray[0]) {
                n = nArray[0] - n4;
            } else if (n4 > nArray[1]) {
                n = 7 - n4 + nArray[0];
            }
            if (n != 0) {
                calendar2.add(5, n);
            }
        }
        return calendar2;
    }

    private Calendar checkAndLimitEndTime(Calendar calendar) {
        if (calendar == null || this.treeModel == null || this.treeModel.getTimeUnit() == null) {
            return calendar;
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        TimeUnit timeUnit = this.treeModel.getTimeUnit();
        if (timeUnit == TimeUnit.Hour) {
            int n = GanttChart.getStaticConfig().getWorkingHoursSpanOfDay()[0];
            int n2 = GanttChart.getStaticConfig().getWorkingHoursSpanOfDay()[1];
            int n3 = calendar.get(11);
            if (n3 < n || n3 > n2) {
                calendar2.set(11, n2);
            }
            if (n3 < n) {
                calendar2.add(5, -1);
            }
        } else if (timeUnit == TimeUnit.Day) {
            int n = 0;
            int[] nArray = GanttChart.getStaticConfig().getWorkingDaysSpanOfWeek();
            int n4 = calendar.get(7);
            if (n4 < nArray[0]) {
                n = nArray[1] - 7 - n4;
            } else if (n4 > nArray[1]) {
                n = nArray[1] - n4;
            }
            if (n != 0) {
                calendar2.add(5, n);
            }
        }
        return calendar2;
    }

    @Override
    public String toString() {
        String string = null;
        String string2 = this.formatTimeByUnit(this.start);
        String string3 = this.formatTimeByUnit(this.end);
        String string4 = this.formatTimeByUnit(this.actualStart);
        String string5 = this.formatTimeByUnit(this.actualEnd);
        String string6 = "    [" + this.getProgress() + "/" + this.getDuration() + "]";
        string = "[" + this.name + "]-[" + string2 + " ~ " + string3 + "]-[" + string4 + " ~ " + string5 + "]" + string6;
        if (this.description != null) {
            string = string + "    " + this.description;
        }
        return string;
    }

    public String toSimpleString() {
        String string = "";
        String string2 = this.formatTimeByUnit(this.actualStart);
        String string3 = this.formatTimeByUnit(this.actualEnd);
        string = "[" + this.name + "]-[" + string2 + " ~ " + string3 + "]";
        return string;
    }

    private String formatTimeByUnit(Calendar calendar) {
        String string;
        String string2 = string = calendar == null ? "--::" : null;
        if (calendar != null) {
            string = this.treeModel == null || this.treeModel.getTimeUnit() == null ? TaskHelper.formatTimeByTimeUnit(TimeUnit.defaultUnit, calendar) : TaskHelper.formatTimeByTimeUnit(this.treeModel.getTimeUnit(), calendar);
        }
        return string;
    }
}

