/*
 * Decompiled with CFR 0.152.
 */
package com.yuxingwang.gantt.model;

import com.yuxingwang.gantt.model.Task;
import com.yuxingwang.gantt.ui.TimeUnit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import yuxingwang.common.time.TimeFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskTreeModel
extends DefaultTreeModel
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    protected Logger logger = LogManager.getLogger(this.getClass());
    private static Task rootNode = new Task("Root", Calendar.getInstance(), Calendar.getInstance());
    private TimeUnit timeUnit = null;
    private int tasksCount = 0;

    public TaskTreeModel() {
        super(rootNode);
    }

    public int getLevels() {
        int n = 0;
        List<Task> list = this.getTasksByDFS();
        for (int i = 0; i < list.size(); ++i) {
            int n2 = list.get(i).getLevel();
            if (n >= n2) continue;
            n = n2;
        }
        return n;
    }

    public int getTasksCount() {
        this.tasksCount = 0;
        int n = 0;
        while (n < rootNode.getChildCount()) {
            Task task = (Task)rootNode.getChildAt(n);
            this.tasksCount += task.getTasksCount();
            ++n;
            ++this.tasksCount;
        }
        return this.tasksCount;
    }

    public void add(Task task) {
        super.insertNodeInto(task, rootNode, rootNode.getChildCount());
        task.setTreeModel(this);
        task.setLevel(1);
        task.addPropertyChangeListener(this);
        super.fireTreeNodesChanged(task, super.getPathToRoot(task), null, null);
        this.logger.info((Object)("Add task to root: " + task.toString()));
    }

    public void addTo(Task task, Task task2) {
        super.insertNodeInto(task2, task, task.getChildCount());
        task2.setTreeModel(this);
        task2.setLevel(task.getLevel() + 1);
        task2.addPropertyChangeListener(this);
        super.fireTreeNodesChanged(task2, super.getPathToRoot(task2), null, null);
        this.logger.info((Object)("Add task : <" + task2.toString() + "> to parent task: <" + this.toString() + ">"));
    }

    public void removeTask(Task task) {
        task.removePropertyChangeListener(this);
        super.removeNodeFromParent(task);
    }

    public void removeAll() {
        rootNode.removeAllChildren();
        this.nodeStructureChanged(rootNode);
    }

    public Task getTask(int n) {
        return this.getTaskFrom(rootNode, n);
    }

    private Task getTaskFrom(MutableTreeNode mutableTreeNode, int n) {
        Enumeration<TreeNode> enumeration = rootNode.children();
        while (enumeration.hasMoreElements()) {
            Task task = (Task)enumeration.nextElement();
            if (task.getId() == n) {
                return task;
            }
            if ((task = this.getTaskFrom(task, n)) == null) continue;
            return task;
        }
        return null;
    }

    public List<Task> getChildren() {
        ArrayList<Task> arrayList = new ArrayList<Task>();
        Enumeration<? extends TreeNode> enumeration = this.root.children();
        while (enumeration.hasMoreElements()) {
            Task task = (Task)enumeration.nextElement();
            arrayList.add(task);
        }
        return arrayList;
    }

    public List<Task> getTasksByDFS() {
        ArrayList<Task> arrayList = new ArrayList<Task>();
        this.getTasks(rootNode, arrayList);
        return arrayList;
    }

    private void getTasks(MutableTreeNode mutableTreeNode, List<Task> list) {
        Enumeration<? extends TreeNode> enumeration = mutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            Task task = (Task)enumeration.nextElement();
            list.add(task);
            if (task.isLeaf()) continue;
            this.getTasks(task, list);
        }
    }

    public Calendar getEndTimeOfLatestTask() {
        Task task = this.getLatestTask();
        if (task == null) {
            return null;
        }
        return task.getActualEnd();
    }

    public Task getLatestTask() {
        Task task = null;
        task = rootNode.getLatestSubTask();
        this.logger.debug((Object)("Get latest sut-task in the TaskTreeModel: " + task));
        return task;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object[] objectArray;
        Object object;
        if (propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getNewValue().getClass().equals(GregorianCalendar.class)) {
            object = TimeFormatter.formatCalendar((Calendar)((Calendar)propertyChangeEvent.getOldValue()), (String)"yyyy-MM-dd HH:mm:ss");
            objectArray = TimeFormatter.formatCalendar((Calendar)((Calendar)propertyChangeEvent.getNewValue()), (String)"yyyy-MM-dd HH:mm:ss");
            this.logger.info((Object)("Task property " + propertyChangeEvent.getPropertyName() + " changed from: " + (String)object + " to " + (String)objectArray));
        } else {
            this.logger.info((Object)("Task property " + propertyChangeEvent.getPropertyName() + " changed from: " + propertyChangeEvent.getOldValue() + " to " + propertyChangeEvent.getNewValue()));
        }
        object = (Task)propertyChangeEvent.getSource();
        objectArray = this.getPathToRoot((TreeNode)object);
        super.fireTreeNodesChanged(object, objectArray, null, null);
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }
}

