/*
 * Decompiled with CFR 0.152.
 */
package com.yuxingwang.gantt.ui.timeaxis;

import com.yuxingwang.gantt.GanttChart;
import com.yuxingwang.gantt.TimeScaleView;
import com.yuxingwang.gantt.common.EventLogger;
import com.yuxingwang.gantt.ui.timeaxis.BaseTimeAxis;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Date;
import javax.swing.JComponent;
import org.apache.commons.lang.time.DateFormatUtils;

public abstract class BaseNoRestoutTimeAxis
extends BaseTimeAxis {
    protected int time_offset = 1;

    public BaseNoRestoutTimeAxis(GanttChart ganttChart) {
        this.gantt = ganttChart;
    }

    public void paint(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        super.paint(graphics, jComponent, rectangle);
        int n = this.calcPositionInMajorScale(this.kickoffTime);
        this.stepsToFirstMajorScale = STEPS_OF_MAJOR_SCALE - n + this.time_offset + this.config.getBlankStepsToKickoffTime();
        if (this.stepsToFirstMajorScale >= STEPS_OF_MAJOR_SCALE) {
            this.stepsToFirstMajorScale -= STEPS_OF_MAJOR_SCALE;
        }
        EventLogger.paintebug("By " + this.config.getBlankStepsToKickoffTime() + " steps before '" + DateFormatUtils.format((Date)this.kickoffTime.getTime(), (String)"yyyy-MM-dd") + "', The steps to first full major scale is: " + this.stepsToFirstMajorScale);
        this.totalMajorStepsCount = (this.totalStepsCount - this.stepsToFirstMajorScale) / STEPS_OF_MAJOR_SCALE + 1;
        super.paintMutual();
    }

    protected void drawMajorTimeScaleBorder() {
        this.g.setColor(Color.black);
        String string = "";
        if (this.stepsToFirstMajorScale > 10) {
            string = this.formatToMajorLabel(this.firstStepOfChart, 0);
            EventLogger.paintebug("Draw lable for large time scale: " + string + " by first date of year " + this.firstStepOfChart.getTime());
            this.g.drawChars(string.toCharArray(), 0, string.length(), 4, 0 + this.row_height - 4);
        }
        for (int i = 0; i < this.totalMajorStepsCount; ++i) {
            EventLogger.paintebug("A year start from step: " + (i * STEPS_OF_MAJOR_SCALE + this.stepsToFirstMajorScale));
            int n = this.config.getTimeUnitWidth() * (i * STEPS_OF_MAJOR_SCALE + this.stepsToFirstMajorScale);
            this.g.drawRect(n, 0, this.componentRect.width - 1, this.row_height);
            string = this.formatToMajorLabel(this.firstStepOfChart, i + 1);
            EventLogger.paintebug("Draw lable for large time scale: " + string);
            this.g.drawChars(string.toCharArray(), 0, string.length(), n + 4, 0 + this.row_height - 4);
        }
    }

    protected void drawMinorTimeScaleBackground(int n, int n2) {
        int n3;
        EventLogger.paintebug("Start to draw small time scale...");
        for (n3 = 0; n3 < this.totalStepsCount; ++n3) {
            this.g.setColor(this.config.getWorkingTimeBackColor());
            this.g.fillRect(this.config.getTimeUnitWidth() * n3, n, this.config.getTimeUnitWidth(), n2);
            this.g.setColor(new Color(240, 240, 240));
            this.g.drawRect(this.config.getTimeUnitWidth() * n3, n, this.config.getTimeUnitWidth(), n2);
        }
        super.drawMajorScaleSeperator();
        super.drawKickoffTime(n, n2);
        super.drawDeadline(n, n2);
        if (this.component instanceof TimeScaleView) {
            for (n3 = 0; n3 < this.totalStepsCount; ++n3) {
                this.drawMinorTimeScaleLabel(n3, this.config.getTimeUnitWidth() * n3, this.row_height);
            }
        }
    }

    protected void drawMinorTimeScaleLabel(int n, int n2, int n3) {
        int n4 = 0;
        n4 = (n - this.stepsToFirstMajorScale + STEPS_OF_MAJOR_SCALE) % STEPS_OF_MAJOR_SCALE + this.time_offset;
        String string = n4 + "";
        this.g.setColor(Color.black);
        this.g.drawChars(string.toCharArray(), 0, string.length(), n2 + 4, n3 + this.row_height - 4);
    }
}

