/*
 * Decompiled with CFR 0.152.
 */
package com.yuxingwang.gantt.ui.timeaxis;

import com.yuxingwang.gantt.GanttChart;
import com.yuxingwang.gantt.common.ResourceManager;
import com.yuxingwang.gantt.ui.timeaxis.BaseNoRestoutTimeAxis;
import java.util.Calendar;
import java.util.Locale;

public class YearlyTimeAxis
extends BaseNoRestoutTimeAxis {
    public YearlyTimeAxis(GanttChart ganttChart) {
        super(ganttChart);
        this.time_offset = 0;
        STEPS_OF_MAJOR_SCALE = 100;
    }

    protected Calendar getFirstStepTimeOfChart(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(1, 0 - this.config.getBlankStepsToKickoffTime());
        return calendar2;
    }

    protected int calcPositionInMajorScale(Calendar calendar) {
        return calendar.get(1) % 100;
    }

    protected String formatToMajorLabel(Calendar calendar, int n) {
        int n2 = calendar.get(1) / 100 + n + 1;
        String string = "";
        if (Locale.getDefault().equals(Locale.ENGLISH)) {
            string = n2 % 10 == 1 ? "st " : (n2 % 10 == 2 ? "nd " : (n2 % 10 == 3 ? "rd " : "th "));
        }
        String string2 = ResourceManager.getInstance().getString("Gantt.TimeAxis.Year.Century");
        return n2 + string + string2;
    }
}

