/*
 * Decompiled with CFR 0.152.
 */
package com.yuxingwang.gantt;

import com.yuxingwang.gantt.BaseView;
import com.yuxingwang.gantt.GanttChart;
import com.yuxingwang.gantt.common.EventLogger;
import com.yuxingwang.gantt.ui.GanttChartViewUI;
import com.yuxingwang.gantt.ui.timeaxis.BaseTimeAxis;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Scrollable;
import javax.swing.UIManager;

public class GanttChartView
extends BaseView
implements Scrollable,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private GanttChartViewUI viewUI = null;
    private int taskCount = 0;

    public GanttChartView(GanttChart ganttChart) {
        super(ganttChart);
        this.initialize();
    }

    private void initialize() {
        this.logger.info((Object)"Start to initialize GanttChartView");
        this.setSize(new Dimension(300, 100));
        this.setMinimumSize(new Dimension(300, 100));
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                EventLogger.event(componentEvent, "GanttChart componentResized() to " + GanttChartView.this.getSize());
            }
        });
        this.viewUI = (GanttChartViewUI)UIManager.getUI(this);
        super.setUI(this.viewUI);
        this.logger.debug((Object)"GanttChartView object constructed");
    }

    protected void refreshDisplay() {
        int n;
        int n2;
        ((BaseTimeAxis)this.viewUI.getTimeAxis()).setTotalStepsCount(this.totalSteps);
        Dimension dimension = this.getSize();
        this.logger.debug((Object)("GanttChartView original size is: " + dimension));
        int n3 = this.config == null ? 24 : this.config.getTimeUnitWidth();
        int n4 = this.totalSteps * n3;
        if (n4 < this.ganttChart.getViewport().getSize().width) {
            n4 = this.ganttChart.getViewport().getSize().width;
        }
        if ((n2 = this.taskCount * (n = this.config == null ? 24 : this.config.getGanttChartRowHeight())) < this.ganttChart.getViewport().getSize().height) {
            n2 = dimension.height;
        }
        Dimension dimension2 = new Dimension(n4, n2);
        this.logger.debug((Object)("GanttChartView preferred size has been set to: " + dimension2));
        this.setPreferredSize(dimension2);
        this.setBounds(0, 0, dimension2.width, dimension2.height);
        this.revalidate();
        super.refreshView();
    }

    public String getUIClassID() {
        return "GanttChartViewUI";
    }

    public String toString() {
        return super.toString() + ", " + this.getUIClassID();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return this.config.getGanttChartRowHeight() * 4;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return this.ganttChart.getConfig().getGanttChartRowHeight();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.refreshDisplay();
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    public void setTaskCount(int n) {
        this.taskCount = n;
    }
}

