/*
 * Decompiled with CFR 0.152.
 */
package com.yuxingwang.gantt.model;

import com.yuxingwang.gantt.event.PredecessorChangeEvent;
import com.yuxingwang.gantt.event.PredecessorChangeListener;
import com.yuxingwang.gantt.model.Task;
import com.yuxingwang.gantt.model.TaskTreeModel;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.collections.list.UnmodifiableList;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseTask<E extends BaseTask>
extends DefaultMutableTreeNode {
    protected Logger logger = null;
    protected int id = -1;
    protected String name;
    protected String description;
    protected Color backcolor;
    protected Calendar start;
    protected Calendar actualStart;
    protected Calendar end;
    protected Calendar actualEnd;
    protected int progress = 0;
    protected int level = 0;
    protected TaskTreeModel treeModel = null;
    protected List<E> predecessors = new ArrayList();
    protected List<E> subsequences = new ArrayList();
    protected transient PropertyChangeEvent propChangeEvent = null;
    protected transient PredecessorChangeEvent predecessorChangeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();

    public BaseTask() {
        this.logger = LogManager.getLogger(this.getClass());
    }

    public void add(E[] EArray) {
        this.logger.info((Object)("Add " + EArray.length + " sub-tasks to parent task: <" + this.toString() + ">"));
        for (int i = 0; i < EArray.length; ++i) {
            this.add(EArray[i]);
        }
    }

    public void add(E e) {
        super.add((MutableTreeNode)e);
        ((BaseTask)e).setTreeModel(this.treeModel);
        if (this.getLevel() > 0) {
            ((BaseTask)e).setLevel(this.getLevel() + 1);
        }
        this.logger.info((Object)("Add task : <" + ((DefaultMutableTreeNode)e).toString() + "> to parent task: <" + this.toString() + ">"));
        PropertyChangeListener[] propertyChangeListenerArray = (PropertyChangeListener[])this.listenerList.getListeners(PropertyChangeListener.class);
        for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
            ((BaseTask)e).addPropertyChangeListener(propertyChangeListenerArray[i]);
        }
        this.firePropertyChanged("SubTask", null, e);
    }

    public int getTasksCount() {
        int n = 0;
        Enumeration<TreeNode> enumeration = this.children();
        Task task = null;
        while (enumeration.hasMoreElements()) {
            task = (Task)enumeration.nextElement();
            n += task.getTasksCount();
            ++n;
        }
        return n;
    }

    public List<Task> getChildren() {
        ArrayList<Task> arrayList = new ArrayList<Task>();
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            Task task = (Task)enumeration.nextElement();
            arrayList.add(task);
        }
        return arrayList;
    }

    public List<E> getPredecessors() {
        return UnmodifiableList.decorate(this.predecessors);
    }

    protected E getLatestPredecessor() {
        Calendar calendar = new GregorianCalendar(1970, 0, 0);
        BaseTask baseTask = null;
        for (BaseTask baseTask2 : this.predecessors) {
            if (!calendar.before(baseTask2.actualEnd)) continue;
            calendar = baseTask2.actualEnd;
            baseTask = baseTask2;
        }
        return (E)baseTask;
    }

    public void addPredecessor(E e) {
        if (e == this) {
            throw new InvalidParameterException("You can't make any task to be it's own predecessor task");
        }
        this.predecessors.add(e);
        ((BaseTask)e).subsequences.add(this);
        this.firePredecessorChanged((BaseTask)e);
    }

    public void addPredecessorChangeListener(PredecessorChangeListener predecessorChangeListener) {
        this.listenerList.add(PredecessorChangeListener.class, predecessorChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listenerList.add(PropertyChangeListener.class, propertyChangeListener);
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            BaseTask baseTask = (BaseTask)enumeration.nextElement();
            baseTask.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void removePredecessorChangeListener(PredecessorChangeListener predecessorChangeListener) {
        this.listenerList.remove(PredecessorChangeListener.class, predecessorChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listenerList.remove(PropertyChangeListener.class, propertyChangeListener);
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            BaseTask baseTask = (BaseTask)enumeration.nextElement();
            baseTask.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected void firePropertyChanged(String string, Object object, Object object2) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PropertyChangeListener.class) continue;
            this.propChangeEvent = new PropertyChangeEvent(this, string, object, object2);
            ((PropertyChangeListener)objectArray[i + 1]).propertyChange(this.propChangeEvent);
        }
    }

    protected void firePredecessorChanged(BaseTask baseTask) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PredecessorChangeListener.class) continue;
            this.predecessorChangeEvent = new PredecessorChangeEvent(this, baseTask);
            ((PredecessorChangeListener)objectArray[i + 1]).predecessorChanged(this.predecessorChangeEvent);
        }
    }

    protected void setTreeModel(TaskTreeModel taskTreeModel) {
        this.treeModel = taskTreeModel;
        Enumeration<TreeNode> enumeration = this.children();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            BaseTask baseTask = (BaseTask)enumeration.nextElement();
            baseTask.setTreeModel(taskTreeModel);
            ++n;
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        Integer n2 = this.id;
        this.id = n;
        this.firePropertyChanged("ID", n2, n);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        String string2 = this.description;
        this.description = string;
        this.firePropertyChanged("Description", string2, string);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        this.firePropertyChanged("Name", string2, string);
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    protected void setLevel(int n) {
        this.level = n;
        Enumeration<TreeNode> enumeration = this.children();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            Task task = (Task)enumeration.nextElement();
            task.setLevel(n + 1);
            ++n2;
        }
    }

    public Color getBackcolor() {
        return this.backcolor;
    }

    public void setBackcolor(Color color) {
        this.backcolor = color;
    }
}

