/*
 * Decompiled with CFR 0.152.
 */
package com.yuxingwang.gantt.ui;

import com.yuxingwang.gantt.LogoView;
import com.yuxingwang.gantt.common.LogHelper;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.LabelUI;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class LogoViewUI
extends LabelUI {
    protected LogoView logoView = null;
    protected Logger logger = LogManager.getLogger(this.getClass());
    private int fontSize = 28;

    public static ComponentUI createUI(JComponent jComponent) {
        return new LogoViewUI();
    }

    public void installUI(JComponent jComponent) {
        this.logoView = (LogoView)jComponent;
        super.installUI(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        LogHelper.title(this.logger, "Start to Paint Logo View UI");
        int n = jComponent.getSize().width;
        int n2 = jComponent.getSize().height;
        this.logger.debug((Object)n);
        this.logger.debug((Object)n2);
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, n, n2);
        graphics.setFont(new Font("Colonna MT", 1, this.fontSize));
        String string = this.logoView.getText();
        if (string != null) {
            this.logger.debug((Object)("Text: " + string));
            graphics.setColor(new Color(109, 135, 75));
            graphics.drawChars(string.toCharArray(), 0, 5, 20, 32);
            graphics.setColor(new Color(19, 128, 168));
            graphics.drawChars(string.toCharArray(), 5, string.length() - 5, n / 2, 32);
        }
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, n, n2);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }
}

