/*
 * Decompiled with CFR 0.152.
 */
package yuxingwang.common;

import java.util.HashMap;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import yuxingwang.common.TestUtil;

public class TreeUtil {
    public static void SyncTreeNode(TreePath path, JTree tree2, DefaultMutableTreeNode rootNode2, boolean isExpand) {
        if (path == null) {
            return;
        }
        Object[] nodeNames = path.getPath();
        DefaultMutableTreeNode node = TreeUtil.GetSubNodeByNames(nodeNames, rootNode2, 1);
        TestUtil.debugInfo("SyncTreeNode", "Wanted node : " + node + "  and leval is " + node.getLevel());
        if (node.getParent() != null) {
            TreePath path2 = new TreePath(node.getPath());
            if (isExpand) {
                tree2.expandPath(path2);
                tree2.setSelectionPath(path2);
            } else {
                tree2.collapsePath(path2);
            }
            tree2.scrollPathToVisible(path2);
        }
    }

    public static DefaultMutableTreeNode GetSubNodeByNames(Object[] nodeNames, DefaultMutableTreeNode parentNode, int startFrom) {
        DefaultMutableTreeNode curNode;
        if (startFrom >= nodeNames.length) {
            return parentNode;
        }
        if ((curNode = TreeUtil.GetSubNodeByName(nodeNames[startFrom++].toString(), parentNode)) == null) {
            return parentNode;
        }
        return TreeUtil.GetSubNodeByNames(nodeNames, curNode, startFrom);
    }

    public static DefaultMutableTreeNode GetSubNodeByName(String name, DefaultMutableTreeNode parentNode) {
        if (parentNode.isLeaf()) {
            return null;
        }
        DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)parentNode.getFirstChild();
        while (curNode != null) {
            String curSubNodeName = curNode.getUserObject().toString();
            if (curSubNodeName.trim().equals(name.trim())) {
                return curNode;
            }
            curNode = curNode.getNextSibling();
        }
        return null;
    }

    public static void prepareCompareResult(DefaultMutableTreeNode rootNode, HashMap resultMap) {
        if (resultMap == null || resultMap.size() < 1) {
            return;
        }
        TestUtil.debugInfo("prepareCompareResult", String.valueOf(resultMap.size()) + " nodes will be added to [" + rootNode.getUserObject() + "]");
        for (Object key : resultMap.keySet()) {
            DefaultMutableTreeNode curNode = new DefaultMutableTreeNode(key);
            rootNode.add(curNode);
            Object child = resultMap.get(key);
            if (child instanceof HashMap) {
                TreeUtil.prepareCompareResult(curNode, (HashMap)child);
                continue;
            }
            if (!(child instanceof String)) continue;
            Object value = resultMap.get(key);
            String str = value.toString();
            System.out.println("Is table Name? " + str);
            if (str.startsWith("{") && str.endsWith("}")) {
                str = str.substring(str.indexOf(61), str.indexOf(125));
                System.out.println("This is a table name" + str);
            }
            DefaultMutableTreeNode valueNode = new DefaultMutableTreeNode(str);
            curNode.add(valueNode);
        }
    }
}

