/*
 * Decompiled with CFR 0.152.
 */
package yuxingwang.common.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import yuxingwang.common.TestUtil;

public class CheckList
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private JList jList = null;

    public CheckList() {
        this.initialize();
    }

    public void addElement(String value) {
        DefaultListModel model = (DefaultListModel)this.getJList().getModel();
        model.addElement(new CheckListItem(false, value));
    }

    public int[] getSelectedIndices() {
        return null;
    }

    public CheckListItem[] getSelectedItems() {
        CheckListItem[] items = null;
        ArrayList<CheckListItem> list = new ArrayList<CheckListItem>();
        int i = 0;
        while (i < this.getJList().getModel().getSize()) {
            CheckListItem curItems = (CheckListItem)this.getJList().getModel().getElementAt(i);
            if (curItems.getCheck()) {
                TestUtil.debugInfo("getSelectedItems", "Found");
                list.add(curItems);
            }
            ++i;
        }
        items = new CheckListItem[list.size()];
        i = 0;
        while (i < list.size()) {
            items[i] = (CheckListItem)list.get(i);
            ++i;
        }
        return items;
    }

    public void selectAll() {
        int i = 0;
        while (i < this.getJList().getModel().getSize()) {
            CheckListItem curItems = (CheckListItem)this.getJList().getModel().getElementAt(i);
            curItems.setCheck(true);
            ++i;
        }
    }

    public void deselectAll() {
        int i = 0;
        while (i < this.getJList().getModel().getSize()) {
            CheckListItem curItems = (CheckListItem)this.getJList().getModel().getElementAt(i);
            curItems.setCheck(false);
            ++i;
        }
    }

    private void initialize() {
        this.setViewportView(this.getJList());
        this.setSize(169, 175);
    }

    private JList getJList() {
        if (this.jList == null) {
            this.jList = new JList();
            this.jList.setModel(new DefaultListModel());
            this.jList.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    CheckListItem item;
                    System.out.println("mousePressed()");
                    JList list = (JList)e.getSource();
                    int index = list.locationToIndex(e.getPoint());
                    if (CheckList.this.getJList().getModel().getSize() < 1) {
                        return;
                    }
                    item.setCheck(!(item = (CheckListItem)CheckList.this.getJList().getModel().getElementAt(index)).getCheck());
                    Rectangle rect = list.getCellBounds(index, index);
                    list.repaint(rect);
                }
            });
        }
        this.jList.setCellRenderer(new CheckListItemRenderer());
        return this.jList;
    }

    public static void main(String[] args) {
    }

    public class CheckListItem {
        boolean check;
        String text;

        public CheckListItem(boolean check, String text) {
            this.check = check;
            this.text = text;
        }

        public boolean getCheck() {
            return this.check;
        }

        public void setCheck(boolean _check) {
            this.check = _check;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String _text) {
            this.text = _text;
        }
    }

    public class CheckListItemRenderer
    extends JCheckBox
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            CheckListItem item = (CheckListItem)value;
            this.setSelected(item.getCheck());
            this.setText(item.getText());
            this.setFont(list.getFont());
            this.setEnabled(list.isEnabled());
            this.setBackground(Color.WHITE);
            return this;
        }
    }
}

