/*
 * Decompiled with CFR 0.152.
 */
package yuxingwang.common.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import yuxingwang.common.controls.ExTableCellRenderers;

public class ExTable
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private final int DIGITAL_WIDTH = 9;
    private JTable rowHeaderTable = null;
    private JTable tableView = null;
    private DefaultTableCellRenderer rowColorCellRenderer = new ExTableCellRenderers.TwoColorsCellRenderer(ExTableCellRenderers.getInstance());
    DefaultTableCellRenderer constantsCellRender = new ColorTableCellRenderer();

    public ExTable() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(483, 146);
        this.rowHeaderTable = new JTable();
        this.rowHeaderTable.setEnabled(false);
        this.rowHeaderTable.setTableHeader(null);
        this.rowHeaderTable.setAutoResizeMode(0);
        this.rowHeaderTable.setSize(32, 32);
        this.setRowHeaderView(this.rowHeaderTable);
        this.initTableView();
        this.setViewportView(this.getTableView());
    }

    private void initTableView() {
        this.getTableView().setSelectionForeground(Color.BLACK);
    }

    public void initRowHeader() {
        DefaultTableModel tableModel = (DefaultTableModel)this.tableView.getModel();
        DefaultTableModel rowHeadModel = new DefaultTableModel(0, 1);
        rowHeadModel.addColumn("ID");
        int i = 0;
        while (i < tableModel.getRowCount()) {
            rowHeadModel.addRow(new Object[]{String.valueOf(i + 1)});
            ++i;
        }
        this.rowHeaderTable.setModel(rowHeadModel);
        this.rowHeaderTable.getColumnModel().getColumn(0).setPreferredWidth(this.calcRowHeadWidth(rowHeadModel.getRowCount()));
        this.rowHeaderTable.setDefaultRenderer(this.rowHeaderTable.getColumnClass(0), new DefaultTableCellRenderer());
        this.rowHeaderTable.setPreferredScrollableViewportSize(new Dimension(this.rowHeaderTable.getColumnModel().getColumn(0).getPreferredWidth(), 0));
    }

    private int calcRowHeadWidth(int rowCount) {
        String modelSize = String.valueOf(rowCount);
        return 9 * modelSize.length();
    }

    public void makeFace() {
        try {
            DefaultTableCellRenderer cellRender = this.getRowColorCellRenderer();
            int i = 0;
            while (i < this.getTableView().getColumnCount()) {
                this.getTableView().getColumn(this.getTableView().getColumnName(i)).setCellRenderer(cellRender);
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setColumnColor(int column, Color color) {
        this.getTableView().getColumn(this.getTableView().getColumnName(column)).setCellRenderer(this.constantsCellRender);
    }

    public JTable getTableView() {
        if (this.tableView == null) {
            this.tableView = new JTable();
            this.tableView.addPropertyChangeListener("model", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    System.out.println("propertyChange(model)");
                    ExTable.this.initRowHeader();
                    ExTable.this.makeFace();
                }
            });
        }
        return this.tableView;
    }

    public static void main(String[] args) {
    }

    public JTable getRowHeaderTable() {
        return this.rowHeaderTable;
    }

    public DefaultTableCellRenderer getRowColorCellRenderer() {
        return this.rowColorCellRenderer;
    }

    public void setRowColorCellRenderer(DefaultTableCellRenderer rowColorCellRenderer) {
        this.rowColorCellRenderer = rowColorCellRenderer;
    }

    public class ColorTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            cell.setBackground(new Color(200, 200, 200));
            return cell;
        }
    }
}

