/*
 * Decompiled with CFR 0.152.
 */
package yuxingwang.common.controls;

import java.awt.Dimension;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ExTree
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private JTree tree = null;
    private DefaultMutableTreeNode selectedNode = null;

    public ExTree() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(478, 198));
        this.setViewportView(this.getTree());
    }

    public void expandAllTreeNode(DefaultMutableTreeNode rootNode) {
        int i = 0;
        while (i < rootNode.getChildCount()) {
            DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)rootNode.getChildAt(i);
            TreePath path = new TreePath(curNode.getPath());
            this.tree.expandPath(path);
            this.expandAllTreeNode(curNode);
            ++i;
        }
    }

    public void expandTreeNode(DefaultMutableTreeNode node) {
        TreePath nodePath = new TreePath(node.getPath());
        this.tree.expandPath(nodePath);
    }

    protected JTree getTree() {
        if (this.tree == null) {
            this.tree = new JTree();
            this.tree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    System.out.println("valueChanged()");
                    ExTree.this.selectedNode = (DefaultMutableTreeNode)ExTree.this.tree.getLastSelectedPathComponent();
                }
            });
        }
        return this.tree;
    }

    protected void fireTreeSelection(TreePath selectedNode) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeSelectionEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == TreeSelectionListener.class) {
                if (e == null) {
                    e = new TreeSelectionEvent((Object)this, selectedNode, true, null, null);
                }
                ((TreeSelectionListener)listeners[i + 1]).valueChanged(e);
            }
            i -= 2;
        }
    }

    public TreeModel getTreeModel() {
        return this.tree.getModel();
    }

    public void setTreeModel(DefaultTreeModel treeModel) {
        this.tree.setModel(treeModel);
    }

    public DefaultMutableTreeNode getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(DefaultMutableTreeNode selectedNode) {
        this.selectedNode = selectedNode;
    }
}

