/*
 * Decompiled with CFR 0.152.
 */
package yuxingwang.common.time;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import yuxingwang.common.time.DateSpan;

public class DatetimeUtil {
    private static final long serialVersionUID = 1L;
    private static DatetimeUtil commonUtil = null;
    public static final String TIME_FORMAT_SLASH_YYYY_MM_DD = "yyyy/MM/dd";
    public static final String TIME_FORMAT_SLASH_YYYY_MM_DD_HH_MM_SS = "yyyy/MM/dd HH:mm:ss.SSS";
    static int[] monthDays = new int[12];

    static {
        DatetimeUtil.monthDays[0] = 31;
        DatetimeUtil.monthDays[1] = 28;
        DatetimeUtil.monthDays[2] = 31;
        DatetimeUtil.monthDays[3] = 30;
        DatetimeUtil.monthDays[4] = 31;
        DatetimeUtil.monthDays[5] = 30;
        DatetimeUtil.monthDays[6] = 31;
        DatetimeUtil.monthDays[7] = 31;
        DatetimeUtil.monthDays[8] = 30;
        DatetimeUtil.monthDays[9] = 31;
        DatetimeUtil.monthDays[10] = 30;
        DatetimeUtil.monthDays[11] = 31;
    }

    public static DatetimeUtil getInstance() {
        if (commonUtil == null) {
            commonUtil = new DatetimeUtil();
        }
        return commonUtil;
    }

    public static Date stripTimeOfDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(9, 0);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public String parseToDate(String dateString) {
        if (dateString == null) {
            return null;
        }
        dateString = dateString.replace('-', '/');
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TIME_FORMAT_SLASH_YYYY_MM_DD);
        try {
            String dateStringRtn = "";
            Date date = simpleDateFormat.parse(dateString);
            dateStringRtn = simpleDateFormat.format(date);
            dateStringRtn = String.valueOf(dateStringRtn.substring(5)) + "/" + dateStringRtn.substring(0, 4);
            return dateStringRtn;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isNumberFormat(String str) {
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int getDaysOfMonth(GregorianCalendar calendar, int year, int month) {
        if (month == 1 && calendar.isLeapYear(year)) {
            return 29;
        }
        return monthDays[month - 1];
    }

    public static DateSpan getPastWeek(Calendar calendar, int pastCount) {
        int date = calendar.get(5);
        calendar.set(5, date - pastCount * 7);
        return DatetimeUtil.getCurrentWeek(calendar);
    }

    public static DateSpan getConsequentWeek(Calendar calendar, int consequentCount) {
        int date = calendar.get(5);
        calendar.set(5, date + consequentCount * 7);
        return DatetimeUtil.getCurrentWeek(calendar);
    }

    public static DateSpan getCurrentWeek(Calendar calendar) {
        DateSpan ds = new DateSpan();
        int dayOfWeek = calendar.get(7);
        int date = calendar.get(5);
        Calendar from = (Calendar)calendar.clone();
        from.set(5, date - dayOfWeek + 1);
        from.set(10, 0);
        from.set(12, 0);
        from.set(13, 0);
        ds.SetTimeFrom(from.getTime());
        System.out.println("Start time of the week: " + ds.getDateFrom().toString());
        Calendar to = (Calendar)from.clone();
        to.add(5, 6);
        to.set(9, 0);
        to.set(10, 23);
        to.set(12, 59);
        to.set(13, 59);
        ds.setTimeTo(to.getTime());
        System.out.println("End time of the week: " + ds.getDateTo().toString());
        System.out.println("The duration of the week: " + ds.toString());
        return ds;
    }

    public static String mergeYearMonth(String year, int month) {
        if (month < 10) {
            return String.valueOf(year) + "0" + String.valueOf(month);
        }
        return String.valueOf(year) + String.valueOf(month);
    }
}

