/*
 * Decompiled with CFR 0.152.
 */
package com.yuxingwang.gantt;

import com.yuxingwang.gantt.common.EventLogger;
import java.awt.Color;
import java.awt.SystemColor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.EventListenerList;

public class Config {
    public static final int DEFAULT_TIME_UNIT_WIDTH = 24;
    public static final int DEFAULT_GANTT_CHART_ROW_HEIGHT = 24;
    public static final int DEFAULT_TASK_BAR_HEIGHT = 16;
    public static final int DEFAULT_PROGRESS_BAR_HEIGHT = 8;
    public static final int DEFAULT_BLANK_STEPS_TO_KICKOFF_TIME = 2;
    public static final int DEFAULT_BLANK_STEPS_TO_DEADLINE = 10;
    public static final boolean DEFAULT_SHOW_TASK_INFO_BEHIND_TASK_BAR = true;
    public static final int HOURLY_PRE_REST_STEPS = 0;
    public static final int HOURLY_SEQ_REST_STEPS = 1;
    public static final int DAILY_TOTAL_DAYS_OF_WEEK = 7;
    public static final int DAILY_PRE_REST_STEPS = 1;
    public static final int DEFAULT_DAILY_WORKING_STEPS = 5;
    public static final int DAILY_SEQ_REST_STEPS = 1;
    public static final int[] DEFAULT_WORKING_DAYS_SPAN_OF_WEEK = new int[]{2, 6};
    public static final int[] DEFAULT_WORKING_HOURS_SPAN_OF_DAY = new int[]{9, 16};
    private Color ganttChartBackColor = SystemColor.control;
    private Color workingTimeBackColor = Color.white;
    private Color restoutTimeBackColor = Color.gray;
    private Color kickoffTimeBackColor = Color.cyan;
    private Color deadlineBackColor = new Color(255, 153, 204);
    private Color taskTreeViewBackColor = SystemColor.control;
    private Color taskGroupBarBackColor = Color.black;
    private Color taskBarBackColor = new Color(102, 153, 255);
    private Color progressBarBackColor = Color.black;
    private int timeUnitWidth = 24;
    private int ganttChartRowHeight = 24;
    private int taskBarHeight = 16;
    private int progressBarHeight = 8;
    private int blankStepsToKickoffTime = 2;
    private int blankStepsToDeadline = 10;
    private boolean showTaskInfoBehindTaskBar = true;
    private int[] workingDaysSpanOfWeek = DEFAULT_WORKING_DAYS_SPAN_OF_WEEK;
    private int[] workingHoursSpanOfDay = DEFAULT_WORKING_HOURS_SPAN_OF_DAY;
    protected transient PropertyChangeEvent propChangeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listenerList.add(PropertyChangeListener.class, propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PropertyChangeListener.class) continue;
            this.propChangeEvent = new PropertyChangeEvent(this, string, object, object2);
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)objectArray[i + 1];
            propertyChangeListener.propertyChange(this.propChangeEvent);
            EventLogger.event(this.propChangeEvent, "The config value " + string + " has been changed from " + object + " to " + object2 + "! -> Listener: " + propertyChangeListener.getClass().getName());
        }
    }

    public Color getGanttChartBackColor() {
        return this.ganttChartBackColor;
    }

    public void setGanttChartBackColor(Color color) {
        Color color2 = this.ganttChartBackColor;
        this.ganttChartBackColor = color;
        this.firePropertyChange("GanttChartBackColor", color2, color);
    }

    public Color getWorkingTimeBackColor() {
        return this.workingTimeBackColor;
    }

    public void setWorkingTimeBackColor(Color color) {
        Color color2 = this.workingTimeBackColor;
        this.workingTimeBackColor = color;
        this.firePropertyChange("WorkingTimeBackColor", color2, color);
    }

    public Color getRestoutTimeBackColor() {
        return this.restoutTimeBackColor;
    }

    public void setRestoutTimeBackColor(Color color) {
        Color color2 = this.restoutTimeBackColor;
        this.restoutTimeBackColor = color;
        this.firePropertyChange("RestoutTimeBackColor", color2, color);
    }

    public Color getKickoffTimeBackColor() {
        return this.kickoffTimeBackColor;
    }

    public void setKickoffTimeBackColor(Color color) {
        Color color2 = this.kickoffTimeBackColor;
        this.kickoffTimeBackColor = color;
        this.firePropertyChange("KickoffTimeBackColor", color2, color);
    }

    public Color getDeadlineBackColor() {
        return this.deadlineBackColor;
    }

    public void setDeadlineBackColor(Color color) {
        Color color2 = this.deadlineBackColor;
        this.deadlineBackColor = color;
        this.firePropertyChange("DeadlineBackColor", color2, color);
    }

    public Color getTaskGroupBarBackColor() {
        return this.taskGroupBarBackColor;
    }

    public void setTaskGroupBarBackColor(Color color) {
        Color color2 = this.taskGroupBarBackColor;
        this.taskGroupBarBackColor = color;
        this.firePropertyChange("TaskGroupBarBackColor", color2, color);
    }

    public Color getTaskBarBackColor() {
        return this.taskBarBackColor;
    }

    public void setTaskBarBackColor(Color color) {
        Color color2 = this.taskBarBackColor;
        this.taskBarBackColor = color;
        this.firePropertyChange("TaskBarBackColor", color2, color);
    }

    public Color getProgressBarBackColor() {
        return this.progressBarBackColor;
    }

    public void setProgressBarBackColor(Color color) {
        Color color2 = this.progressBarBackColor;
        this.progressBarBackColor = color;
        this.firePropertyChange("ProgressBarBackColor", color2, color);
    }

    public int getTimeUnitWidth() {
        return this.timeUnitWidth;
    }

    public void setTimeUnitWidth(int n) {
        Integer n2 = this.timeUnitWidth;
        this.timeUnitWidth = n;
        this.firePropertyChange("TimeUnitWidth", n2, n);
    }

    public int getGanttChartRowHeight() {
        return this.ganttChartRowHeight;
    }

    public void setGanttChartRowHeight(int n) {
        Integer n2 = this.ganttChartRowHeight;
        this.ganttChartRowHeight = n;
        this.firePropertyChange("GanttChartRowHeight", n2, n);
    }

    public int getTaskBarHeight() {
        return this.taskBarHeight;
    }

    public void setTaskBarHeight(int n) {
        Integer n2 = this.taskBarHeight;
        this.taskBarHeight = n;
        this.firePropertyChange("TaskBarHeight", n2, n);
    }

    public int getProgressBarHeight() {
        return this.progressBarHeight;
    }

    public void setProgresBarHeight(int n) {
        Integer n2 = this.progressBarHeight;
        this.progressBarHeight = n;
        this.firePropertyChange("ProgresBarHeight", n2, n);
    }

    public int getBlankStepsToKickoffTime() {
        return this.blankStepsToKickoffTime;
    }

    public void setBlankStepsToKickoffTime(int n) {
        Integer n2 = this.blankStepsToKickoffTime;
        this.blankStepsToKickoffTime = n;
        this.firePropertyChange("EmpytStepsToKickoffTime", n2, n);
    }

    public int getBlankStepsToDeadline() {
        return this.blankStepsToDeadline;
    }

    public void setBlankStepsToDeadline(int n) {
        Integer n2 = this.blankStepsToDeadline;
        this.blankStepsToDeadline = n;
        this.firePropertyChange("EmptyStepsToDeadline", n2, n);
    }

    public boolean isShowTaskInfoBehindTaskBar() {
        return this.showTaskInfoBehindTaskBar;
    }

    public void setShowTaskInfoBehindTaskBar(boolean bl) {
        Boolean bl2 = this.showTaskInfoBehindTaskBar;
        this.showTaskInfoBehindTaskBar = bl;
        this.firePropertyChange("ShowTaskInfoBehindTaskBar", bl2, bl);
    }

    public Color getTaskTreeViewBackColor() {
        return this.taskTreeViewBackColor;
    }

    public void setTaskTreeViewBackColor(Color color) {
        Color color2 = this.taskTreeViewBackColor;
        this.taskTreeViewBackColor = color;
        this.firePropertyChange("TaskTreeViewBackColor", color2, color);
    }

    public int[] getWorkingDaysSpanOfWeek() {
        return this.workingDaysSpanOfWeek;
    }

    public void setWorkingDaysSpanOfWeek(int[] nArray) {
        int[] nArray2 = this.workingDaysSpanOfWeek;
        if (nArray[0] > nArray[1]) {
            throw new IllegalArgumentException("The start working day of week can't be after end working day");
        }
        this.workingDaysSpanOfWeek = nArray;
        if (this.workingDaysSpanOfWeek[0] < 0) {
            this.workingDaysSpanOfWeek[0] = 1;
        }
        if (this.workingDaysSpanOfWeek[1] > 7) {
            this.workingDaysSpanOfWeek[1] = 7;
        }
        this.firePropertyChange("WorkingHoursSpanOfDay", nArray2, nArray);
    }

    public int[] getWorkingHoursSpanOfDay() {
        return this.workingHoursSpanOfDay;
    }

    public int getWorkingHoursOfDay() {
        return this.workingHoursSpanOfDay[1] - this.workingHoursSpanOfDay[0] + 1;
    }

    public void setWorkingHoursSpanOfDay(int[] nArray) {
        int[] nArray2 = this.workingHoursSpanOfDay;
        if (nArray[0] > nArray[1]) {
            throw new IllegalArgumentException("The start working hour of day can't be after end working hour");
        }
        this.workingHoursSpanOfDay = nArray;
        if (this.workingHoursSpanOfDay[0] < 0) {
            this.workingHoursSpanOfDay[0] = 0;
        }
        if (this.workingHoursSpanOfDay[1] > 23) {
            this.workingHoursSpanOfDay[1] = 23;
        }
        this.firePropertyChange("WorkingHoursSpanOfDay", nArray2, nArray);
    }
}

