/*
 * Decompiled with CFR 0.152.
 */
package com.yuxingwang.gantt;

import com.yuxingwang.gantt.Config;
import com.yuxingwang.gantt.GanttChartView;
import com.yuxingwang.gantt.LogoView;
import com.yuxingwang.gantt.TaskTreeScrollBar;
import com.yuxingwang.gantt.TaskTreeView;
import com.yuxingwang.gantt.TimeScaleView;
import com.yuxingwang.gantt.common.EventLogger;
import com.yuxingwang.gantt.event.TimeUnitChangeEvent;
import com.yuxingwang.gantt.event.TimeUnitChangeListener;
import com.yuxingwang.gantt.model.GanttModel;
import com.yuxingwang.gantt.model.GanttModelChangeEvent;
import com.yuxingwang.gantt.model.GanttModelListener;
import com.yuxingwang.gantt.ui.TimeUnit;
import com.yuxingwang.gantt.ui.timeaxis.TimeAxisUtils;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import yuxingwang.common.image.SwingComponentImageGenerator;

public class GanttChart
extends JScrollPane
implements GanttModelListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    protected Logger logger = null;
    private static Config config = new Config();
    private TimeUnit timeUnit = TimeUnit.defaultUnit;
    private GanttModel model = null;
    private boolean showTreeView = true;
    private GanttChartView ganttChartView = null;
    private TimeScaleView timeScaleView = null;
    private TaskTreeView taskTreeView = null;
    private JScrollBar treeViewScrollBar = null;
    private LogoView logoView = null;
    private int totalSteps = 0;
    private int tasksCount = 0;

    public GanttChart() {
        this.logger = LogManager.getLogger(this.getClass());
        UIManager.put("TimeScaleUI", "com.yuxingwang.gantt.ui.TimeScaleUI");
        UIManager.put("TaskTreeUI", "com.yuxingwang.gantt.ui.TaskTreeUI");
        UIManager.put("GanttChartViewUI", "com.yuxingwang.gantt.ui.GanttChartViewUI");
        UIManager.put("LogoViewUI", "com.yuxingwang.gantt.ui.LogoViewUI");
        this.timeScaleView = new TimeScaleView(this);
        this.taskTreeView = new TaskTreeView(this);
        this.ganttChartView = new GanttChartView(this);
        this.treeViewScrollBar = new TaskTreeScrollBar(this.taskTreeView);
        this.treeViewScrollBar.setOrientation(0);
        this.logoView = new LogoView(this);
        config.addPropertyChangeListener(this.timeScaleView);
        config.addPropertyChangeListener(this.taskTreeView);
        config.addPropertyChangeListener(this.ganttChartView);
        config.addPropertyChangeListener(this);
        this.setColumnHeaderView(this.timeScaleView);
        this.setRowHeaderView(this.taskTreeView);
        this.setViewportView(this.ganttChartView);
        this.setCorner("UPPER_LEFT_CORNER", this.logoView);
        this.setCorner("LOWER_LEFT_CORNER", this.treeViewScrollBar);
    }

    public void ganttModelChanged(GanttModelChangeEvent ganttModelChangeEvent) {
        String string = "GanttModel property '" + ganttModelChangeEvent.getPropertyName() + "' has been changed: ";
        if (ganttModelChangeEvent.getNewValue() != null) {
            string = ganttModelChangeEvent.getNewValue() instanceof Calendar ? string + ((Calendar)ganttModelChangeEvent.getNewValue()).getTime() : string + ganttModelChangeEvent.getNewValue();
        }
        EventLogger.event(ganttModelChangeEvent, string);
        this.totalSteps = this.calcTotalSteps(this.model.getKickoffTime(), this.model.getDeadline());
        this.tasksCount = this.model.getTaskTreeModel().getTasksCount() + 2;
        this.timeScaleView.setTotalSteps(this.totalSteps);
        this.ganttChartView.setTotalSteps(this.totalSteps);
        this.taskTreeView.setTaskCount(this.tasksCount);
        this.ganttChartView.setTaskCount(this.tasksCount);
        this.timeScaleView.refreshDisplay();
        this.taskTreeView.refreshDisplay();
        this.ganttChartView.refreshDisplay();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void generateImageFile(String string) throws IOException {
        if (string == null || string.length() == 0) {
            throw new IOException("No file name specified, please provide one");
        }
        File file = new File(string);
        if (file.isDirectory()) {
            throw new IOException("No file name specified, please provide one");
        }
        String string2 = FilenameUtils.getExtension((String)string);
        GanttChartView ganttChartView = this.ganttChartView;
        TimeScaleView timeScaleView = this.timeScaleView;
        TaskTreeView taskTreeView = this.taskTreeView;
        LogoView logoView = this.logoView;
        this.logger.debug((Object)("[Bounds] GanttChartView" + ganttChartView.getBounds()));
        this.logger.debug((Object)("[Bounds] TimeScaleView" + timeScaleView.getBounds()));
        this.logger.debug((Object)("[Bounds] Tas[Bounds]eView" + taskTreeView.getBounds()));
        this.logger.debug((Object)("[Bounds] logoView" + taskTreeView.getBounds()));
        Dimension dimension = new Dimension(ganttChartView.getBounds().width + taskTreeView.getBounds().width, timeScaleView.getBounds().height + ganttChartView.getBounds().height);
        Rectangle rectangle = new Rectangle(taskTreeView.getBounds().width, 0, timeScaleView.getBounds().width, timeScaleView.getBounds().height);
        Rectangle rectangle2 = new Rectangle(0, timeScaleView.getBounds().height, taskTreeView.getBounds().width, taskTreeView.getBounds().height);
        Rectangle rectangle3 = new Rectangle(taskTreeView.getBounds().width, timeScaleView.getBounds().height, ganttChartView.getBounds().width, ganttChartView.getBounds().height);
        Rectangle rectangle4 = new Rectangle(0, 0, rectangle2.width, rectangle.height);
        logoView.setBounds(rectangle4);
        this.logger.debug((Object)("[Rectangle] main bounds" + dimension));
        this.logger.debug((Object)("[Rectangle] GanttChartView" + rectangle));
        this.logger.debug((Object)("[Rectangle] TimeScaleView" + rectangle2));
        this.logger.debug((Object)("[Rectangle] TaskTreeView" + rectangle3));
        if (string2.equals("png")) {
            SwingComponentImageGenerator.getInstance().generatePNGImage(dimension, new JComponent[]{ganttChartView, timeScaleView, taskTreeView, logoView}, new Rectangle[]{rectangle3, rectangle, rectangle2, rectangle4}, string);
        } else if (string2.equals("jpg")) {
            SwingComponentImageGenerator.getInstance().generateJPEGImage(dimension, new JComponent[]{ganttChartView, timeScaleView, taskTreeView, logoView}, new Rectangle[]{rectangle3, rectangle, rectangle2, rectangle4}, string);
        } else {
            throw new IOException("Only .png and .jpeg format are supported");
        }
    }

    public void addTimeUnitChangeListener(TimeUnitChangeListener timeUnitChangeListener) {
        this.listenerList.add(TimeUnitChangeListener.class, timeUnitChangeListener);
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        TimeUnit timeUnit2 = this.timeUnit;
        this.timeUnit = timeUnit;
        this.fireTimeUnitChange(this, (Object)timeUnit2, (Object)this.timeUnit);
    }

    public static Config getStaticConfig() {
        return config;
    }

    public Config getConfig() {
        return config;
    }

    public GanttModel getModel() {
        return this.model;
    }

    public void setModel(GanttModel ganttModel) {
        this.logger.debug((Object)"Set model to GanttChart");
        this.model = ganttModel;
        this.model.addGanttModelListener(this);
        this.logger.debug((Object)"Set time unit for TaskTreeModel");
        this.model.getTaskTreeModel().setTimeUnit(this.timeUnit);
        this.model.recalculate();
        this.totalSteps = this.calcTotalSteps(this.model.getKickoffTime(), this.model.getDeadline());
        this.tasksCount = this.model.getTaskTreeModel().getTasksCount() + 2;
        this.timeScaleView.setTotalSteps(this.totalSteps);
        this.ganttChartView.setTotalSteps(this.totalSteps);
        this.taskTreeView.setTaskCount(this.tasksCount);
        this.ganttChartView.setTaskCount(this.tasksCount);
        this.timeScaleView.refreshDisplay();
        this.taskTreeView.refreshDisplay();
        this.ganttChartView.refreshDisplay();
    }

    protected int calcTotalSteps(Calendar calendar, Calendar calendar2) {
        int n = 0;
        Calendar calendar3 = this.getModel().getTaskTreeModel().getEndTimeOfLatestTask();
        if (calendar3 != null && calendar2.before(calendar3)) {
            calendar2 = calendar3;
            this.logger.info((Object)("The deadline adjusted to " + calendar2.getTime() + " by latest task."));
        }
        n = TimeAxisUtils.getTimeIntervalByTimeUnit(this.getTimeUnit(), calendar, calendar2);
        n += config == null ? 2 : config.getBlankStepsToKickoffTime();
        this.logger.debug((Object)((n += config == null ? 10 : config.getBlankStepsToDeadline()) + " steps that needs to be drawn from [" + calendar.getTime() + "] to [" + calendar2.getTime() + "]"));
        return n;
    }

    public void fireTimeUnitChange(Object object, Object object2, Object object3) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != TimeUnitChangeListener.class) continue;
            TimeUnitChangeEvent timeUnitChangeEvent = new TimeUnitChangeEvent(object, object2, object3);
            ((TimeUnitChangeListener)objectArray[i + 1]).timeUnitChanged(timeUnitChangeEvent);
        }
    }

    public boolean isShowTreeView() {
        return this.showTreeView;
    }

    public void setShowTreeView(boolean bl) {
        this.showTreeView = bl;
        if (bl) {
            this.setRowHeaderView(this.taskTreeView);
        } else {
            this.setRowHeaderView(null);
        }
    }
}

