/*
 * Decompiled with CFR 0.152.
 */
package com.yuxingwang.gantt.model;

import com.yuxingwang.gantt.common.EventLogger;
import com.yuxingwang.gantt.common.LogHelper;
import com.yuxingwang.gantt.model.GanttModelChangeEvent;
import com.yuxingwang.gantt.model.GanttModelListener;
import com.yuxingwang.gantt.model.Task;
import com.yuxingwang.gantt.model.TaskTreeModel;
import java.util.Calendar;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class GanttModel {
    protected Logger logger = null;
    private Calendar KickoffTime = Calendar.getInstance();
    private Calendar Deadline = Calendar.getInstance();
    private TaskTreeModel taskTreeModel = new TaskTreeModel();
    protected transient GanttModelChangeEvent ganttModelChangeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();

    public GanttModel() {
        this.logger = LogManager.getLogger(this.getClass());
        LogHelper.title(this.logger, "Start to construct and initialize GanttModel");
        this.taskTreeModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                EventLogger.event(treeModelEvent, "treeNodesChanged()");
                Task task = (Task)treeModelEvent.getPath()[treeModelEvent.getPath().length - 1];
                GanttModel.this.fireGanttModelChange(treeModelEvent.getSource(), "TaskTreeModel", null, task);
            }

            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                EventLogger.event(treeModelEvent, "treeNodesInserted()");
                Task task = (Task)treeModelEvent.getPath()[treeModelEvent.getPath().length - 1];
                GanttModel.this.fireGanttModelChange(treeModelEvent.getSource(), "TaskTreeModel", null, task);
            }

            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                EventLogger.event(treeModelEvent, "treeNodesRemoved()");
                GanttModel.this.fireGanttModelChange(treeModelEvent.getSource(), "TaskTreeModel", treeModelEvent.getSource(), treeModelEvent.getTreePath());
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                EventLogger.event(treeModelEvent, "treeStructureChanged()");
                GanttModel.this.fireGanttModelChange(treeModelEvent.getSource(), "TaskTreeModel", treeModelEvent.getSource(), null);
            }
        });
    }

    public void addTask(Task[] taskArray) {
        for (int i = 0; i < taskArray.length; ++i) {
            this.addTask(taskArray[i]);
        }
    }

    public void addTask(Task task) {
        LogHelper.title(this.logger, "Add task : <" + task.toString() + "> to TaskTreeModel in GanttModel.");
        task.setId(this.taskTreeModel.getTasksCount());
        this.taskTreeModel.add(task);
        task.adjustActualTimesByPredecessor();
    }

    public void removeTask(Task task) {
        LogHelper.title(this.logger, "Remove task : <" + task.toString() + "> from TaskTreeModel in GanttModel.");
        this.taskTreeModel.removeTask(task);
    }

    public void removeAll() {
        LogHelper.title(this.logger, "Remove all tasks from TaskTreeModel in GanttModel.");
        this.taskTreeModel.removeAll();
    }

    public void recalculate() {
        for (Task task : this.taskTreeModel.getChildren()) {
            task.adjustActualTimesByPredecessor();
        }
    }

    public void addGanttModelListener(GanttModelListener ganttModelListener) {
        this.listenerList.add(GanttModelListener.class, ganttModelListener);
    }

    public Calendar getDeadline() {
        return this.Deadline;
    }

    public void setDeadline(Calendar calendar) {
        Calendar calendar2 = this.Deadline;
        this.Deadline = calendar;
        this.fireGanttModelChange(this, "Deadline", calendar2, calendar);
    }

    public Calendar getKickoffTime() {
        return this.KickoffTime;
    }

    public void setKickoffTime(Calendar calendar) {
        Calendar calendar2 = this.KickoffTime;
        this.KickoffTime = calendar;
        this.fireGanttModelChange(this, "KickoffTime", calendar2, calendar);
    }

    public TaskTreeModel getTaskTreeModel() {
        return this.taskTreeModel;
    }

    protected void fireGanttModelChange(Object object, String string, Object object2, Object object3) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != GanttModelListener.class) continue;
            this.ganttModelChangeEvent = new GanttModelChangeEvent(object, string, object2, object3);
            ((GanttModelListener)objectArray[i + 1]).ganttModelChanged(this.ganttModelChangeEvent);
        }
    }
}

