/*
 * Decompiled with CFR 0.152.
 */
package com.yuxingwang.gantt.model;

import com.yuxingwang.gantt.Config;
import com.yuxingwang.gantt.GanttChart;
import com.yuxingwang.gantt.common.CalendarUtils;
import com.yuxingwang.gantt.ui.TimeUnit;
import java.util.Calendar;
import yuxingwang.common.time.TimeFormatter;

public class TaskHelper {
    private TaskHelper() {
    }

    public static String formatTimeByTimeUnit(TimeUnit timeUnit, Calendar calendar) {
        String string = null;
        if (timeUnit == TimeUnit.Hour || timeUnit == TimeUnit.AllDay) {
            string = TimeFormatter.formatCalendar((Calendar)calendar, (String)"yyyy-MM-dd HH:mm:ss");
        } else if (timeUnit == TimeUnit.Day) {
            string = TimeFormatter.formatCalendar((Calendar)calendar, (String)"yyyy-MM-ddEEE");
        } else if (timeUnit == TimeUnit.Week) {
            string = TimeFormatter.formatCalendar((Calendar)calendar, (String)"yyyy-MM-dd");
        } else if (timeUnit == TimeUnit.Month) {
            string = TimeFormatter.formatCalendar((Calendar)calendar, (String)"yyyy-MM");
        } else if (timeUnit == TimeUnit.Year) {
            string = calendar.get(1) + "";
        }
        return string;
    }

    public static int calcOffsetByTimeUnit(TimeUnit timeUnit, Calendar calendar, Calendar calendar2) {
        int n = 0;
        if (timeUnit == TimeUnit.Hour || timeUnit == TimeUnit.AllDay) {
            n = CalendarUtils.getHourInterval(calendar, calendar2);
        } else if (timeUnit == TimeUnit.Day) {
            n = CalendarUtils.getDateInterval(calendar, calendar2);
        } else if (timeUnit == TimeUnit.Week) {
            n = CalendarUtils.getWeekInterval(calendar, calendar2);
        } else if (timeUnit == TimeUnit.Month) {
            n = CalendarUtils.getMonthInterval(calendar, calendar2);
        } else if (timeUnit == TimeUnit.Year) {
            n = CalendarUtils.getYearInterval(calendar, calendar2);
        }
        return n;
    }

    public static Calendar increaseCloneTimeByTimeUnit(TimeUnit timeUnit, Calendar calendar, int n) {
        if (calendar == null) {
            return null;
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        TaskHelper.increaseTimeByTimeUnit(timeUnit, calendar2, n);
        return calendar2;
    }

    public static void increaseTimeByTimeUnit(TimeUnit timeUnit, Calendar calendar, int n) {
        if (timeUnit == TimeUnit.Hour || timeUnit == TimeUnit.AllDay) {
            calendar.add(11, n);
        } else if (timeUnit == TimeUnit.Day) {
            calendar.add(5, n);
        } else if (timeUnit == TimeUnit.Week) {
            calendar.add(3, n);
        } else if (timeUnit == TimeUnit.Month) {
            calendar.add(2, n);
        } else if (timeUnit == TimeUnit.Year) {
            calendar.add(1, n);
        }
    }

    public static int getTimeCycleStepsByTimeUnit(TimeUnit timeUnit) {
        Config config = GanttChart.getStaticConfig();
        if (timeUnit == TimeUnit.Hour) {
            return 0 + config.getWorkingHoursOfDay() + 1;
        }
        if (timeUnit == TimeUnit.AllDay) {
            return 24;
        }
        if (timeUnit == TimeUnit.Day) {
            return 7;
        }
        if (timeUnit == TimeUnit.Week) {
            return 52;
        }
        if (timeUnit == TimeUnit.Month) {
            return 12;
        }
        if (timeUnit == TimeUnit.Year) {
            return 100;
        }
        return 0;
    }

    public static int calcActualStepForProgress(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = n3;
        int n9 = n4;
        int n10 = n6;
        int n11 = 0;
        if (n2 <= n9) {
            n11 = n5;
            n7 = n5;
        } else {
            n7 = n2 > n9 + n5 ? 0 : (n11 = n5 + n9 - n2 + 1);
        }
        if (n <= n11) {
            return n;
        }
        n -= n11;
        while (n >= n5) {
            n -= n5;
            n7 += n10 + n9 + n5;
        }
        if (n > 0) {
            n7 += n10 + n9 + n;
        }
        return n7;
    }
}

