/*
 * Decompiled with CFR 0.152.
 */
package com.yuxingwang.gantt.ui;

import com.yuxingwang.gantt.GanttChart;
import com.yuxingwang.gantt.common.EventLogger;
import com.yuxingwang.gantt.common.LogHelper;
import com.yuxingwang.gantt.model.GanttModel;
import com.yuxingwang.gantt.model.Task;
import com.yuxingwang.gantt.model.TaskHelper;
import com.yuxingwang.gantt.ui.BaseTaskRenderer;
import com.yuxingwang.gantt.ui.timeaxis.TimeAxisUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;

public class DefaultTaskRenderer
extends BaseTaskRenderer {
    private int connectorStyle = 1;
    private List<Task> tasks = null;

    public DefaultTaskRenderer(GanttChart ganttChart) {
        this.gantt = ganttChart;
        this.config = ganttChart.getConfig();
    }

    public void paint(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        super.paint(graphics, jComponent, rectangle);
        LogHelper.title(this.logger, "Start to paint for all tasks.");
        this.g = graphics;
        this.rect = rectangle;
        GanttModel ganttModel = this.gantt.getModel();
        this.tasks = ganttModel.getTaskTreeModel().getTasksByDFS();
        for (int i = 0; i < this.tasks.size(); ++i) {
            Task task = this.tasks.get(i);
            int n = super.calcTaskStartPointX(task);
            int n2 = super.calcTaskPointY(task, i);
            EventLogger.paintebug("Render the task: [" + i + "] '" + task + "'", new Point(n, n2), rectangle);
            if (task.isLeaf()) {
                int n3 = task.calcTaskSteps();
                this.drawLeafTask(n, n2, n3, task);
            } else {
                Task task2 = task.getEarliestTask();
                Task task3 = task.getLatestTask();
                int n4 = TimeAxisUtils.getTimeIntervalByTimeUnit(this.gantt.getTimeUnit(), task2.getActualStart(), task3.getActualEnd());
                String string = this.isDebug ? task.toSimpleString() : task.getName();
                this.drawNonLeafTask(n, n2, n4 + 1, string);
            }
            if (task.getPredecessors().size() <= 0) continue;
            this.drawConnectToPredecesor(task);
        }
    }

    private void drawNonLeafTask(int n, int n2, int n3, String string) {
        this.logger.info((Object)("Paint task group " + string + " at [" + n + "," + n2 + "], length is " + n3));
        int n4 = this.config.getTaskBarHeight() / 2;
        this.g.setColor(this.config.getTaskGroupBarBackColor());
        Polygon polygon = super.createDiamondShape(n, n2, n4);
        this.g.fillPolygon(polygon);
        polygon = super.createDiamondShape(n + n3 * this.step_length, n2, n4);
        this.g.fillPolygon(polygon);
        int n5 = n3 * this.step_length + n4 * 2;
        this.g.fillRect(n - n4, n2, n5, n4);
        this.g.setColor(Color.black);
        if (this.config.isShowTaskInfoBehindTaskBar()) {
            this.g.drawChars(string.toCharArray(), 0, string.length(), n + n5 + n4 * 2, n2 + 8);
        }
    }

    private void drawConnectToPredecesor(Task task) {
        this.logger.debug((Object)("    Paint connector lines from task: " + task + " to all it's " + task.getPredecessors().size() + " predecessors"));
        List list = task.getPredecessors();
        for (int i = 0; i < list.size(); ++i) {
            Task task2 = (Task)list.get(i);
            int n = TaskHelper.calcOffsetByTimeUnit(this.gantt.getTimeUnit(), task2.getActualEnd(), task.getActualStart()) - 1;
            this.logger.debug((Object)("        Distance from predecessor to task is " + n));
            if (n > 0) {
                this.drawDistantConnectToPredecessor(task, task2, n);
                continue;
            }
            this.drawCloseConnectToPredecessor(task, task2);
        }
    }

    private void drawCloseConnectToPredecessor(Task task, Task task2) {
        int n = 10;
        int n2 = this.tasks.indexOf(task);
        int n3 = this.tasks.indexOf(task2);
        int n4 = super.calcTaskStartPointX(task2);
        int n5 = super.calcTaskEndPointX(n4, task2);
        int n6 = super.calcTaskPointY(task2, n3);
        Point point = new Point(n5, n6 + this.task_bar_height / 2);
        Point point2 = new Point(n5 + n, point.y);
        Point point3 = new Point(point2.x, point.y + this.row_height / 2);
        Point point4 = new Point(n5 - n, point3.y);
        Point point5 = new Point(point4.x, n6 + this.task_bar_height / 2 + (n2 - n3) * this.row_height);
        Point point6 = new Point(n5, point5.y);
        this.g.drawLine(point.x, point.y, point2.x, point2.y);
        this.g.drawLine(point2.x, point2.y, point3.x, point3.y);
        this.g.drawLine(point3.x, point3.y, point4.x, point4.y);
        this.g.drawLine(point4.x, point4.y, point5.x, point5.y);
        this.g.drawLine(point5.x, point5.y, point6.x, point6.y);
        this.g.drawLine(point6.x - 5, point6.y + 3, point6.x, point6.y);
        this.g.drawLine(point6.x - 5, point6.y - 3, point6.x, point6.y);
    }

    private void drawDistantConnectToPredecessor(Task task, Task task2, int n) {
        int n2 = 10;
        int n3 = this.tasks.indexOf(task);
        int n4 = this.tasks.indexOf(task2);
        int n5 = super.calcTaskStartPointX(task2);
        int n6 = super.calcTaskEndPointX(n5, task2);
        int n7 = super.calcTaskPointY(task2, n4);
        Point point = new Point(n6, n7 + this.task_bar_height / 2);
        Point point2 = new Point(n6 + n * this.step_length, n7 + this.task_bar_height / 2 + (n3 - n4) * this.row_height);
        Point point3 = null;
        Point point4 = null;
        if (this.connectorStyle == 1) {
            point3 = new Point(point.x + n2, point.y);
            point4 = new Point(point3.x, point2.y);
        } else if (this.connectorStyle == 2) {
            point3 = new Point(point2.x - n2, point.y);
            point4 = new Point(point3.x, point2.y);
        }
        this.g.drawLine(point.x, point.y, point3.x, point3.y);
        this.g.drawLine(point3.x, point3.y, point4.x, point4.y);
        this.g.drawLine(point4.x, point4.y, point2.x, point2.y);
        this.g.drawLine(point2.x - 5, point2.y + 3, point2.x, point2.y);
        this.g.drawLine(point2.x - 5, point2.y - 3, point2.x, point2.y);
    }

    private void drawLeafTask(int n, int n2, int n3, Task task) {
        this.logger.info((Object)("Paint task " + task + " at [" + n + "," + n2 + "], length is " + n3));
        Color color = task.getBackcolor() != null ? task.getBackcolor() : this.config.getTaskBarBackColor();
        this.g.setColor(color);
        int n4 = n3 * this.step_length;
        this.g.fillRect(n, n2, n4, this.task_bar_height);
        Color color2 = this.config.getProgressBarBackColor();
        this.g.setColor(color2);
        int n5 = task.calcProgressSteps();
        if (n5 > n3) {
            n5 = n3;
        }
        int n6 = n2 + (this.task_bar_height - this.progress_bar_height) / 2;
        this.g.fillRect(n, n6, n5 * this.step_length, this.progress_bar_height);
        if (this.config.isShowTaskInfoBehindTaskBar()) {
            String string = this.isDebug ? task.toSimpleString() : task.getName();
            this.g.setColor(Color.black);
            this.g.drawChars(string.toCharArray(), 0, string.length(), n + n4 + 16, n2 + 16);
        }
    }
}

