/*
 * Decompiled with CFR 0.152.
 */
package com.yuxingwang.gantt.ui;

import com.yuxingwang.gantt.TaskTreeView;
import com.yuxingwang.gantt.common.EventLogger;
import com.yuxingwang.gantt.model.Task;
import com.yuxingwang.gantt.ui.BaseGanttChartUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class TaskTreeUI
extends BaseGanttChartUI {
    protected TaskTreeView taskTreeView = null;
    private final int NODE_WIDTH = 9;
    int fontHeight = 0;
    int rowHeight = 0;
    int cellWidth = 0;
    int hScrollOffset = 5;

    public static ComponentUI createUI(JComponent jComponent) {
        return new TaskTreeUI();
    }

    public void installUI(JComponent jComponent) {
        this.taskTreeView = (TaskTreeView)jComponent;
        super.installUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        this.logger.info((Object)"Paint TaskTreeUI");
        this.rowHeight = this.ganttChart.getConfig().getGanttChartRowHeight();
        this.cellWidth = this.rowHeight / 2;
        this.fontHeight = graphics.getFontMetrics().getHeight();
        int n = this.clientWidth;
        int n2 = this.clientHeight;
        graphics.setColor(this.ganttChart.getConfig().getTaskTreeViewBackColor());
        graphics.fillRect(-this.hScrollOffset, 0, n, n2);
        graphics.setColor(Color.black);
        this.drawTasks(graphics);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, n, n2 - 1);
    }

    private void drawTasks(Graphics graphics) {
        Task task = (Task)this.ganttChart.getModel().getTaskTreeModel().getRoot();
        int n = 0;
        for (int i = 0; i < task.getChildCount(); ++i) {
            Task task2 = (Task)task.getChildAt(i);
            Task task3 = i + 1 < task.getChildCount() ? (Task)task.getChildAt(i + 1) : null;
            n = this.drawTask(graphics, task2, task3, n);
        }
    }

    private int drawTask(Graphics graphics, Task task, Task task2, int n) {
        String string = task2 != null ? task2.getName() : "";
        this.logger.debug((Object)("Paint task " + task + " at row " + n + " to next " + string + " for task tree view."));
        int n2 = 0;
        int n3 = task.getLevel() * this.cellWidth - this.hScrollOffset;
        int n4 = n * this.rowHeight;
        graphics.drawLine(n3, n4 - this.cellWidth, n3, n4 + this.cellWidth);
        if (task2 != null) {
            EventLogger.paintebug("To next sibling: " + task2.getName());
            int n5 = (n + (n2 += task.getTasksCount()) + 1) * this.rowHeight;
            graphics.drawLine(n3, n4 + this.cellWidth, n3, n5 + this.cellWidth);
        }
        Rectangle rectangle = new Rectangle(n3, n4, this.taskTreeView.getWidth(), this.rowHeight);
        this.drawConnection(graphics, rectangle);
        if (!task.isLeaf()) {
            this.drawNode(graphics, rectangle);
            for (int i = 0; i < task.getChildCount(); ++i) {
                Task task3 = (Task)task.getChildAt(i);
                Task task4 = i + 1 < task.getChildCount() ? (Task)task.getChildAt(i + 1) : null;
                ++n;
                n = this.drawTask(graphics, task3, task4, n);
            }
        }
        this.drawLabel(graphics, task.getName(), rectangle);
        return n;
    }

    private void drawConnection(Graphics graphics, Rectangle rectangle) {
        int n = rectangle.x - this.hScrollOffset;
        int n2 = rectangle.x + this.cellWidth - this.hScrollOffset;
        int n3 = rectangle.y + this.cellWidth;
        graphics.drawLine(n, n3, n2, n3);
    }

    private void drawNode(Graphics graphics, Rectangle rectangle) {
        int n = rectangle.x - 4;
        int n2 = n + 9;
        int n3 = (this.rowHeight - 9) / 2 + rectangle.y;
        int n4 = n3 + 4 + 1;
        graphics.setColor(this.taskTreeView.getBackground());
        graphics.fillRect(n, n3, 9, 9);
        graphics.setColor(Color.black);
        graphics.drawRect(n, n3, 9, 9);
        graphics.drawLine(n, n4, n2, n4);
    }

    private void drawLabel(Graphics graphics, String string, Rectangle rectangle) {
        if (string == null) {
            return;
        }
        int n = rectangle.x + this.cellWidth;
        int n2 = rectangle.y + this.rowHeight - this.fontHeight / 2;
        int n3 = 1000;
        int n4 = this.fontHeight;
        graphics.setColor(this.ganttChart.getConfig().getTaskTreeViewBackColor());
        graphics.fillRect(n, rectangle.y, n3, n4);
        graphics.setColor(Color.black);
        graphics.drawChars(string.toCharArray(), 0, string.length(), n, n2);
    }

    public int getHorizonScrollOffset() {
        return this.hScrollOffset;
    }

    public void setHorizonScrollOffset(int n) {
        this.hScrollOffset = n;
    }
}

