/*
 * Decompiled with CFR 0.152.
 */
package com.yuxingwang.gantt.ui.timeaxis;

import com.yuxingwang.gantt.Config;
import com.yuxingwang.gantt.GanttChart;
import com.yuxingwang.gantt.GanttChartView;
import com.yuxingwang.gantt.TimeScaleView;
import com.yuxingwang.gantt.common.EventLogger;
import com.yuxingwang.gantt.common.PaintHelper;
import com.yuxingwang.gantt.ui.timeaxis.TimeAxis;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Calendar;
import javax.swing.JComponent;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class BaseTimeAxis
implements TimeAxis {
    public static int STEPS_OF_MAJOR_SCALE = 0;
    protected Logger logger = LogManager.getLogger(this.getClass());
    protected int stepsToFirstMajorScale = 0;
    protected int row_height = 0;
    protected int step_length = 0;
    protected Graphics g = null;
    protected JComponent component = null;
    protected GanttChart gantt = null;
    protected Calendar kickoffTime = null;
    protected Calendar firstStepOfChart = null;
    protected int totalStepsCount = 5;
    protected int totalMajorStepsCount = 0;
    protected Rectangle componentRect = null;
    protected Config config = null;

    public void paint(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        this.logger.info((Object)"Paint Time Axis");
        this.beforePaint();
        this.config = this.gantt.getConfig();
        this.component = jComponent;
        this.g = graphics;
        this.componentRect = rectangle;
        this.step_length = this.gantt.getConfig().getTimeUnitWidth();
        this.row_height = 24;
        this.kickoffTime = this.gantt.getModel().getKickoffTime();
        this.firstStepOfChart = this.getFirstStepTimeOfChart(this.kickoffTime);
    }

    protected void beforePaint() {
    }

    protected abstract Calendar getFirstStepTimeOfChart(Calendar var1);

    protected abstract int calcPositionInMajorScale(Calendar var1);

    protected void paintMutual() {
        EventLogger.paintebug("Start to paint mutual part of time axis for steps: " + this.totalStepsCount);
        int n = 0;
        int n2 = 0;
        if (this.component instanceof TimeScaleView) {
            EventLogger.paintebug("Paint for TimeAxisScaleView");
            this.g.setColor(this.gantt.getConfig().getGanttChartBackColor());
            this.g.fillRect(0, 0, this.componentRect.width - 1, this.row_height);
            this.g.setColor(Color.black);
            this.g.drawRect(0, 0, this.componentRect.width - 1, this.row_height);
            this.drawMajorTimeScaleBorder();
            n = this.row_height;
            n2 = this.componentRect.height - 1;
            this.drawMinorTimeScaleBackground(n, n2);
            this.g.setColor(Color.black);
            for (int i = 0; i < this.totalStepsCount; ++i) {
                this.g.drawRect(this.step_length * i, this.row_height, this.step_length, this.row_height);
            }
            this.g.drawRect(0, 0, this.componentRect.width - 1, this.componentRect.height - 1);
        } else if (this.component instanceof GanttChartView) {
            EventLogger.paintebug("Paint for GanttChartView");
            n2 = this.componentRect.height - 1;
            this.drawMinorTimeScaleBackground(0, n2);
            EventLogger.paintebug("The gantt chart view back color is " + this.gantt.getConfig().getGanttChartBackColor());
        }
    }

    protected abstract void drawMajorTimeScaleBorder();

    protected abstract String formatToMajorLabel(Calendar var1, int var2);

    protected abstract void drawMinorTimeScaleBackground(int var1, int var2);

    protected void drawMajorScaleSeperator() {
        this.g.setColor(Color.black);
        int n = STEPS_OF_MAJOR_SCALE * this.step_length;
        for (int i = 0; i < this.totalMajorStepsCount; ++i) {
            int n2 = i * n + this.stepsToFirstMajorScale * this.step_length;
            int n3 = this.componentRect.height;
            PaintHelper.drawDashedLine(this.g, n2, 0, n2, n3);
        }
    }

    protected void drawKickoffTime(int n, int n2) {
        EventLogger.paintebug("Draw Kickoff time at " + this.gantt.getConfig().getBlankStepsToKickoffTime());
        int n3 = this.step_length * this.gantt.getConfig().getBlankStepsToKickoffTime();
        this.drawKickoffOrDeadline(this.gantt.getConfig().getKickoffTimeBackColor(), n3, n, n2);
    }

    protected void drawDeadline(int n, int n2) {
        EventLogger.paintebug("The steps count " + this.totalStepsCount + ", the empty steps to deadline " + this.gantt.getConfig().getBlankStepsToDeadline());
        int n3 = this.step_length * (this.totalStepsCount - this.gantt.getConfig().getBlankStepsToDeadline());
        this.drawKickoffOrDeadline(this.gantt.getConfig().getDeadlineBackColor(), n3, n, n2);
    }

    private void drawKickoffOrDeadline(Color color, int n, int n2, int n3) {
        this.g.setColor(color);
        PaintHelper.fillBevelFoggyRect(this.g, n, n2, this.step_length, n3);
        this.g.setColor(Color.black);
        this.g.drawRect(n, n2, this.step_length, n3);
    }

    public int getTotalStepsCount() {
        return this.totalStepsCount;
    }

    public void setTotalStepsCount(int n) {
        this.totalStepsCount = n;
    }

    public int getStepsToFirstMajorScale() {
        return this.stepsToFirstMajorScale;
    }
}

