/*
 * Decompiled with CFR 0.152.
 */
package com.yuxingwang.gantt.ui.timeaxis;

import com.yuxingwang.gantt.GanttChart;
import com.yuxingwang.gantt.common.ResourceManager;
import com.yuxingwang.gantt.ui.timeaxis.BaseRestoutTimeAxis;
import java.awt.Color;
import java.util.Calendar;
import yuxingwang.common.time.TimeFormatter;

public class DailyTimeAxis
extends BaseRestoutTimeAxis {
    public DailyTimeAxis(GanttChart ganttChart) {
        super(ganttChart);
        STEPS_OF_MAJOR_SCALE = 7;
    }

    protected Calendar getFirstStepTimeOfChart(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(5, 0 - this.config.getBlankStepsToKickoffTime());
        return calendar2;
    }

    protected int calcPositionInMajorScale(Calendar calendar) {
        int n = calendar.get(7);
        return n;
    }

    protected String formatToMajorLabel(Calendar calendar, int n) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(5, this.stepsToFirstMajorScale + n * STEPS_OF_MAJOR_SCALE);
        String string = TimeFormatter.formatCalendar((Calendar)calendar2, (String)"yyyy/MM/dd");
        return string;
    }

    protected boolean isFreeTime(int n) {
        Calendar calendar = (Calendar)this.kickoffTime.clone();
        calendar.add(5, (n - this.config.getBlankStepsToKickoffTime()) % 7);
        int n2 = calendar.get(7);
        int[] nArray = this.gantt.getConfig().getWorkingDaysSpanOfWeek();
        return n2 >= nArray[0] && n2 <= nArray[1];
    }

    protected void drawMinorTimeScaleLabel(int n, int n2, int n3) {
        Calendar calendar = (Calendar)this.kickoffTime.clone();
        calendar.add(5, n - this.config.getBlankStepsToKickoffTime());
        String string = null;
        switch (calendar.get(7)) {
            case 2: {
                string = "Gantt.TimeAxis.Date.Monday";
                break;
            }
            case 3: {
                string = "Gantt.TimeAxis.Date.Tuesday";
                break;
            }
            case 4: {
                string = "Gantt.TimeAxis.Date.Wednesday";
                break;
            }
            case 5: {
                string = "Gantt.TimeAxis.Date.Thursday";
                break;
            }
            case 6: {
                string = "Gantt.TimeAxis.Date.Friday";
                break;
            }
            case 7: {
                string = "Gantt.TimeAxis.Date.Saturday";
                break;
            }
            case 1: {
                string = "Gantt.TimeAxis.Date.Sunday";
            }
        }
        this.g.setColor(Color.black);
        char[] cArray = ResourceManager.getInstance().getString(string).toCharArray();
        this.g.drawChars(cArray, 0, cArray.length, n2 + 4, n3 + this.row_height - 4);
    }
}

