/*
 * Decompiled with CFR 0.152.
 */
package com.yuxingwang.gantt.ui.timeaxis;

import com.yuxingwang.gantt.GanttChart;
import com.yuxingwang.gantt.ui.timeaxis.BaseRestoutTimeAxis;
import java.awt.Color;
import java.util.Calendar;
import yuxingwang.common.time.TimeFormatter;

public class HourlyTimeAxis
extends BaseRestoutTimeAxis {
    public HourlyTimeAxis(GanttChart ganttChart) {
        super(ganttChart);
        STEPS_OF_MAJOR_SCALE = ganttChart.getConfig().getWorkingHoursOfDay() + 1;
    }

    protected void beforePaint() {
        STEPS_OF_MAJOR_SCALE = this.gantt.getConfig().getWorkingHoursOfDay() + 1;
    }

    protected Calendar getFirstStepTimeOfChart(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(10, 0 - this.config.getBlankStepsToKickoffTime());
        return calendar2;
    }

    protected int calcPositionInMajorScale(Calendar calendar) {
        int n = 0;
        n = calendar.get(11) - GanttChart.getStaticConfig().getWorkingHoursSpanOfDay()[0] + 1;
        if (n > STEPS_OF_MAJOR_SCALE) {
            n = STEPS_OF_MAJOR_SCALE;
        }
        if (n <= 0) {
            n = 1;
        }
        return n;
    }

    protected String formatToMajorLabel(Calendar calendar, int n) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(5, n);
        String string = TimeFormatter.formatCalendar((Calendar)calendar2, (String)"yyyy-MM-dd");
        return string;
    }

    protected boolean isFreeTime(int n) {
        int n2 = 0;
        if (n >= this.stepsToFirstMajorScale) {
            n2 = (n - this.stepsToFirstMajorScale) % STEPS_OF_MAJOR_SCALE;
            return n2 == this.gantt.getConfig().getWorkingHoursOfDay();
        }
        return n == this.stepsToFirstMajorScale - 1;
    }

    protected void drawMinorTimeScaleLabel(int n, int n2, int n3) {
        if (this.isFreeTime(n)) {
            return;
        }
        int n4 = 0;
        n4 = (n - this.stepsToFirstMajorScale + STEPS_OF_MAJOR_SCALE) % STEPS_OF_MAJOR_SCALE;
        String string = n4 + GanttChart.getStaticConfig().getWorkingHoursSpanOfDay()[0] + "";
        this.g.setColor(Color.black);
        this.g.drawChars(string.toCharArray(), 0, string.length(), n2 + 4, n3 + this.row_height - 4);
    }
}

