/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.snmp.SnmpOidRecord;
import com.sun.jmx.snmp.SnmpOidTable;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.trace.Trace;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SnmpOidTableSupport
implements SnmpOidTable {
    String dbgTag = "SnmpOidTableSupport";
    private Hashtable oidStore = new Hashtable();
    private String myName;

    public SnmpOidTableSupport(String string) {
        this.myName = string;
    }

    public SnmpOidRecord resolveVarName(String string) throws SnmpStatusException {
        SnmpOidRecord snmpOidRecord = (SnmpOidRecord)this.oidStore.get(string);
        if (snmpOidRecord != null) {
            return snmpOidRecord;
        }
        throw new SnmpStatusException("Variable name <" + string + "> not found in Oid repository");
    }

    public SnmpOidRecord resolveVarOid(String string) throws SnmpStatusException {
        int n = string.indexOf(46);
        if (n < 0) {
            throw new SnmpStatusException("Variable oid <" + string + "> not found in Oid repository");
        }
        if (n == 0) {
            string = string.substring(1, string.length());
        }
        Enumeration enumeration = this.oidStore.elements();
        while (enumeration.hasMoreElements()) {
            SnmpOidRecord snmpOidRecord = (SnmpOidRecord)enumeration.nextElement();
            if (!snmpOidRecord.getOid().equals(string)) continue;
            return snmpOidRecord;
        }
        throw new SnmpStatusException("Variable oid <" + string + "> not found in Oid repository");
    }

    public Vector getAllEntries() {
        Vector vector = new Vector();
        Enumeration enumeration = this.oidStore.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public synchronized void loadMib(SnmpOidRecord[] snmpOidRecordArray) {
        try {
            int n = 0;
            while (true) {
                SnmpOidRecord snmpOidRecord = snmpOidRecordArray[n];
                if (this.isTraceOn()) {
                    this.trace("loadMib", "load " + snmpOidRecord.getName());
                }
                this.oidStore.put(snmpOidRecord.getName(), snmpOidRecord);
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof SnmpOidTableSupport)) {
            return false;
        }
        SnmpOidTableSupport snmpOidTableSupport = (SnmpOidTableSupport)object;
        return this.myName.equals(snmpOidTableSupport.getName());
    }

    public String getName() {
        return this.myName;
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 512);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 512, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 512);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 512, string, string2, string3);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }
}

